/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.UnaryMathFunction;

class CoshFunction
extends UnaryMathFunction {
    CoshFunction() {
    }

    @Override
    void apply(Interp interp, ExprValue[] values) throws TclException {
        ExprValue value = values[0];
        double x = value.getDoubleValue();
        double d1 = Math.pow(Math.E, x);
        double d2 = Math.pow(Math.E, -x);
        Expression.checkDoubleRange(interp, d1);
        Expression.checkDoubleRange(interp, d2);
        value.setDoubleValue((d1 + d2) / 2.0);
    }
}

