/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.Util;
import tcl.lang.Var;

class Env {
    Env() {
    }

    static void initialize(Interp interp) {
        try {
            interp.setVar("env", "CLASSPATH", Util.tryGetSystemProperty("java.class.path", ""), 1);
        }
        catch (TclException tclException) {}
        try {
            interp.setVar("env", "HOME", Util.tryGetSystemProperty("user.home", ""), 1);
        }
        catch (TclException tclException) {}
        try {
            interp.setVar("env", "USER", Util.tryGetSystemProperty("user.name", ""), 1);
        }
        catch (TclException tclException) {}
        try {
            Properties props = System.getProperties();
            Enumeration<?> list = props.propertyNames();
            while (list.hasMoreElements()) {
                String key = (String)list.nextElement();
                try {
                    interp.setVar("env", key, props.getProperty(key), 1);
                }
                catch (TclException tclException) {}
            }
            for (Map.Entry<String, String> env : System.getenv().entrySet()) {
                interp.setVar("env", env.getKey(), env.getValue(), 1);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Exception e3) {
            System.out.println("Exception while initializing env array");
            System.out.println(e3);
            System.out.println("");
        }
    }

    public static Map<String, String> getenv(Interp interp) {
        Var[] retArray = null;
        try {
            retArray = Var.lookupVar(interp, "env", null, 1, null, false, false);
        }
        catch (TclException tclException) {}
        if (retArray == null || retArray[0] == null || !retArray[0].isVarArray()) {
            try {
                return System.getenv();
            }
            catch (SecurityException securityException) {
                return Collections.unmodifiableMap(new HashMap());
            }
        }
        HashMap<String, String> env = new HashMap<String, String>();
        Map<String, Var> arrayMap = retArray[0].getArrayMap();
        for (Map.Entry<String, Var> envVar : arrayMap.entrySet()) {
            String value;
            if (envVar.getValue().isVarUndefined() || (value = envVar.getValue().getValue().toString()) == null) continue;
            env.put(envVar.getKey(), value);
        }
        return Collections.unmodifiableMap(env);
    }
}

