/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class ExecutionTrace {
    public static final int ENTER = 0;
    public static final int LEAVE = 1;
    public static final int ENTERSTEP = 2;
    public static final int LEAVESTEP = 3;
    private static final String[] op = new String[]{"enter", "leave", "enterstep", "leavestep"};
    private String callbackCmd;
    protected int type;
    protected boolean deleted = false;

    public ExecutionTrace(Interp interp, int type, TclObject callbackCmd) throws TclException {
        this.type = type;
        this.callbackCmd = callbackCmd.toString();
    }

    public int getType() {
        return this.type;
    }

    public String getCallbackCmd() {
        return this.callbackCmd;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void trace(Interp interp, int type, String commandString, int resultCode, TclObject result) throws TclException {
        if (type == this.type && !this.deleted) {
            StringBuffer sb = new StringBuffer(this.callbackCmd.length() + commandString.length() + (result == null ? 0 : result.toString().length()) + 16);
            sb.append(this.callbackCmd).append(" {").append(commandString).append("} ");
            switch (type) {
                case 0: 
                case 2: {
                    sb.append(op[type]);
                    break;
                }
                case 1: 
                case 3: {
                    String resultString = result.toString();
                    if (resultString.length() == 0) {
                        resultString = "{}";
                    }
                    sb.append(resultCode).append(" ").append(resultString).append(" ").append(op[type]);
                }
            }
            interp.eval(sb.toString(), 0);
        }
    }
}

