/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public final class ExprValue {
    public static final int INT = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    private long intValue;
    private double doubleValue;
    private String stringValue;
    private int type;
    private static final boolean validate = false;

    public ExprValue(long i, String s) {
        this.setIntValue(i, s);
    }

    public ExprValue(double d, String s) {
        this.setDoubleValue(d, s);
    }

    public ExprValue(String s) {
        this.setStringValue(s);
    }

    public ExprValue(boolean b) {
        this.setIntValue(b);
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isIntType() {
        return this.type == 0;
    }

    public final boolean isDoubleType() {
        return this.type == 1;
    }

    public final boolean isStringType() {
        return this.type == 2;
    }

    public final boolean isIntOrDoubleType() {
        return this.type == 0 || this.type == 1;
    }

    public final long getIntValue() {
        return this.intValue;
    }

    public final double getDoubleValue() {
        return this.doubleValue;
    }

    public final String getStringValue() {
        if (this.type != 2) {
            if (this.type == 0) {
                if (this.stringValue == null) {
                    this.stringValue = Long.toString(this.intValue);
                }
            } else if (this.type == 1 && this.stringValue == null) {
                this.stringValue = Util.printDouble(this.doubleValue);
            }
        }
        return this.stringValue;
    }

    public final boolean getBooleanValue(Interp interp) throws TclException {
        switch (this.type) {
            case 0: {
                return this.intValue != 0L;
            }
            case 1: {
                return this.doubleValue != 0.0;
            }
            case 2: {
                return Util.getBoolean(interp, this.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    public final void setIntValue(long value) {
        this.stringValue = null;
        this.intValue = value;
        this.type = 0;
    }

    public final void setIntValue(long value, String s) {
        this.stringValue = s;
        this.intValue = value;
        this.type = 0;
    }

    public final void setIntValue(boolean b) {
        this.stringValue = null;
        this.intValue = b ? 1 : 0;
        this.type = 0;
    }

    public final void setDoubleValue(double value) {
        this.stringValue = null;
        this.doubleValue = value;
        this.type = 1;
    }

    public final void setDoubleValue(double value, String s) {
        this.stringValue = s;
        this.doubleValue = value;
        this.type = 1;
    }

    public final void setStringValue(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.stringValue = s;
        this.type = 2;
    }

    public final void setValue(ExprValue value2) {
        this.type = value2.type;
        this.intValue = value2.intValue;
        this.doubleValue = value2.doubleValue;
        this.stringValue = value2.stringValue;
    }

    public final void nullStringValue() {
        this.stringValue = null;
    }

    final void toStringType() {
        if (this.type == 2) {
            throw new TclRuntimeError("called toStringType() on STRING type");
        }
        if (this.stringValue == null) {
            this.getStringValue();
        }
        this.type = 2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.type == 2) {
            sb.append("STRING \"" + this.stringValue + "\"");
        } else if (this.type == 0) {
            String intString;
            sb.append("INT \"" + this.intValue + "\"");
            if (this.stringValue != null && (intString = Long.toString(this.intValue)).compareTo(this.stringValue) != 0) {
                sb.append(" parsed from \"");
                sb.append(this.stringValue);
                sb.append("\"");
            }
        } else if (this.type == 1) {
            String doubleString;
            sb.append("DOUBLE \"" + this.doubleValue + "\"");
            if (this.stringValue != null && (doubleString = Util.printDouble(this.doubleValue)).compareTo(this.stringValue) != 0) {
                sb.append(" parsed from \"");
                sb.append(this.stringValue);
                sb.append("\"");
            }
        }
        return sb.toString();
    }

    final void optIntMult(ExprValue value2) {
        this.stringValue = null;
        this.intValue *= value2.intValue;
    }

    final void optDoubleMult(ExprValue value2) {
        this.stringValue = null;
        this.doubleValue *= value2.doubleValue;
    }

    public final void optIntPlus(ExprValue value2) {
        this.stringValue = null;
        this.intValue += value2.intValue;
    }

    final void optDoublePlus(ExprValue value2) {
        this.stringValue = null;
        this.doubleValue += value2.doubleValue;
    }

    final void optIntMinus(ExprValue value2) {
        this.stringValue = null;
        this.intValue -= value2.intValue;
    }

    final void optDoubleMinus(ExprValue value2) {
        this.stringValue = null;
        this.doubleValue -= value2.doubleValue;
    }

    final void optIntLess(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue < value2.intValue ? 1 : 0;
    }

    final void optDoubleLess(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue < value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntGreater(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue > value2.intValue ? 1 : 0;
    }

    final void optDoubleGreater(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue > value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntLessEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue <= value2.intValue ? 1 : 0;
    }

    final void optDoubleLessEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue <= value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntGreaterEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue >= value2.intValue ? 1 : 0;
    }

    final void optDoubleGreaterEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue >= value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue == value2.intValue ? 1 : 0;
    }

    final void optDoubleEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue == value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    final void optIntNotEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.intValue != value2.intValue ? 1 : 0;
    }

    final void optDoubleNotEq(ExprValue value2) {
        this.stringValue = null;
        this.intValue = this.doubleValue != value2.doubleValue ? 1 : 0;
        this.type = 0;
    }

    public final void optIntUnaryNot() {
        this.stringValue = null;
        this.intValue = this.intValue == 0L ? 1 : 0;
    }

    public final void optIntUnaryNotNstr() {
        this.intValue = this.intValue == 0L ? 1 : 0;
    }
}

