/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import tcl.lang.AbsFunction;
import tcl.lang.AcosFunction;
import tcl.lang.AsinFunction;
import tcl.lang.Atan2Function;
import tcl.lang.AtanFunction;
import tcl.lang.CeilFunction;
import tcl.lang.CosFunction;
import tcl.lang.CoshFunction;
import tcl.lang.DoubleFunction;
import tcl.lang.ExpFunction;
import tcl.lang.ExprValue;
import tcl.lang.FloorFunction;
import tcl.lang.FmodFunction;
import tcl.lang.HypotFunction;
import tcl.lang.IntFunction;
import tcl.lang.Interp;
import tcl.lang.Log10Function;
import tcl.lang.LogFunction;
import tcl.lang.MathFunction;
import tcl.lang.NoArgMathFunction;
import tcl.lang.ParseAdaptor;
import tcl.lang.ParseResult;
import tcl.lang.PowFunction;
import tcl.lang.RandFunction;
import tcl.lang.RoundFunction;
import tcl.lang.SinFunction;
import tcl.lang.SinhFunction;
import tcl.lang.SqrtFunction;
import tcl.lang.SrandFunction;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TanFunction;
import tcl.lang.TanhFunction;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.WideFunction;

public class Expression {
    public static final int VALUE = 0;
    public static final int OPEN_PAREN = 1;
    public static final int CLOSE_PAREN = 2;
    public static final int COMMA = 3;
    public static final int END = 4;
    public static final int UNKNOWN = 5;
    public static final int MULT = 8;
    public static final int DIVIDE = 9;
    public static final int MOD = 10;
    public static final int PLUS = 11;
    public static final int MINUS = 12;
    public static final int LEFT_SHIFT = 13;
    public static final int RIGHT_SHIFT = 14;
    public static final int LESS = 15;
    public static final int GREATER = 16;
    public static final int LEQ = 17;
    public static final int GEQ = 18;
    public static final int EQUAL = 19;
    public static final int NEQ = 20;
    public static final int BIT_AND = 21;
    public static final int BIT_XOR = 22;
    public static final int BIT_OR = 23;
    public static final int AND = 24;
    public static final int OR = 25;
    public static final int QUESTY = 26;
    public static final int COLON = 27;
    public static final int STREQ = 28;
    public static final int STRNEQ = 29;
    public static final int UNARY_MINUS = 30;
    public static final int UNARY_PLUS = 31;
    public static final int NOT = 32;
    public static final int BIT_NOT = 33;
    public static int[] precTable;
    public static String[] operatorStrings;
    public HashMap<String, MathFunction> mathFuncTable = new HashMap();
    private String m_expr;
    private int m_len;
    int m_token;
    private int m_ind;
    private ExprValue[] cachedExprValue;
    private int cachedExprIndex = 0;
    private static final int cachedExprLength = 50;

    static {
        int[] nArray = new int[34];
        nArray[8] = 12;
        nArray[9] = 12;
        nArray[10] = 12;
        nArray[11] = 11;
        nArray[12] = 11;
        nArray[13] = 10;
        nArray[14] = 10;
        nArray[15] = 9;
        nArray[16] = 9;
        nArray[17] = 9;
        nArray[18] = 9;
        nArray[19] = 8;
        nArray[20] = 8;
        nArray[21] = 7;
        nArray[22] = 6;
        nArray[23] = 5;
        nArray[24] = 4;
        nArray[25] = 3;
        nArray[26] = 2;
        nArray[27] = 1;
        nArray[28] = 8;
        nArray[29] = 8;
        nArray[30] = 13;
        nArray[31] = 13;
        nArray[32] = 13;
        nArray[33] = 13;
        precTable = nArray;
        operatorStrings = new String[]{"VALUE", "(", ")", ",", "END", "UNKNOWN", "6", "7", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "eq", "ne", "-", "+", "!", "~"};
    }

    public void evalSetResult(Interp interp, String string) throws TclException {
        ExprValue value = this.ExprTopLevel(interp, string);
        switch (value.getType()) {
            case 0: {
                interp.setResult(value.getIntValue());
                break;
            }
            case 1: {
                interp.setResult(value.getDoubleValue());
                break;
            }
            case 2: {
                interp.setResult(value.getStringValue());
                break;
            }
            default: {
                throw new TclRuntimeError("internal error: expression, unknown");
            }
        }
        this.releaseExprValue(value);
    }

    public boolean evalBoolean(Interp interp, String string) throws TclException {
        ExprValue value = this.ExprTopLevel(interp, string);
        boolean b = value.getBooleanValue(interp);
        this.releaseExprValue(value);
        return b;
    }

    public Expression() {
        this.registerMathFunction("atan2", new Atan2Function());
        this.registerMathFunction("pow", new PowFunction());
        this.registerMathFunction("acos", new AcosFunction());
        this.registerMathFunction("asin", new AsinFunction());
        this.registerMathFunction("atan", new AtanFunction());
        this.registerMathFunction("ceil", new CeilFunction());
        this.registerMathFunction("cos", new CosFunction());
        this.registerMathFunction("cosh", new CoshFunction());
        this.registerMathFunction("exp", new ExpFunction());
        this.registerMathFunction("floor", new FloorFunction());
        this.registerMathFunction("fmod", new FmodFunction());
        this.registerMathFunction("hypot", new HypotFunction());
        this.registerMathFunction("log", new LogFunction());
        this.registerMathFunction("log10", new Log10Function());
        this.registerMathFunction("rand", new RandFunction());
        this.registerMathFunction("sin", new SinFunction());
        this.registerMathFunction("sinh", new SinhFunction());
        this.registerMathFunction("sqrt", new SqrtFunction());
        this.registerMathFunction("srand", new SrandFunction());
        this.registerMathFunction("tan", new TanFunction());
        this.registerMathFunction("tanh", new TanhFunction());
        this.registerMathFunction("abs", new AbsFunction());
        this.registerMathFunction("double", new DoubleFunction());
        this.registerMathFunction("int", new IntFunction());
        this.registerMathFunction("wide", new WideFunction());
        this.registerMathFunction("round", new RoundFunction());
        this.m_expr = null;
        this.m_ind = 0;
        this.m_len = 0;
        this.m_token = 5;
        this.cachedExprValue = new ExprValue[50];
        int i = 0;
        while (i < 50) {
            this.cachedExprValue[i] = new ExprValue(0L, null);
            ++i;
        }
    }

    private final ExprValue ExprTopLevel(Interp interp, String string) throws TclException {
        String m_expr_saved = this.m_expr;
        int m_len_saved = this.m_len;
        int m_token_saved = this.m_token;
        int m_ind_saved = this.m_ind;
        try {
            this.m_expr = string;
            this.m_ind = 0;
            this.m_len = string.length();
            this.m_token = 5;
            ExprValue val = this.ExprGetValue(interp, -1);
            if (this.m_token != 4) {
                this.SyntaxError(interp);
            }
            ExprValue exprValue = val;
            return exprValue;
        }
        finally {
            this.m_expr = m_expr_saved;
            this.m_len = m_len_saved;
            this.m_token = m_token_saved;
            this.m_ind = m_ind_saved;
        }
    }

    static void IllegalType(Interp interp, int badType, int operator) throws TclException {
        throw new TclException(interp, "can't use " + (badType == 1 ? "floating-point value" : "non-numeric string") + " as operand of \"" + operatorStrings[operator] + "\"");
    }

    void SyntaxError(Interp interp) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\"");
    }

    void SyntaxError(Interp interp, String whyMsg) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\": " + whyMsg);
    }

    static void DivideByZero(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DIVZERO {divide by zero}"));
        throw new TclException(interp, "divide by zero");
    }

    public static void IntegerTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
        throw new TclException(interp, "integer value too large to represent");
    }

    static void DoubleTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH OVERFLOW {floating-point value too large to represent}"));
        throw new TclException(interp, "floating-point value too large to represent");
    }

    static void DoubleTooSmall(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH UNDERFLOW {floating-point value too small to represent}"));
        throw new TclException(interp, "floating-point value too small to represent");
    }

    static void DomainError(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance("ARITH DOMAIN {domain error: argument not in valid range}"));
        throw new TclException(interp, "domain error: argument not in valid range");
    }

    static void EmptyStringOperandError(Interp interp, int operator) throws TclException {
        throw new TclException(interp, "can't use empty string as operand of \"" + operatorStrings[operator] + "\"");
    }

    public static void ExprParseObject(Interp interp, TclObject obj, ExprValue value) throws TclException {
        if (obj.isIntType()) {
            value.setIntValue(obj.ivalue, obj.hasNoStringRep() ? null : obj.toString());
            return;
        }
        if (obj.isDoubleType()) {
            value.setDoubleValue(((TclDouble)obj.getInternalRep()).value, obj.hasNoStringRep() ? null : obj.toString());
            return;
        }
        Expression.ExprParseString(interp, obj, value);
    }

    public static void ExprParseString(Interp interp, TclObject obj, ExprValue value) {
        char c;
        String s = obj.toString();
        int len = s.length();
        switch (len) {
            case 0: {
                value.setStringValue("");
                return;
            }
            case 1: {
                char c2 = s.charAt(0);
                switch (c2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        long ival = c2 - 48;
                        value.setIntValue(ival, s);
                        TclInteger.exprSetInternalRep(obj, ival);
                        return;
                    }
                }
                value.setStringValue(s);
                return;
            }
            case 2: {
                c = s.charAt(0);
                if (c != '-') break;
                c = s.charAt(1);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        long ival = -(c - 48);
                        value.setIntValue(ival, s);
                        TclInteger.exprSetInternalRep(obj, ival);
                        return;
                    }
                }
                break;
            }
            case 3: {
                c = s.charAt(1);
                if (c != '.') break;
                if (s.equals("0.0")) {
                    double dval = 0.0;
                    value.setDoubleValue(dval, s);
                    TclDouble.exprSetInternalRep(obj, dval);
                    return;
                }
                if (s.equals("0.5")) {
                    double dval = 0.5;
                    value.setDoubleValue(dval, s);
                    TclDouble.exprSetInternalRep(obj, dval);
                    return;
                }
                if (s.equals("1.0")) {
                    double dval = 1.0;
                    value.setDoubleValue(dval, s);
                    TclDouble.exprSetInternalRep(obj, dval);
                    return;
                }
                if (!s.equals("2.0")) break;
                double dval = 2.0;
                value.setDoubleValue(dval, s);
                TclDouble.exprSetInternalRep(obj, dval);
                return;
            }
            case 4: {
                if (!s.equalsIgnoreCase("true")) break;
                value.setStringValue(s);
                return;
            }
            case 5: {
                if (!s.equalsIgnoreCase("false")) break;
                value.setStringValue(s);
                return;
            }
        }
        if (Expression.looksLikeInt(s, len, 0, false)) {
            StrtoulResult res = interp.strtoulResult;
            Util.strtoul(s, 0, 0, res);
            if (res.errno == 0) {
                boolean trailing_blanks = true;
                int i = res.index;
                while (i < len) {
                    c = s.charAt(i);
                    if (c != ' ' && !Character.isWhitespace(c)) {
                        trailing_blanks = false;
                        break;
                    }
                    ++i;
                }
                if (trailing_blanks) {
                    long ival = res.value;
                    value.setIntValue(ival, s);
                    TclInteger.exprSetInternalRep(obj, ival);
                    return;
                }
            }
        } else {
            StrtodResult res = interp.strtodResult;
            Util.strtod(s, 0, len, res);
            if (res.errno == 0) {
                boolean trailing_blanks = true;
                int i = res.index;
                while (i < len) {
                    c = s.charAt(i);
                    if (c != ' ' && !Character.isWhitespace(c)) {
                        trailing_blanks = false;
                        break;
                    }
                    ++i;
                }
                if (trailing_blanks) {
                    double dval = res.value;
                    value.setDoubleValue(dval, s);
                    TclDouble.exprSetInternalRep(obj, dval);
                    return;
                }
            }
        }
        value.setStringValue(s);
    }

    private ExprValue ExprGetValue(Interp interp, int prec) throws TclException {
        int operator;
        boolean gotOp = false;
        ExprValue value2 = null;
        ExprValue value = this.ExprLex(interp);
        if (this.m_token == 1) {
            value = this.ExprGetValue(interp, -1);
            if (this.m_token != 2) {
                this.SyntaxError(interp, "looking for close parenthesis");
            }
        } else {
            if (this.m_token == 12) {
                this.m_token = 30;
            }
            if (this.m_token == 11) {
                this.m_token = 31;
            }
            if (this.m_token >= 30) {
                operator = this.m_token;
                value = this.ExprGetValue(interp, precTable[this.m_token]);
                if (interp.noEval == 0) {
                    Expression.evalUnaryOperator(interp, operator, value);
                }
                gotOp = true;
            } else {
                if (this.m_token == 2) {
                    return null;
                }
                if (this.m_token != 0) {
                    if (this.m_token >= 8) {
                        this.SyntaxError(interp, "unexpected operator " + operatorStrings[this.m_token]);
                    } else if (this.m_token == 5) {
                        this.SyntaxError(interp, "character not legal in expressions");
                    } else {
                        this.SyntaxError(interp, "premature end of expression");
                    }
                }
            }
        }
        if (value == null) {
            this.SyntaxError(interp);
        }
        if (!gotOp) {
            value2 = this.ExprLex(interp);
        }
        while (true) {
            if ((operator = this.m_token) < 8 || operator >= 30) {
                if (operator == 4 || operator == 2 || operator == 3) {
                    return value;
                }
                this.SyntaxError(interp, "extra tokens at end of expression");
            }
            if (precTable[operator] <= prec) {
                return value;
            }
            if (operator == 24 || operator == 25 || operator == 26) {
                if (value.isDoubleType()) {
                    value.setIntValue(value.getDoubleValue() != 0.0);
                } else if (value.isStringType()) {
                    try {
                        boolean b = Util.getBoolean(interp, value.getStringValue());
                        value.setIntValue(b);
                    }
                    catch (TclException e) {
                        if (interp.noEval == 0) {
                            throw e;
                        }
                        value.setIntValue(0L);
                    }
                }
                if (operator == 24 && value.getIntValue() == 0L || operator == 25 && value.getIntValue() != 0L) {
                    ++interp.noEval;
                    try {
                        value2 = this.ExprGetValue(interp, precTable[operator]);
                    }
                    finally {
                        --interp.noEval;
                    }
                    if (operator != 25) continue;
                    value.setIntValue(1L);
                    continue;
                }
                if (operator == 26) {
                    if (value.getIntValue() != 0L) {
                        value = this.ExprGetValue(interp, precTable[26] - 1);
                        if (this.m_token != 27) {
                            this.SyntaxError(interp);
                        }
                        ++interp.noEval;
                        try {
                            value2 = this.ExprGetValue(interp, precTable[26] - 1);
                        }
                        finally {
                            --interp.noEval;
                        }
                        continue;
                    }
                    ++interp.noEval;
                    try {
                        value2 = this.ExprGetValue(interp, precTable[26] - 1);
                    }
                    finally {
                        --interp.noEval;
                    }
                    if (this.m_token != 27) {
                        this.SyntaxError(interp);
                    }
                    value = this.ExprGetValue(interp, precTable[26] - 1);
                    continue;
                }
                value2 = this.ExprGetValue(interp, precTable[operator]);
            } else {
                value2 = this.ExprGetValue(interp, precTable[operator]);
            }
            if (value2 == null) {
                this.SyntaxError(interp);
            }
            if (this.m_token < 8 && this.m_token != 0 && this.m_token != 4 && this.m_token != 3 && this.m_token != 2) {
                this.SyntaxError(interp);
            }
            if (interp.noEval != 0) continue;
            if (operator == 27) {
                this.SyntaxError(interp);
            }
            Expression.evalBinaryOperator(interp, operator, value, value2);
            this.releaseExprValue(value2);
        }
    }

    public static void evalUnaryOperator(Interp interp, int operator, ExprValue value) throws TclException {
        switch (operator) {
            case 30: {
                if (value.isIntType()) {
                    value.setIntValue(value.getIntValue() * -1L);
                    break;
                }
                if (value.isDoubleType()) {
                    value.setDoubleValue(value.getDoubleValue() * -1.0);
                    break;
                }
                Expression.IllegalType(interp, value.getType(), operator);
                break;
            }
            case 31: {
                if (value.isIntOrDoubleType()) {
                    value.nullStringValue();
                    break;
                }
                Expression.IllegalType(interp, value.getType(), operator);
                break;
            }
            case 32: {
                if (value.isIntType()) {
                    value.optIntUnaryNot();
                    break;
                }
                if (value.isDoubleType()) {
                    value.setIntValue(value.getDoubleValue() == 0.0);
                    break;
                }
                if (value.isStringType()) {
                    String tok;
                    String s = value.getStringValue();
                    int s_len = s.length();
                    if (s_len == 0) {
                        Expression.EmptyStringOperandError(interp, operator);
                    }
                    if ((tok = Expression.getBooleanToken(s)) != null && tok.length() == s_len) {
                        if ("true".startsWith(tok.toLowerCase()) || "on".startsWith(tok.toLowerCase()) || "yes".startsWith(tok.toLowerCase())) {
                            value.setIntValue(0L);
                            break;
                        }
                        value.setIntValue(1L);
                        break;
                    }
                    Expression.IllegalType(interp, value.getType(), operator);
                    break;
                }
                Expression.IllegalType(interp, value.getType(), operator);
                break;
            }
            case 33: {
                if (value.isIntType()) {
                    value.setIntValue(value.getIntValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                Expression.IllegalType(interp, value.getType(), operator);
                break;
            }
            default: {
                throw new TclException(interp, "unknown operator in expression");
            }
        }
    }

    public static void evalBinaryOperator(Interp interp, int operator, ExprValue value, ExprValue value2) throws TclException {
        int t1 = value.getType();
        int t2 = value2.getType();
        switch (operator) {
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                if (t1 == 2 || t2 == 2) {
                    if (value.getStringValue().length() == 0 || value2.getStringValue().length() == 0) {
                        Expression.EmptyStringOperandError(interp, operator);
                    }
                    Expression.IllegalType(interp, 2, operator);
                    break;
                }
                if (t1 == 1) {
                    if (t2 != 0) break;
                    value2.setDoubleValue(value2.getIntValue());
                    t2 = 1;
                    break;
                }
                if (t2 != 1 || t1 != 0) break;
                value.setDoubleValue(value.getIntValue());
                t1 = 1;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: {
                if (t1 != 0) {
                    if (value.getStringValue().length() == 0) {
                        Expression.EmptyStringOperandError(interp, operator);
                    }
                    Expression.IllegalType(interp, value.getType(), operator);
                    break;
                }
                if (t2 == 0) break;
                if (value2.getStringValue().length() == 0) {
                    Expression.EmptyStringOperandError(interp, operator);
                }
                Expression.IllegalType(interp, value2.getType(), operator);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (t1 == t2) break;
                if (t1 == 2) {
                    if (t2 == 2) break;
                    value2.toStringType();
                    t2 = 2;
                    break;
                }
                if (t2 == 2) {
                    if (t1 == 2) break;
                    value.toStringType();
                    t1 = 2;
                    break;
                }
                if (t1 == 1) {
                    if (t2 != 0) break;
                    value2.setDoubleValue(value2.getIntValue());
                    t2 = 1;
                    break;
                }
                if (t2 != 1 || t1 != 0) break;
                value.setDoubleValue(value.getIntValue());
                t1 = 1;
                break;
            }
            case 28: {
                value.setIntValue(value.getStringValue().equals(value2.getStringValue()));
                return;
            }
            case 29: {
                value.setIntValue(!value.getStringValue().equals(value2.getStringValue()));
                return;
            }
            case 24: 
            case 25: {
                if (t1 == 2) {
                    Expression.IllegalType(interp, 2, operator);
                }
                if (t2 != 2) break;
                boolean b = Util.getBoolean(interp, value2.getStringValue());
                value2.setIntValue(b);
                break;
            }
            case 26: 
            case 27: {
                break;
            }
            default: {
                throw new TclException(interp, "unknown operator in expression");
            }
        }
        switch (operator) {
            case 8: {
                if (t1 == 0) {
                    value.optIntMult(value2);
                    break;
                }
                value.optDoubleMult(value2);
                break;
            }
            case 9: {
                if (t1 == 0) {
                    long quotient;
                    if (value2.getIntValue() == 0L) {
                        Expression.DivideByZero(interp);
                    }
                    long dividend = value.getIntValue();
                    long divisor = value2.getIntValue();
                    if (dividend == Long.MIN_VALUE && divisor == -1L) {
                        quotient = Long.MIN_VALUE;
                    } else {
                        quotient = dividend / divisor;
                        if ((quotient < 0L || quotient == 0L && (dividend < 0L && divisor > 0L || dividend > 0L && divisor < 0L)) && quotient * divisor != dividend) {
                            --quotient;
                        }
                    }
                    value.setIntValue(quotient);
                    break;
                }
                double divisor = value2.getDoubleValue();
                if (divisor == 0.0) {
                    Expression.DivideByZero(interp);
                }
                value.setDoubleValue(value.getDoubleValue() / divisor);
                break;
            }
            case 10: {
                long remainder;
                boolean neg_divisor = false;
                if (value2.getIntValue() == 0L) {
                    Expression.DivideByZero(interp);
                }
                long dividend = value.getIntValue();
                long divisor = value2.getIntValue();
                if (dividend == Long.MIN_VALUE && divisor == -1L) {
                    remainder = 0L;
                } else {
                    if (divisor < 0L) {
                        divisor = -divisor;
                        dividend = -dividend;
                        neg_divisor = true;
                    }
                    if (!((remainder = dividend % divisor) >= 0L || neg_divisor && dividend == Long.MIN_VALUE)) {
                        remainder += divisor;
                    }
                }
                if (neg_divisor && remainder > 0L || !neg_divisor && remainder < 0L) {
                    remainder = -remainder;
                }
                value.setIntValue(remainder);
                break;
            }
            case 11: {
                if (t1 == 0) {
                    value.optIntPlus(value2);
                    break;
                }
                value.optDoublePlus(value2);
                break;
            }
            case 12: {
                if (t1 == 0) {
                    value.optIntMinus(value2);
                    break;
                }
                value.optDoubleMinus(value2);
                break;
            }
            case 13: {
                long left_shift_num = value.getIntValue();
                long left_shift_by = value2.getIntValue();
                left_shift_num = left_shift_by >= 64L ? 0L : (left_shift_num <<= (int)left_shift_by);
                value.setIntValue(left_shift_num);
                break;
            }
            case 14: {
                long right_shift_num = value.getIntValue();
                long right_shift_by = value2.getIntValue();
                right_shift_num = right_shift_by >= 64L ? (right_shift_num < 0L ? -1L : 0L) : (right_shift_num >>= (int)right_shift_by);
                value.setIntValue(right_shift_num);
                break;
            }
            case 15: {
                if (t1 == 0) {
                    value.optIntLess(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleLess(value2);
                    break;
                }
                value.setIntValue(value.getStringValue().compareTo(value2.getStringValue()) < 0);
                break;
            }
            case 16: {
                if (t1 == 0) {
                    value.optIntGreater(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleGreater(value2);
                    break;
                }
                value.setIntValue(value.getStringValue().compareTo(value2.getStringValue()) > 0);
                break;
            }
            case 17: {
                if (t1 == 0) {
                    value.optIntLessEq(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleLessEq(value2);
                    break;
                }
                value.setIntValue(value.getStringValue().compareTo(value2.getStringValue()) <= 0);
                break;
            }
            case 18: {
                if (t1 == 0) {
                    value.optIntGreaterEq(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleGreaterEq(value2);
                    break;
                }
                value.setIntValue(value.getStringValue().compareTo(value2.getStringValue()) >= 0);
                break;
            }
            case 19: {
                if (t1 == 0) {
                    value.optIntEq(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleEq(value2);
                    break;
                }
                value.setIntValue(value.getStringValue().equals(value2.getStringValue()));
                break;
            }
            case 20: {
                if (t1 == 0) {
                    value.optIntNotEq(value2);
                    break;
                }
                if (t1 == 1) {
                    value.optDoubleNotEq(value2);
                    break;
                }
                value.setIntValue(!value.getStringValue().equals(value2.getStringValue()));
                break;
            }
            case 21: {
                value.setIntValue(value.getIntValue() & value2.getIntValue());
                break;
            }
            case 22: {
                value.setIntValue(value.getIntValue() ^ value2.getIntValue());
                break;
            }
            case 23: {
                value.setIntValue(value.getIntValue() | value2.getIntValue());
                break;
            }
            case 24: {
                if (t2 == 1) {
                    value2.setIntValue(value2.getDoubleValue() != 0.0);
                }
                value.setIntValue(value.getIntValue() != 0L && value2.getIntValue() != 0L);
                break;
            }
            case 25: {
                if (t2 == 1) {
                    value2.setIntValue(value2.getDoubleValue() != 0.0);
                }
                value.setIntValue(value.getIntValue() != 0L || value2.getIntValue() != 0L);
            }
        }
    }

    private ExprValue ExprLex(Interp interp) throws TclException {
        char c;
        while (this.m_ind < this.m_len && ((c = this.m_expr.charAt(this.m_ind)) == ' ' || Character.isWhitespace(c))) {
            ++this.m_ind;
        }
        if (this.m_ind >= this.m_len) {
            this.m_token = 4;
            return null;
        }
        c = this.m_expr.charAt(this.m_ind);
        char c2 = this.m_ind < this.m_len - 1 ? this.m_expr.charAt(this.m_ind + 1) : (char)'\u0000';
        if (c != '+' && c != '-') {
            boolean startsWithDigit;
            if (this.m_ind == this.m_len - 1) {
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++this.m_ind;
                        this.m_token = 0;
                        ExprValue value = this.grabExprValue();
                        value.setIntValue(c - 48, String.valueOf(c));
                        return value;
                    }
                }
            }
            if ((startsWithDigit = Character.isDigit(c)) && Expression.looksLikeInt(this.m_expr, this.m_len, this.m_ind, false)) {
                res = interp.strtoulResult;
                Util.strtoul(this.m_expr, this.m_ind, 0, (StrtoulResult)res);
                if (((StrtoulResult)res).errno == 0) {
                    String token = this.m_expr.substring(this.m_ind, ((StrtoulResult)res).index);
                    this.m_ind = ((StrtoulResult)res).index;
                    this.m_token = 0;
                    ExprValue value = this.grabExprValue();
                    value.setIntValue(((StrtoulResult)res).value, token);
                    return value;
                }
                if (((StrtoulResult)res).errno == -2) {
                    Expression.IntegerTooLarge(interp);
                }
            } else if (startsWithDigit || c == '.' || c == 'n' || c == 'N') {
                res = interp.strtodResult;
                Util.strtod(this.m_expr, this.m_ind, -1, (StrtodResult)res);
                if (((StrtodResult)res).errno == 0) {
                    String token = this.m_expr.substring(this.m_ind, ((StrtodResult)res).index);
                    this.m_ind = ((StrtodResult)res).index;
                    this.m_token = 0;
                    ExprValue value = this.grabExprValue();
                    value.setDoubleValue(((StrtodResult)res).value, token);
                    return value;
                }
                if (((StrtodResult)res).errno == -4) {
                    if (((StrtodResult)res).value != 0.0) {
                        Expression.DoubleTooLarge(interp);
                    } else {
                        Expression.DoubleTooSmall(interp);
                    }
                }
            }
        }
        ++this.m_ind;
        switch (c) {
            case '$': {
                ExprValue retval;
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseVar(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    retval = this.grabExprValue();
                    retval.setIntValue(0L);
                } else {
                    retval = this.grabExprValue();
                    Expression.ExprParseObject(interp, pres.value, retval);
                }
                pres.release();
                return retval;
            }
            case '[': {
                ExprValue retval;
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseNestedCmd(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    retval = this.grabExprValue();
                    retval.setIntValue(0L);
                } else {
                    retval = this.grabExprValue();
                    Expression.ExprParseObject(interp, pres.value, retval);
                }
                pres.release();
                return retval;
            }
            case '\"': {
                ExprValue retval;
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseQuotes(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    retval = this.grabExprValue();
                    retval.setIntValue(0L);
                } else {
                    retval = this.grabExprValue();
                    Expression.ExprParseObject(interp, pres.value, retval);
                }
                pres.release();
                return retval;
            }
            case '{': {
                ExprValue retval;
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseBraces(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    retval = this.grabExprValue();
                    retval.setIntValue(0L);
                } else {
                    retval = this.grabExprValue();
                    Expression.ExprParseObject(interp, pres.value, retval);
                }
                pres.release();
                return retval;
            }
            case '(': {
                this.m_token = 1;
                return null;
            }
            case ')': {
                this.m_token = 2;
                return null;
            }
            case ',': {
                this.m_token = 3;
                return null;
            }
            case '*': {
                this.m_token = 8;
                return null;
            }
            case '/': {
                this.m_token = 9;
                return null;
            }
            case '%': {
                this.m_token = 10;
                return null;
            }
            case '+': {
                this.m_token = 11;
                return null;
            }
            case '-': {
                this.m_token = 12;
                return null;
            }
            case '?': {
                this.m_token = 26;
                return null;
            }
            case ':': {
                this.m_token = 27;
                return null;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        ++this.m_ind;
                        this.m_token = 13;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 17;
                        break;
                    }
                    default: {
                        this.m_token = 15;
                    }
                }
                return null;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        ++this.m_ind;
                        this.m_token = 14;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 18;
                        break;
                    }
                    default: {
                        this.m_token = 16;
                    }
                }
                return null;
            }
            case '=': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 19;
                } else {
                    this.m_token = 5;
                }
                return null;
            }
            case '!': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 20;
                } else {
                    this.m_token = 32;
                }
                return null;
            }
            case '&': {
                if (c2 == '&') {
                    ++this.m_ind;
                    this.m_token = 24;
                } else {
                    this.m_token = 21;
                }
                return null;
            }
            case '^': {
                this.m_token = 22;
                return null;
            }
            case '|': {
                if (c2 == '|') {
                    ++this.m_ind;
                    this.m_token = 25;
                } else {
                    this.m_token = 23;
                }
                return null;
            }
            case '~': {
                this.m_token = 33;
                return null;
            }
            case 'e': 
            case 'n': {
                if (c == 'e' && c2 == 'q') {
                    ++this.m_ind;
                    this.m_token = 28;
                    return null;
                }
                if (c != 'n' || c2 != 'e') break;
                ++this.m_ind;
                this.m_token = 29;
                return null;
            }
        }
        if (Character.isLetter(c)) {
            String tok;
            --this.m_ind;
            String substr = this.m_expr.substring(this.m_ind);
            boolean is_math_func = false;
            int max = substr.length();
            int i = 0;
            while (i < max) {
                c = substr.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '_') break;
                ++i;
            }
            while (i < max) {
                c = substr.charAt(i);
                if (c != ' ' && !Character.isWhitespace(c)) break;
                ++i;
            }
            if (i < max && substr.charAt(i) == '(') {
                is_math_func = true;
            }
            if (!is_math_func && (tok = Expression.getBooleanToken(substr)) != null) {
                this.m_ind += tok.length();
                this.m_token = 0;
                ExprValue value = this.grabExprValue();
                value.setStringValue(tok);
                return value;
            }
            return this.mathFunction(interp);
        }
        this.m_token = 5;
        return null;
    }

    ExprValue mathFunction(Interp interp) throws TclException {
        int startIdx = this.m_ind;
        ExprValue[] values = null;
        while (this.m_ind < this.m_len) {
            if (!Character.isLetterOrDigit(this.m_expr.charAt(this.m_ind)) && this.m_expr.charAt(this.m_ind) != '_') break;
            ++this.m_ind;
        }
        String funcName = this.m_expr.substring(startIdx, this.m_ind);
        MathFunction mathFunc = this.mathFuncTable.get(funcName);
        this.ExprLex(interp);
        if (this.m_token != 1) {
            if (mathFunc == null) {
                this.SyntaxError(interp, "variable references require preceding $");
            } else {
                this.SyntaxError(interp, "expected parenthesis enclosing function arguments");
            }
        }
        if (mathFunc == null) {
            throw new TclException(interp, "unknown math function \"" + funcName + "\"");
        }
        int numArgs = mathFunc.argTypes.length;
        if (numArgs == 0) {
            this.ExprLex(interp);
            if (this.m_token != 2) {
                this.SyntaxError(interp, "missing close parenthesis at end of function call");
            }
        } else {
            values = new ExprValue[numArgs];
            int i = 0;
            while (true) {
                ExprValue value;
                if ((value = this.ExprGetValue(interp, -1)) == null && this.m_token == 2) {
                    if (i == numArgs) break;
                    throw new TclException(interp, "too few arguments for math function");
                }
                values[i] = value;
                if (i == numArgs - 1) {
                    if (this.m_token == 2) break;
                    if (this.m_token == 3) {
                        throw new TclException(interp, "too many arguments for math function");
                    }
                    this.SyntaxError(interp, "missing close parenthesis at end of function call");
                }
                if (this.m_token != 3) {
                    if (this.m_token == 2) {
                        throw new TclException(interp, "too few arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                ++i;
            }
        }
        this.m_token = 0;
        if (interp.noEval != 0) {
            ExprValue rvalue = this.grabExprValue();
            rvalue.setIntValue(0L);
            return rvalue;
        }
        ExprValue rvalue = this.grabExprValue();
        this.evalMathFunction(interp, funcName, mathFunc, values, true, rvalue);
        return rvalue;
    }

    public void evalMathFunction(Interp interp, String funcName, ExprValue[] values, boolean releaseValues, ExprValue result) throws TclException {
        MathFunction mathFunc = this.mathFuncTable.get(funcName);
        if (mathFunc == null) {
            throw new TclException(interp, "unknown math function \"" + funcName + "\"");
        }
        this.evalMathFunction(interp, funcName, mathFunc, values, releaseValues, result);
    }

    void evalMathFunction(Interp interp, String funcName, MathFunction mathFunc, ExprValue[] values, boolean releaseValues, ExprValue result) throws TclException {
        int i;
        if (mathFunc.argTypes == null) {
            throw new TclRuntimeError("math function \"" + funcName + "\" has null argTypes");
        }
        int numArgs = mathFunc.argTypes.length;
        int expectedArgs = 0;
        if (values != null) {
            expectedArgs = values.length;
        }
        if (numArgs != expectedArgs) {
            if (expectedArgs > 0 && expectedArgs < numArgs) {
                throw new TclException(interp, "too few arguments for math function");
            }
            throw new TclException(interp, "too many arguments for math function");
        }
        if (values != null) {
            i = 0;
            while (i < values.length) {
                ExprValue value = values[i];
                if (value.isStringType()) {
                    throw new TclException(interp, "argument to math function didn't have numeric value");
                }
                if (value.isIntType()) {
                    if (mathFunc.argTypes[i] == 1) {
                        value.setDoubleValue(value.getIntValue());
                    }
                } else if (mathFunc.argTypes[i] == 0) {
                    value.setIntValue((long)value.getDoubleValue());
                }
                ++i;
            }
        }
        if (mathFunc instanceof NoArgMathFunction) {
            ((NoArgMathFunction)mathFunc).apply(interp, result);
        } else {
            mathFunc.apply(interp, values);
            if (result != null) {
                result.setValue(values[0]);
            }
        }
        if (releaseValues && values != null) {
            i = 0;
            while (i < values.length) {
                this.releaseExprValue(values[i]);
                ++i;
            }
        }
    }

    void registerMathFunction(String name, MathFunction mathFunc) {
        this.mathFuncTable.put(name, mathFunc);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean looksLikeInt(String s, int len, int i, boolean whole) {
        char c = '\u0000';
        while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        if (c == '+' || c == '-') {
            if (++i >= len) {
                return false;
            }
            c = s.charAt(i);
        }
        if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
            return false;
        }
        ++i;
        while (i < len) {
            c = s.charAt(i);
            if ((c < '0' || c > '9') && !Character.isDigit(c)) break;
            ++i;
        }
        if (i >= len) {
            return true;
        }
        if (!whole && c != '.' && c != 'E' && c != 'e') {
            return true;
        }
        if (c == 'e' || c == 'E') {
            if (whole) {
                return false;
            }
            if (i + 1 >= len) {
                return true;
            }
            c = s.charAt(i + 1);
            if (c != '+' && c != '-' && !Character.isDigit(c)) {
                return true;
            }
        }
        if (whole) {
            while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
                ++i;
            }
            if (i >= len) {
                return true;
            }
        }
        return false;
    }

    static void checkIntegerRange(Interp interp, double d) throws TclException {
        if (d < 0.0) {
            if (d < -9.223372036854776E18) {
                Expression.IntegerTooLarge(interp);
            }
        } else if (d > 9.223372036854776E18) {
            Expression.IntegerTooLarge(interp);
        }
    }

    static void checkDoubleRange(Interp interp, double d) throws TclException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            Expression.DoubleTooLarge(interp);
        }
    }

    static String getBooleanToken(String tok) {
        int length = (tok = tok.toLowerCase()).length();
        if (length == 0) {
            return null;
        }
        char c = tok.charAt(0);
        switch (c) {
            case 'f': {
                if (tok.startsWith("false")) {
                    return "false";
                }
                if (tok.startsWith("fals")) {
                    return "fals";
                }
                if (tok.startsWith("fal")) {
                    return "fal";
                }
                if (tok.startsWith("fa")) {
                    return "fa";
                }
                if (tok.startsWith("f")) {
                    return "f";
                }
            }
            case 'n': {
                if (tok.startsWith("no")) {
                    return "no";
                }
                if (tok.startsWith("n")) {
                    return "n";
                }
            }
            case 'o': {
                if (tok.startsWith("off")) {
                    return "off";
                }
                if (tok.startsWith("of")) {
                    return "of";
                }
                if (tok.startsWith("on")) {
                    return "on";
                }
            }
            case 't': {
                if (tok.startsWith("true")) {
                    return "true";
                }
                if (tok.startsWith("tru")) {
                    return "tru";
                }
                if (tok.startsWith("tr")) {
                    return "tr";
                }
                if (tok.startsWith("t")) {
                    return "t";
                }
            }
            case 'y': {
                if (tok.startsWith("yes")) {
                    return "yes";
                }
                if (tok.startsWith("ye")) {
                    return "ye";
                }
                if (!tok.startsWith("y")) break;
                return "y";
            }
        }
        return null;
    }

    public final ExprValue grabExprValue() {
        if (this.cachedExprIndex == 50) {
            return new ExprValue(0L, null);
        }
        return this.cachedExprValue[this.cachedExprIndex++];
    }

    public final void releaseExprValue(ExprValue val) {
        if (this.cachedExprIndex > 0) {
            this.cachedExprValue[--this.cachedExprIndex] = val;
        }
    }
}

