/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class IdleHandler {
    Notifier notifier;
    boolean isCancelled;
    int generation;

    public IdleHandler() {
        this.isCancelled = false;
        this.generation = 0;
        this.notifier = null;
    }

    public IdleHandler(Notifier n) {
        this.register(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Notifier n) {
        this.notifier = n;
        this.isCancelled = false;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            this.notifier.idleList.add(this);
            this.generation = this.notifier.idleGeneration;
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            int i = 0;
            while (i < this.notifier.idleList.size()) {
                if (this.notifier.idleList.get(i) == this) {
                    this.notifier.idleList.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processIdleEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processIdleEvent();

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("IdleHandler.generation is " + this.generation + "\n");
        return sb.toString();
    }
}

