/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import tcl.lang.AssocData;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.EventuallyFreed;
import tcl.lang.ExecutionTrace;
import tcl.lang.Expression;
import tcl.lang.Extension;
import tcl.lang.FileUtil;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.Namespace;
import tcl.lang.Notifier;
import tcl.lang.PackageNameException;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.Resolver;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclInterruptedException;
import tcl.lang.TclInterruptedExceptionEvent;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileChannel;
import tcl.lang.channel.ReadInputStreamChannel;
import tcl.lang.cmd.EncodingCmd;
import tcl.lang.cmd.InterpAliasCmd;
import tcl.lang.cmd.InterpSlaveCmd;
import tcl.lang.cmd.PackageCmd;
import tcl.lang.cmd.RegexpCmd;

public class Interp
extends EventuallyFreed {
    public HashMap reflectObjTable = new HashMap();
    public long reflectObjCount = 0L;
    public HashMap reflectConflictTable = new HashMap();
    private static final int MAX_ERR_LENGTH = 200;
    public static final String TCL_VERSION = "8.4";
    public static final String TCL_PATCH_LEVEL = "8.4.0";
    public int cmdCount;
    public HashMap<String, Channel> interpChanTable;
    public boolean systemEncodingChangesStdoutStderr = true;
    private Notifier notifier;
    HashMap<String, AssocData> assocData;
    private File workingDir;
    public CallFrame frame;
    public CallFrame varFrame;
    Namespace globalNs;
    public HashMap hiddenCmdTable;
    public HashMap slaveTable;
    public HashMap targetTable;
    public InterpSlaveCmd slave;
    public HashMap aliasTable;
    public String scriptFile;
    public int nestLevel;
    private int maxNestingDepth = 1000;
    public int evalFlags;
    int flags;
    public boolean isSafe;
    public int termOffset;
    ArrayList resolvers;
    public Expression expr;
    int noEval;
    boolean randSeedInit;
    long randSeed;
    public String errorInfo;
    public String errorCode;
    public int returnCode;
    protected boolean deleted;
    public boolean errInProgress;
    public boolean errAlreadyLogged;
    protected boolean errCodeSet;
    public int errorLine = 0;
    private TclObject m_result;
    private final TclObject m_nullResult;
    private final TclObject m_falseBooleanResult;
    private final TclObject m_trueBooleanResult;
    private final TclObject m_minusoneIntegerResult;
    private final TclObject m_zeroIntegerResult;
    private final TclObject m_oneIntegerResult;
    private final TclObject m_twoIntegerResult;
    private final TclObject m_zeroDoubleResult;
    private final TclObject m_onehalfDoubleResult;
    private final TclObject m_oneDoubleResult;
    private final TclObject m_twoDoubleResult;
    private static final boolean VALIDATE_SHARED_RESULTS = false;
    private TclObject recycledI;
    private TclObject recycledD;
    private final TclObject[] m_charCommon;
    private final int m_charCommonMax = 128;
    private Thread cThread;
    private String cThreadName;
    public HashMap packageTable;
    public String packageUnknown;
    TclObject[][][] parserObjv;
    int[] parserObjvUsed;
    TclToken[] parserTokens;
    int parserTokensUsed;
    public HashMap[] importTable = new HashMap[]{new HashMap(), new HashMap(), new HashMap()};
    public StrtoulResult strtoulResult = new StrtoulResult();
    public StrtodResult strtodResult = new StrtodResult();
    public Namespace.GetNamespaceForQualNameResult getnfqnResult = new Namespace.GetNamespaceForQualNameResult();
    Var[] lookupVarResult = new Var[2];
    static final String[] unsafeCmds = new String[]{"encoding", "exit", "load", "cd", "fconfigure", "file", "glob", "open", "pwd", "socket", "beep", "echo", "ls", "resource", "source", "exec", "jaclloadjava", "jaclloadtjc", "auto_execok", "auto_import", "auto_load", "auto_load_index", "auto_qualify"};
    public static final int INVOKE_HIDDEN = 1;
    public static final int INVOKE_NO_UNKNOWN = 2;
    public static final int INVOKE_NO_TRACEBACK = 4;
    TclClassLoader classLoader = null;
    static HashMap tclLibraryScripts = new HashMap();
    private TclInterruptedExceptionEvent interruptedEvent = null;
    ArrayList<WrappedCommand> activeExecutionStepTraces = null;
    boolean stepTracingEnabled = true;
    public static ManagedSystemInStream systemIn = new ManagedSystemInStream();
    private String nameOfExecutable = null;
    private String shellClassName;
    protected DebugInfo dbg;
    public Stack<Object[]> nestedEvalOffsets = new Stack();

    public Interp() {
        this.m_nullResult = TclString.newInstance("");
        this.m_nullResult.preserve();
        this.m_nullResult.preserve();
        this.m_result = this.m_nullResult;
        this.m_minusoneIntegerResult = TclInteger.newInstance(-1L);
        this.m_minusoneIntegerResult.preserve();
        this.m_minusoneIntegerResult.preserve();
        this.m_zeroIntegerResult = TclInteger.newInstance(0L);
        this.m_zeroIntegerResult.preserve();
        this.m_zeroIntegerResult.preserve();
        this.m_oneIntegerResult = TclInteger.newInstance(1L);
        this.m_oneIntegerResult.preserve();
        this.m_oneIntegerResult.preserve();
        this.m_falseBooleanResult = this.m_zeroIntegerResult;
        this.m_trueBooleanResult = this.m_oneIntegerResult;
        this.m_twoIntegerResult = TclInteger.newInstance(2L);
        this.m_twoIntegerResult.preserve();
        this.m_twoIntegerResult.preserve();
        this.m_zeroDoubleResult = TclDouble.newInstance(0.0);
        this.m_zeroDoubleResult.preserve();
        this.m_zeroDoubleResult.preserve();
        this.m_onehalfDoubleResult = TclDouble.newInstance(0.5);
        this.m_onehalfDoubleResult.preserve();
        this.m_onehalfDoubleResult.preserve();
        this.m_oneDoubleResult = TclDouble.newInstance(1.0);
        this.m_oneDoubleResult.preserve();
        this.m_oneDoubleResult.preserve();
        this.m_twoDoubleResult = TclDouble.newInstance(2.0);
        this.m_twoDoubleResult.preserve();
        this.m_twoDoubleResult.preserve();
        this.m_charCommon = new TclObject[128];
        int i = 0;
        while (i < 128) {
            TclObject obj = null;
            if (i < 32 && (i == 9 || i == 13 || i == 10) || i >= 32 && i <= 126) {
                String s = "" + (char)i;
                s = s.intern();
                obj = TclString.newInstance(s);
            }
            this.m_charCommon[i] = obj;
            if (obj != null) {
                obj.preserve();
                obj.preserve();
            }
            ++i;
        }
        this.recycledI = TclInteger.newInstance(0L);
        this.recycledI.preserve();
        this.recycledD = TclDouble.newInstance(0.0);
        this.recycledD.preserve();
        this.expr = new Expression();
        this.nestLevel = 0;
        this.frame = null;
        this.varFrame = null;
        this.returnCode = 0;
        this.errorInfo = null;
        this.errorCode = null;
        this.packageTable = new HashMap();
        this.packageUnknown = null;
        this.cmdCount = 0;
        this.termOffset = 0;
        this.resolvers = null;
        this.evalFlags = 0;
        this.scriptFile = null;
        this.flags = 0;
        this.isSafe = false;
        this.assocData = null;
        this.globalNs = null;
        this.globalNs = Namespace.createNamespace(this, null, null);
        if (this.globalNs == null) {
            throw new TclRuntimeError("Interp(): can't create global namespace");
        }
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.noEval = 0;
        this.cThread = Thread.currentThread();
        this.cThreadName = this.cThread.getName();
        this.notifier = Notifier.getNotifierForThread(this.cThread);
        this.notifier.preserve();
        this.randSeedInit = false;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.dbg = this.initDebugInfo();
        this.slaveTable = new HashMap();
        this.targetTable = new HashMap();
        this.aliasTable = new HashMap();
        Throwable t = new Throwable();
        StackTraceElement[] es = t.getStackTrace();
        this.shellClassName = es[es.length - 1].getClassName();
        Parser.init(this);
        TclParse.init(this);
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.setVar("tcl_platform", "engine", "JTcl", 1);
            this.setVar("tcl_platform", "platform", "java", 1);
            this.setVar("tcl_platform", "byteOrder", "bigEndian", 1);
            this.setVar("tcl_platform", "user", Util.tryGetSystemProperty("user.name", "unknown"), 1);
            this.setVar("tcl_platform", "os", Util.tryGetSystemProperty("os.name", "?"), 1);
            this.setVar("tcl_platform", "osVersion", Util.tryGetSystemProperty("os.version", "?"), 1);
            this.setVar("tcl_platform", "machine", Util.tryGetSystemProperty("os.arch", "?"), 1);
            this.setVar("tcl_version", TCL_VERSION, 1);
            this.setVar("tcl_patchLevel", TCL_PATCH_LEVEL, 1);
            this.setVar("tcl_library", "resource:/tcl/lang/library", 1);
            if (Util.isWindows()) {
                this.setVar("tcl_platform", "host_platform", "windows", 1);
            } else if (Util.isMac()) {
                this.setVar("tcl_platform", "host_platform", "macintosh", 1);
            } else {
                this.setVar("tcl_platform", "host_platform", "unix", 1);
            }
            Env.initialize(this);
            this.pkgProvide("Tcl", TCL_VERSION);
            this.evalResource("/tcl/lang/library/init.tcl");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
    }

    @Override
    public void dispose() {
        if (Thread.currentThread() != this.cThread) {
            throw new TclRuntimeError("Interp.dispose() invoked in thread other than the one it was created in");
        }
        if (!this.deleted) {
            this.deleted = true;
        }
        super.dispose();
    }

    @Override
    public void eventuallyDispose() {
        if (!this.deleted) {
            throw new TclRuntimeError("eventuallyDispose called on interpreter not marked deleted");
        }
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier == null) {
            throw new TclRuntimeError("eventuallyDispose() already invoked for " + this);
        }
        this.notifier.release();
        this.notifier = null;
        Namespace.teardownNamespace(this.globalNs);
        TclObject errorInfoObj = null;
        TclObject errorCodeObj = null;
        try {
            errorInfoObj = this.getVar("errorInfo", null, 1);
        }
        catch (TclException tclException) {}
        if (errorInfoObj != null) {
            errorInfoObj.preserve();
        }
        try {
            errorCodeObj = this.getVar("errorCode", null, 1);
        }
        catch (TclException tclException) {}
        if (errorCodeObj != null) {
            errorCodeObj.preserve();
        }
        this.frame = null;
        this.varFrame = null;
        try {
            if (errorInfoObj != null) {
                this.setVar("errorInfo", null, errorInfoObj, 1);
                errorInfoObj.release();
            }
            if (errorCodeObj != null) {
                this.setVar("errorCode", null, errorCodeObj, 1);
                errorCodeObj.release();
            }
        }
        catch (TclException tclException) {}
        this.expr = null;
        while (this.assocData != null) {
            HashMap<String, AssocData> table = this.assocData;
            this.assocData = null;
            Iterator<Map.Entry<String, AssocData>> iter = table.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, AssocData> entry = iter.next();
                AssocData data = entry.getValue();
                data.disposeAssocData(this);
                iter.remove();
            }
        }
        for (Map.Entry<String, Channel> entry : this.interpChanTable.entrySet()) {
            Channel chan = entry.getValue();
            try {
                chan.close();
            }
            catch (IOException iOException) {}
        }
        this.interpChanTable.clear();
        this.interpChanTable = null;
        Namespace.deleteNamespace(this.globalNs);
        this.globalNs = null;
        this.frame = null;
        this.varFrame = null;
        this.resolvers = null;
        if (this.classLoader != null) {
            this.classLoader.dispose();
            this.classLoader = null;
        }
        systemIn.dispose();
        this.resetResult();
    }

    public void ready() throws TclException {
        this.resetResult();
        if (this.deleted) {
            this.setResult("attempt to call eval in deleted interpreter");
            this.setErrorCode(TclString.newInstance("CORE IDELETE {attempt to call eval in deleted interpreter}"));
            throw new TclException(1);
        }
        if (this.nestLevel >= this.maxNestingDepth) {
            Parser.infiniteLoopException(this);
        }
    }

    protected void createCommands() {
        Extension.loadOnDemand(this, "after", "tcl.lang.cmd.AfterCmd");
        Extension.loadOnDemand(this, "append", "tcl.lang.cmd.AppendCmd");
        Extension.loadOnDemand(this, "apply", "tcl.lang.cmd.ApplyCmd");
        Extension.loadOnDemand(this, "array", "tcl.lang.cmd.ArrayCmd");
        Extension.loadOnDemand(this, "binary", "tcl.lang.cmd.BinaryCmd");
        Extension.loadOnDemand(this, "break", "tcl.lang.cmd.BreakCmd");
        Extension.loadOnDemand(this, "case", "tcl.lang.cmd.CaseCmd");
        Extension.loadOnDemand(this, "catch", "tcl.lang.cmd.CatchCmd");
        Extension.loadOnDemand(this, "cd", "tcl.lang.cmd.CdCmd");
        Extension.loadOnDemand(this, "clock", "tcl.lang.cmd.ClockCmd");
        Extension.loadOnDemand(this, "close", "tcl.lang.cmd.CloseCmd");
        Extension.loadOnDemand(this, "continue", "tcl.lang.cmd.ContinueCmd");
        Extension.loadOnDemand(this, "concat", "tcl.lang.cmd.ConcatCmd");
        Extension.loadOnDemand(this, "dict", "tcl.lang.cmd.DictCmd");
        Extension.loadOnDemand(this, "encoding", "tcl.lang.cmd.EncodingCmd");
        Extension.loadOnDemand(this, "eof", "tcl.lang.cmd.EofCmd");
        Extension.loadOnDemand(this, "eval", "tcl.lang.cmd.EvalCmd");
        Extension.loadOnDemand(this, "error", "tcl.lang.cmd.ErrorCmd");
        if (!Util.isMac()) {
            Extension.loadOnDemand(this, "exec", "tcl.lang.cmd.ExecCmd");
        }
        Extension.loadOnDemand(this, "exit", "tcl.lang.cmd.ExitCmd");
        Extension.loadOnDemand(this, "expr", "tcl.lang.cmd.ExprCmd");
        Extension.loadOnDemand(this, "fblocked", "tcl.lang.cmd.FblockedCmd");
        Extension.loadOnDemand(this, "fconfigure", "tcl.lang.cmd.FconfigureCmd");
        Extension.loadOnDemand(this, "fcopy", "tcl.lang.cmd.FcopyCmd");
        Extension.loadOnDemand(this, "file", "tcl.lang.cmd.FileCmd");
        Extension.loadOnDemand(this, "fileevent", "tcl.lang.cmd.FileeventCmd");
        Extension.loadOnDemand(this, "flush", "tcl.lang.cmd.FlushCmd");
        Extension.loadOnDemand(this, "for", "tcl.lang.cmd.ForCmd");
        Extension.loadOnDemand(this, "foreach", "tcl.lang.cmd.ForeachCmd");
        Extension.loadOnDemand(this, "format", "tcl.lang.cmd.FormatCmd");
        Extension.loadOnDemand(this, "gets", "tcl.lang.cmd.GetsCmd");
        Extension.loadOnDemand(this, "global", "tcl.lang.cmd.GlobalCmd");
        Extension.loadOnDemand(this, "glob", "tcl.lang.cmd.GlobCmd");
        Extension.loadOnDemand(this, "if", "tcl.lang.cmd.IfCmd");
        Extension.loadOnDemand(this, "incr", "tcl.lang.cmd.IncrCmd");
        Extension.loadOnDemand(this, "info", "tcl.lang.cmd.InfoCmd");
        Extension.loadOnDemand(this, "interp", "tcl.lang.cmd.InterpCmd");
        Extension.loadOnDemand(this, "list", "tcl.lang.cmd.ListCmd");
        Extension.loadOnDemand(this, "join", "tcl.lang.cmd.JoinCmd");
        Extension.loadOnDemand(this, "lappend", "tcl.lang.cmd.LappendCmd");
        Extension.loadOnDemand(this, "lassign", "tcl.lang.cmd.LassignCmd");
        Extension.loadOnDemand(this, "lindex", "tcl.lang.cmd.LindexCmd");
        Extension.loadOnDemand(this, "linsert", "tcl.lang.cmd.LinsertCmd");
        Extension.loadOnDemand(this, "llength", "tcl.lang.cmd.LlengthCmd");
        Extension.loadOnDemand(this, "lrange", "tcl.lang.cmd.LrangeCmd");
        Extension.loadOnDemand(this, "lrepeat", "tcl.lang.cmd.LrepeatCmd");
        Extension.loadOnDemand(this, "lreplace", "tcl.lang.cmd.LreplaceCmd");
        Extension.loadOnDemand(this, "lreverse", "tcl.lang.cmd.LreverseCmd");
        Extension.loadOnDemand(this, "lsearch", "tcl.lang.cmd.LsearchCmd");
        Extension.loadOnDemand(this, "lset", "tcl.lang.cmd.LsetCmd");
        Extension.loadOnDemand(this, "lsort", "tcl.lang.cmd.LsortCmd");
        Extension.loadOnDemand(this, "namespace", "tcl.lang.cmd.NamespaceCmd");
        Extension.loadOnDemand(this, "open", "tcl.lang.cmd.OpenCmd");
        Extension.loadOnDemand(this, "package", "tcl.lang.cmd.PackageCmd");
        Extension.loadOnDemand(this, "pid", "tcl.lang.cmd.PidCmd");
        Extension.loadOnDemand(this, "proc", "tcl.lang.cmd.ProcCmd");
        Extension.loadOnDemand(this, "puts", "tcl.lang.cmd.PutsCmd");
        Extension.loadOnDemand(this, "pwd", "tcl.lang.cmd.PwdCmd");
        Extension.loadOnDemand(this, "read", "tcl.lang.cmd.ReadCmd");
        Extension.loadOnDemand(this, "regsub", "tcl.lang.cmd.RegsubCmd");
        Extension.loadOnDemand(this, "rename", "tcl.lang.cmd.RenameCmd");
        Extension.loadOnDemand(this, "return", "tcl.lang.cmd.ReturnCmd");
        Extension.loadOnDemand(this, "scan", "tcl.lang.cmd.ScanCmd");
        Extension.loadOnDemand(this, "seek", "tcl.lang.cmd.SeekCmd");
        Extension.loadOnDemand(this, "set", "tcl.lang.cmd.SetCmd");
        Extension.loadOnDemand(this, "socket", "tcl.lang.cmd.SocketCmd");
        Extension.loadOnDemand(this, "source", "tcl.lang.cmd.SourceCmd");
        Extension.loadOnDemand(this, "split", "tcl.lang.cmd.SplitCmd");
        Extension.loadOnDemand(this, "string", "tcl.lang.cmd.StringCmd");
        Extension.loadOnDemand(this, "subst", "tcl.lang.cmd.SubstCmd");
        Extension.loadOnDemand(this, "switch", "tcl.lang.cmd.SwitchCmd");
        Extension.loadOnDemand(this, "tell", "tcl.lang.cmd.TellCmd");
        Extension.loadOnDemand(this, "time", "tcl.lang.cmd.TimeCmd");
        Extension.loadOnDemand(this, "trace", "tcl.lang.cmd.TraceCmd");
        Extension.loadOnDemand(this, "unset", "tcl.lang.cmd.UnsetCmd");
        Extension.loadOnDemand(this, "update", "tcl.lang.cmd.UpdateCmd");
        Extension.loadOnDemand(this, "uplevel", "tcl.lang.cmd.UplevelCmd");
        Extension.loadOnDemand(this, "upvar", "tcl.lang.cmd.UpvarCmd");
        Extension.loadOnDemand(this, "variable", "tcl.lang.cmd.VariableCmd");
        Extension.loadOnDemand(this, "vwait", "tcl.lang.cmd.VwaitCmd");
        Extension.loadOnDemand(this, "while", "tcl.lang.cmd.WhileCmd");
        RegexpCmd.init(this);
        try {
            this.eval("package ifneeded tcltest 1.0 {source resource:/tcl/lang/library/tcltest/tcltest.tcl}");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        Extension.loadOnDemand(this, "jaclloadjava", "tcl.pkg.java.JaclLoadJavaCmd");
        try {
            this.eval("package ifneeded java 1.4.1 jaclloadjava");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        Extension.loadOnDemand(this, "jaclloaditcl", "tcl.pkg.itcl.ItclExtension");
        try {
            this.eval("package ifneeded Itcl 3.3 {jaclloaditcl ; package provide Itcl 3.3}");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        Extension.loadOnDemand(this, "jaclloadparser", "tcl.lang.TclParserExtension");
        try {
            this.eval("package ifneeded parser 1.4 {jaclloadparser}");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        Extension.loadOnDemand(this, "jaclloadtjc", "tcl.pkg.tjc.JaclLoadTJCCmd");
        try {
            this.eval("package ifneeded TJC 1.0 {jaclloadtjc ; package provide TJC 1.0}");
        }
        catch (TclException e) {
            System.out.println(this.getResult());
            e.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
    }

    public void setAssocData(String name, AssocData data) {
        if (this.assocData == null) {
            this.assocData = new HashMap();
        }
        this.assocData.put(name, data);
    }

    public synchronized void deleteAssocData(String name) {
        if (this.assocData == null) {
            return;
        }
        AssocData d = this.assocData.remove(name);
        if (d != null) {
            d.disposeAssocData(this);
        }
    }

    public AssocData getAssocData(String name) {
        if (this.assocData == null) {
            return null;
        }
        return this.assocData.get(name);
    }

    public void backgroundError() {
        BgErrorMgr mgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (mgr == null) {
            mgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", mgr);
        }
        mgr.addBgError();
    }

    public final TclObject setVar(TclObject nameObj, TclObject value, int flags) throws TclException {
        return Var.setVar(this, nameObj.toString(), null, value, flags | 0x200);
    }

    public final TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return Var.setVar(this, name, null, value, flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, TclObject value, int flags) throws TclException {
        return Var.setVar(this, name1, name2, value, flags | 0x200);
    }

    public final TclObject setVar(String name, String strValue, int flags) throws TclException {
        return Var.setVar(this, name, null, this.checkCommonString(strValue), flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, String strValue, int flags) throws TclException {
        return Var.setVar(this, name1, name2, this.checkCommonString(strValue), flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, long intValue, int flags) throws TclException {
        return Var.setVar(this, name1, name2, this.checkCommonInteger(intValue), flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, double dValue, int flags) throws TclException {
        return Var.setVar(this, name1, name2, this.checkCommonDouble(dValue), flags | 0x200);
    }

    public final TclObject setVar(String name1, String name2, boolean bValue, int flags) throws TclException {
        return Var.setVar(this, name1, name2, this.checkCommonBoolean(bValue), flags | 0x200);
    }

    public final TclObject getVar(TclObject nameObj, int flags) throws TclException {
        return Var.getVar(this, nameObj.toString(), null, flags | 0x200);
    }

    public final TclObject getVar(String name, int flags) throws TclException {
        return Var.getVar(this, name, null, flags | 0x200);
    }

    public final TclObject getVar(String name1, String name2, int flags) throws TclException {
        return Var.getVar(this, name1, name2, flags | 0x200);
    }

    public Map<String, String> getenv() {
        return Env.getenv(this);
    }

    public final void unsetVar(TclObject nameObj, int flags) throws TclException {
        Var.unsetVar(this, nameObj.toString(), null, flags | 0x200);
    }

    public final void unsetVar(String name, int flags) throws TclException {
        Var.unsetVar(this, name, null, flags | 0x200);
    }

    public final void unsetVar(String name1, String name2, int flags) throws TclException {
        Var.unsetVar(this, name1, name2, flags | 0x200);
    }

    void traceVar(TclObject nameObj, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, nameObj.toString(), null, flags, trace);
    }

    public void traceVar(String name, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, name, null, flags, trace);
    }

    public void traceVar(String part1, String part2, VarTrace trace, int flags) throws TclException {
        Var.traceVar(this, part1, part2, flags, trace);
    }

    void untraceVar(TclObject nameObj, VarTrace trace, int flags) {
        Var.untraceVar(this, nameObj.toString(), null, flags, trace);
    }

    public void untraceVar(String name, VarTrace trace, int flags) {
        Var.untraceVar(this, name, null, flags, trace);
    }

    public void untraceVar(String part1, String part2, VarTrace trace, int flags) {
        Var.untraceVar(this, part1, part2, flags, trace);
    }

    public void createCommand(String cmdName, Command cmdImpl) {
        WrappedCommand cmd;
        String tail;
        Namespace ns;
        ImportRef oldRef = null;
        if (this.deleted) {
            return;
        }
        if (cmdName.indexOf("::") != -1) {
            Namespace.GetNamespaceForQualNameResult gnfqnr = this.getnfqnResult;
            Namespace.getNamespaceForQualName(this, cmdName, null, 2048, gnfqnr);
            ns = gnfqnr.ns;
            tail = gnfqnr.simpleName;
            if (ns == null || tail == null) {
                return;
            }
        } else {
            ns = this.globalNs;
            tail = cmdName;
        }
        if ((cmd = ns.cmdTable.get(tail)) != null) {
            oldRef = cmd.importRef;
            cmd.importRef = null;
            this.deleteCommandFromToken(cmd);
            cmd = ns.cmdTable.get(tail);
            if (cmd != null) {
                cmd.table.remove(cmd.hashKey);
            }
        }
        cmd = new WrappedCommand();
        ns.cmdTable.put(tail, cmd);
        cmd.table = ns.cmdTable;
        cmd.hashKey = tail;
        cmd.ns = ns;
        cmd.cmd = cmdImpl;
        cmd.deleted = false;
        cmd.importRef = null;
        cmd.cmdEpoch = 1;
        if (oldRef != null) {
            cmd.importRef = oldRef;
            while (oldRef != null) {
                WrappedCommand refCmd = oldRef.importedCmd;
                ImportedCmdData data = (ImportedCmdData)refCmd.cmd;
                data.realCmd = cmd;
                oldRef = oldRef.next;
            }
        }
        Namespace.resetShadowedCmdRefs(this, cmd);
    }

    public String getCommandFullName(WrappedCommand cmd) {
        Interp interp = this;
        StringBuffer name = new StringBuffer();
        if (cmd != null) {
            if (cmd.ns != null) {
                name.append(cmd.ns.fullName);
                if (cmd.ns != interp.globalNs) {
                    name.append("::");
                }
            }
            if (cmd.table != null) {
                name.append(cmd.hashKey);
            }
        }
        return name.toString();
    }

    public String getCommandName(WrappedCommand cmd) {
        if (cmd == null || cmd.table == null) {
            return "";
        }
        return cmd.hashKey;
    }

    public int deleteCommand(String cmdName) {
        WrappedCommand cmd;
        try {
            cmd = Namespace.findCommand(this, cmdName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        if (cmd == null) {
            return -1;
        }
        return this.deleteCommandFromToken(cmd);
    }

    public int deleteCommandFromToken(WrappedCommand cmd) {
        if (cmd == null) {
            return -1;
        }
        cmd.callCommandTraces(0, "");
        if (cmd.deleted) {
            if (cmd.hashKey != null && cmd.table != null) {
                cmd.table.remove(cmd.hashKey);
                cmd.table = null;
                cmd.hashKey = null;
            }
            return 0;
        }
        cmd.deleted = true;
        if (cmd.cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)cmd.cmd).disposeCmd();
        }
        cmd.incrEpoch();
        ImportRef ref = cmd.importRef;
        while (ref != null) {
            ImportRef nextRef = ref.next;
            WrappedCommand importCmd = ref.importedCmd;
            this.deleteCommandFromToken(importCmd);
            ref = nextRef;
        }
        if (cmd.table != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = null;
            cmd.hashKey = null;
        }
        cmd.cmd = null;
        return 0;
    }

    public void renameCommand(String oldName, String newName) throws TclException {
        Interp interp = this;
        WrappedCommand cmd = Namespace.findCommand(interp, oldName, null, 0);
        if (cmd == null) {
            throw new TclException(interp, "can't " + (newName == null || newName.length() == 0 ? "delete" : "rename") + " \"" + oldName + "\": command doesn't exist");
        }
        Namespace cmdNs = cmd.ns;
        if (newName == null || newName.length() == 0) {
            this.deleteCommandFromToken(cmd);
            return;
        }
        Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, newName, null, 2048, gnfqnr);
        Namespace newNs = gnfqnr.ns;
        String newTail = gnfqnr.simpleName;
        if (newNs == null || newTail == null) {
            throw new TclException(interp, "can't rename to \"" + newName + "\": bad command name");
        }
        if (newNs.cmdTable.get(newTail) != null) {
            throw new TclException(interp, "can't rename to \"" + newName + "\": command already exists");
        }
        String newCommand = String.valueOf(newNs.fullName) + (newNs.fullName.endsWith("::") ? "" : "::") + newTail;
        cmd.callCommandTraces(1, newCommand);
        cmd = Namespace.findCommand(interp, oldName, null, 0);
        if (cmd == null) {
            return;
        }
        HashMap<String, WrappedCommand> oldTable = cmd.table;
        String oldHashKey = cmd.hashKey;
        newNs.cmdTable.put(newTail, cmd);
        cmd.table = newNs.cmdTable;
        cmd.hashKey = newTail;
        cmd.ns = newNs;
        Namespace.resetShadowedCmdRefs(this, cmd);
        try {
            interp.preventAliasLoop(interp, cmd);
        }
        catch (TclException e) {
            newNs.cmdTable.remove(newTail);
            cmd.table = oldTable;
            cmd.hashKey = oldHashKey;
            cmd.ns = cmdNs;
            throw e;
        }
        oldTable.remove(oldHashKey);
        cmd.incrEpoch();
    }

    public void preventAliasLoop(Interp cmdInterp, WrappedCommand cmd) throws TclException {
        InterpAliasCmd alias;
        if (!(cmd.cmd instanceof InterpAliasCmd)) {
            return;
        }
        InterpAliasCmd nextAlias = alias = (InterpAliasCmd)cmd.cmd;
        WrappedCommand aliasCmd;
        while ((aliasCmd = nextAlias.getTargetCmd(this)) != null) {
            if (aliasCmd.cmd == cmd.cmd) {
                throw new TclException(this, "cannot define or rename alias \"" + alias.name + "\": would create a loop");
            }
            if (!(aliasCmd.cmd instanceof InterpAliasCmd)) {
                return;
            }
            nextAlias = (InterpAliasCmd)aliasCmd.cmd;
        }
        return;
    }

    public Command getCommand(String cmdName) {
        WrappedCommand cmd;
        try {
            cmd = Namespace.findCommand(this, cmdName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        return cmd == null ? null : cmd.cmd;
    }

    public WrappedCommand getWrappedCommand(String cmdName) {
        try {
            return Namespace.findCommand(this, cmdName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public void traceCommand(String command, CommandTrace trace) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, command, null, 512);
        wrappedCommand.traceCommand(trace);
    }

    public void untraceCommand(String command, int type, TclObject callbackCmd) throws TclException {
        WrappedCommand cmd = Namespace.findCommand(this, command, null, 512);
        cmd.untraceCommand(type, callbackCmd.toString());
    }

    public TclObject traceCommandInfo(String command) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, command, null, 512);
        return wrappedCommand.traceCommandInfo(this);
    }

    public void traceExecution(String command, ExecutionTrace trace) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, command, null, 512);
        wrappedCommand.traceExecution(trace);
    }

    public void untraceExecution(String command, int type, TclObject callbackCmd) throws TclException {
        WrappedCommand cmd = Namespace.findCommand(this, command, null, 512);
        cmd.untraceExecution(type, callbackCmd.toString());
        this.deactivateExecutionStepTrace(cmd);
    }

    public TclObject traceExecutionInfo(String command) throws TclException {
        WrappedCommand wrappedCommand = Namespace.findCommand(this, command, null, 512);
        return wrappedCommand.traceExecutionInfo(this);
    }

    boolean activateExecutionStepTrace(WrappedCommand cmd) {
        if (this.activeExecutionStepTraces == null) {
            this.activeExecutionStepTraces = new ArrayList();
        }
        if (this.activeExecutionStepTraces.contains(cmd)) {
            return false;
        }
        this.activeExecutionStepTraces.add(cmd);
        return true;
    }

    void deactivateExecutionStepTrace(WrappedCommand cmd) {
        if (this.activeExecutionStepTraces == null) {
            return;
        }
        this.activeExecutionStepTraces.remove(cmd);
        if (this.activeExecutionStepTraces.size() == 0) {
            this.activeExecutionStepTraces = null;
        }
    }

    final boolean hasActiveExecutionStepTraces() {
        return this.stepTracingEnabled && this.activeExecutionStepTraces != null;
    }

    WrappedCommand[] getCopyOfActiveExecutionStepTraces() {
        WrappedCommand[] rv = new WrappedCommand[]{};
        if (this.activeExecutionStepTraces == null) {
            return rv;
        }
        rv = this.activeExecutionStepTraces.toArray(rv);
        return rv;
    }

    void enableExecutionStepTracing(boolean enable) {
        this.stepTracingEnabled = enable;
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject newResult) {
        newResult.file = this.scriptFile;
        newResult.offset = this.getOffset(newResult);
        if (newResult == this.m_result) {
            return;
        }
        if (newResult != this.m_nullResult) {
            newResult.preserve();
        }
        TclObject oldResult = this.m_result;
        this.m_result = newResult;
        if (oldResult != this.m_nullResult) {
            oldResult.release();
        }
    }

    public final void setResult(String r) {
        this.setResult(this.checkCommonString(r));
    }

    public final void setResult(long r) {
        this.setResult(this.checkCommonInteger(r));
    }

    public final void setResult(double r) {
        this.setResult(this.checkCommonDouble(r));
    }

    public final void setResult(boolean r) {
        this.setResult(r ? this.m_trueBooleanResult : this.m_falseBooleanResult);
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
        this.returnCode = 0;
    }

    public void appendElement(String string) throws TclException {
        TclObject result = this.getResult();
        if (result.isShared()) {
            result = result.duplicate();
        }
        TclList.append(this, result, TclString.newInstance(string));
        this.setResult(result);
    }

    public void eval(String script) throws TclException {
        this.eval(script, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void eval(String string, int flags) throws TclException {
        block14: {
            if (string == null) {
                throw new NullPointerException("passed null String to eval()");
            }
            evalFlags = this.evalFlags;
            this.evalFlags &= -5;
            script = new CharPointer(string);
            try {
                block15: {
                    try {
                        Parser.eval2(this, script.array, script.index, script.length(), flags);
                        break block14;
                    }
                    catch (TclException e) {
                        if (this.nestLevel != 0) {
                            throw e;
                        }
                        result = e.getCompletionCode();
                        if (result == 2) {
                            result = this.updateReturnInfo();
                        }
                        if (result == 0 || result == 1 || (evalFlags & 4) != 0) break block15;
                        this.errorLine = 1;
                        lineEnd = 0;
                        lineStart = 0;
                        ** while (lineEnd < this.termOffset - 1)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (script.charAt(lineEnd) == '\n') {
                            ++this.errorLine;
                            lineStart = lineEnd + 1;
                        }
                        ++lineEnd;
                        continue;
                    }
lbl26:
                    // 2 sources

                    while (Character.isWhitespace(script.charAt(lineStart)) && lineStart < lineEnd) {
                        ++lineStart;
                    }
                    try {
                        this.processUnexpectedResult(result);
                    }
                    catch (TclException e1) {
                        this.addErrorInfo("\n    while executing\n\"" + script.toString().substring(lineStart, lineEnd) + "\"");
                        throw e1;
                    }
                }
                if (result != 0) {
                    e.setCompletionCode(result);
                    throw e;
                }
            }
            finally {
                this.checkInterrupted();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void eval(TclObject tobj, int flags) throws TclException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void recordAndEval(TclObject script, int flags) throws TclException {
        TclObject cmd = null;
        try {
            cmd = TclList.newInstance();
            TclList.append(this, cmd, TclString.newInstance("history"));
            TclList.append(this, cmd, TclString.newInstance("add"));
            TclList.append(this, cmd, script);
            this.eval(cmd, 131072);
        }
        catch (Exception exception) {}
        if ((flags & 0x10000) == 0) {
            this.eval(script, flags & 0x20000);
        }
    }

    public void evalFile(String s) throws TclException {
        this.evalFile(s, EncodingCmd.systemJavaEncoding);
    }

    public void evalFile(String s, String encoding) throws TclException {
        String fileContent = this.readScriptFromFile(s, encoding);
        if (fileContent == null) {
            throw new TclException(this, "couldn't read file \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            try {
                this.pushDebugStack(s, 1);
                this.eval(fileContent, 0);
            }
            catch (TclException e) {
                if (e.getCompletionCode() == 1) {
                    this.addErrorInfo("\n    (file \"" + s + "\" line " + this.errorLine + ")");
                }
                throw e;
            }
        }
        finally {
            this.scriptFile = oldScript;
            this.popDebugStack();
        }
    }

    public void evalURL(URL context, String s) throws TclException {
        this.evalURL(context, s, EncodingCmd.systemJavaEncoding);
    }

    public void evalURL(URL context, String s, String javaEncoding) throws TclException {
        String fileContent = this.readScriptFromURL(context, s, javaEncoding);
        if (fileContent == null) {
            throw new TclException(this, "cannot read URL \"" + s + "\"");
        }
        String oldScript = this.scriptFile;
        this.scriptFile = s;
        try {
            this.eval(fileContent, 0);
        }
        finally {
            this.scriptFile = oldScript;
        }
    }

    private String readScriptFromFile(String s, String encoding) throws TclException {
        FileChannel fchan = new FileChannel();
        fchan.setEncoding(encoding);
        boolean wasOpened = false;
        TclObject result = TclString.newInstance(new StringBuffer(64));
        try {
            File sourceFile = FileUtil.getNewFileObj(this, s);
            fchan.open(this, sourceFile.getPath(), 1);
            wasOpened = true;
            fchan.read(this, result, 1, 0);
            String string = this.trimToCtrlZ(result.toString());
            return string;
        }
        catch (TclPosixException e) {
            throw new TclPosixException(this, e.getErrorNo(), true, "couldn't read file \"" + s + "\"");
        }
        catch (IOException e) {
            throw new TclPosixException(this, e, true, "couldn't read file \"" + s + "\"");
        }
        catch (SecurityException e) {
            throw new TclException(this, e.getMessage());
        }
        finally {
            if (wasOpened) {
                this.closeChannel(fchan);
            }
        }
    }

    private String trimToCtrlZ(String source) {
        int ctrlZ = 26;
        int end = source.indexOf(ctrlZ);
        if (end == -1) {
            return source;
        }
        return source.substring(0, end);
    }

    private String readScriptFromURL(URL context, String s, String javaEncoding) {
        URL url;
        Object content = null;
        try {
            url = new URL(context, s);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            content = url.getContent();
        }
        catch (UnknownServiceException unknownServiceException) {
            URLConnection jar;
            Class<?> jar_class;
            try {
                jar_class = Class.forName("java.net.JarURLConnection");
            }
            catch (Exception exception) {
                return null;
            }
            try {
                jar = url.openConnection();
            }
            catch (IOException iOException) {
                return null;
            }
            if (jar == null) {
                return null;
            }
            try {
                Method m = jar_class.getMethod("openConnection", null);
                content = m.invoke((Object)jar, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (content instanceof String) {
            return this.trimToCtrlZ(this.convertStringCRLF((String)content));
        }
        if (content instanceof InputStream) {
            return this.trimToCtrlZ(this.readScriptFromInputStream((InputStream)content, javaEncoding));
        }
        return null;
    }

    String convertStringCRLF(String inStr) {
        String str = inStr;
        StringBuffer sb = new StringBuffer(str.length());
        int prev = 10;
        boolean foundCRLF = false;
        int length = str.length();
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c == '\n' && prev == 13) {
                sb.setCharAt(sb.length() - 1, '\n');
                prev = 10;
                foundCRLF = true;
            } else {
                sb.append(c);
                prev = c;
            }
            ++i;
        }
        if (foundCRLF) {
            return sb.toString();
        }
        return str;
    }

    private String readScriptFromInputStream(InputStream s, String javaEncoding) {
        TclObject result = TclString.newInstance(new StringBuffer(64));
        ReadInputStreamChannel rc = new ReadInputStreamChannel(this, s);
        rc.setEncoding(javaEncoding);
        try {
            rc.read(this, result, 1, 0);
            String string = result.toString();
            return string;
        }
        catch (TclException tclException) {
            this.resetResult();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        finally {
            this.closeChannel(rc);
            this.closeInputStream(s);
        }
    }

    private void closeInputStream(InputStream fs) {
        try {
            fs.close();
        }
        catch (IOException iOException) {}
    }

    private void closeChannel(Channel chan) {
        try {
            chan.close();
        }
        catch (IOException iOException) {}
    }

    public void evalResource(String resName) throws TclException {
        this.evalResource(resName, EncodingCmd.systemJavaEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalResource(String resName, String javaEncoding) throws TclException {
        boolean couldBeCached = false;
        boolean isCached = false;
        String script = null;
        if (resName.startsWith("/tcl/lang/library/") && (resName.equals("/tcl/lang/library/tclIndex") || resName.endsWith(".tcl"))) {
            couldBeCached = true;
        }
        if (couldBeCached) {
            HashMap hashMap = tclLibraryScripts;
            synchronized (hashMap) {
                script = (String)tclLibraryScripts.get(resName);
                isCached = script != null;
                if (!isCached) {
                    InputStream stream = this.getResourceAsStream(resName);
                    if (stream == null) {
                        throw new TclException(this, "cannot read resource \"" + resName + "\"");
                    }
                    script = this.readScriptFromInputStream(stream, javaEncoding);
                    if (script == null) {
                        throw new TclException(this, "cannot read resource \"" + resName + "\"");
                    }
                    tclLibraryScripts.put(resName, script);
                }
            }
        } else {
            InputStream stream = this.getResourceAsStream(resName);
            if (stream == null) {
                throw new TclException(this, "cannot read resource \"" + resName + "\"");
            }
            script = this.readScriptFromInputStream(stream, javaEncoding);
            if (script == null) {
                throw new TclException(this, "cannot read resource \"" + resName + "\"");
            }
        }
        String oldScript = this.scriptFile;
        this.scriptFile = "resource:" + resName;
        try {
            this.eval(script, 0);
        }
        finally {
            this.scriptFile = oldScript;
        }
    }

    public static BackSlashResult backslash(String s, int i, int len) {
        CharPointer script = new CharPointer(s.substring(0, len));
        script.index = i;
        return Parser.backslash(script.array, script.index);
    }

    public void setErrorCode(TclObject code) {
        try {
            this.setVar("errorCode", null, code, 1);
            this.errCodeSet = true;
        }
        catch (TclException tclException) {}
    }

    public void addErrorInfo(String message) {
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                this.setVar("::errorInfo", null, this.getResult().toString(), 1);
            }
            catch (TclException tclException) {}
            if (!this.errCodeSet) {
                try {
                    this.setVar("errorCode", null, "NONE", 1);
                }
                catch (TclException tclException) {}
            }
        }
        try {
            this.setVar("::errorInfo", null, message, 5);
        }
        catch (TclException tclException) {}
    }

    public void processUnexpectedResult(int returnCode) throws TclException {
        this.resetResult();
        if (returnCode == 3) {
            throw new TclException(this, "invoked \"break\" outside of a loop");
        }
        if (returnCode == 4) {
            throw new TclException(this, "invoked \"continue\" outside of a loop");
        }
        throw new TclException(this, "command returned bad code: " + returnCode);
    }

    public int updateReturnInfo() {
        int code = this.returnCode;
        this.returnCode = 0;
        if (code == 1) {
            try {
                this.setVar("errorCode", null, this.errorCode != null ? this.errorCode : "NONE", 1);
            }
            catch (TclException tclException) {}
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    this.setVar("::errorInfo", null, this.errorInfo, 1);
                }
                catch (TclException tclException) {}
                this.errInProgress = true;
            }
        }
        return code;
    }

    protected CallFrame newCallFrame(Procedure proc, TclObject[] objv) throws TclException {
        return new CallFrame(this, proc, objv);
    }

    public CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    public File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                String dirName = this.getVar("env", "HOME", 0).toString();
                this.workingDir = FileUtil.getNewFileObj(this, dirName);
            }
            catch (TclException tclException) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    public void setWorkingDir(String dirName) throws TclException {
        File dirObj = FileUtil.getNewFileObj(this, dirName);
        try {
            dirObj = new File(dirObj.getCanonicalPath());
        }
        catch (IOException iOException) {}
        if (!dirObj.isDirectory() || dirName.length() <= 0) {
            String dname = FileUtil.translateFileName(this, dirName);
            dname = FileUtil.getPathType(dname) == 0 ? dirName : dirObj.getPath();
            throw new TclException(this, "couldn't change working directory to \"" + dname + "\": no such file or directory");
        }
        this.workingDir = dirObj;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String name, String version) throws TclException {
        PackageCmd.pkgProvide(this, name, version);
    }

    public final String pkgRequire(String pkgname, String version, boolean exact) throws TclException {
        return PackageCmd.pkgRequire(this, pkgname, version, exact);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String fileName, int lineNumber) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    public String getScriptFile() {
        return this.dbg.fileName;
    }

    public int getArgLineNumber(int index) {
        return 0;
    }

    public void transferResult(Interp sourceInterp, int result) throws TclException {
        if (sourceInterp == this) {
            if (result != 0) {
                throw new TclException(this, this.getResult().toString(), result);
            }
            return;
        }
        if (result == 1) {
            if (!sourceInterp.errAlreadyLogged) {
                sourceInterp.addErrorInfo("");
            }
            sourceInterp.errAlreadyLogged = true;
            this.resetResult();
            TclObject obj = sourceInterp.getVar("errorInfo", 1);
            this.setVar("errorInfo", obj, 1);
            obj = sourceInterp.getVar("errorCode", 1);
            this.setVar("errorCode", obj, 1);
            this.errInProgress = true;
            this.errCodeSet = true;
        }
        this.returnCode = result;
        this.setResult(sourceInterp.getResult());
        sourceInterp.resetResult();
        if (result != 0) {
            throw new TclException(this, this.getResult().toString(), result);
        }
    }

    public void hideCommand(String cmdName, String hiddenCmdToken) throws TclException {
        if (this.deleted) {
            return;
        }
        if (hiddenCmdToken.indexOf("::") >= 0) {
            throw new TclException(this, "cannot use namespace qualifiers in hidden command token (rename)");
        }
        WrappedCommand cmd = Namespace.findCommand(this, cmdName, null, 513);
        if (cmd.ns != this.globalNs) {
            throw new TclException(this, "can only hide global namespace commands (use rename then hide)");
        }
        if (this.hiddenCmdTable == null) {
            this.hiddenCmdTable = new HashMap();
        }
        if (this.hiddenCmdTable.containsKey(hiddenCmdToken)) {
            throw new TclException(this, "hidden command named \"" + hiddenCmdToken + "\" already exists");
        }
        if (cmd.table.containsKey(cmd.hashKey)) {
            cmd.table.remove(cmd.hashKey);
            cmd.incrEpoch();
        }
        cmd.table = this.hiddenCmdTable;
        cmd.hashKey = hiddenCmdToken;
        this.hiddenCmdTable.put(hiddenCmdToken, cmd);
    }

    public void exposeCommand(String hiddenCmdToken, String cmdName) throws TclException {
        if (this.deleted) {
            return;
        }
        if (cmdName.indexOf("::") >= 0) {
            throw new TclException(this, "can not expose to a namespace (use expose to toplevel, then rename)");
        }
        if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(hiddenCmdToken)) {
            throw new TclException(this, "unknown hidden command \"" + hiddenCmdToken + "\"");
        }
        WrappedCommand cmd = (WrappedCommand)this.hiddenCmdTable.get(hiddenCmdToken);
        if (cmd.ns != this.globalNs) {
            throw new TclException(this, "trying to expose a non global command name space command");
        }
        Namespace ns = cmd.ns;
        if (ns.cmdTable.containsKey(cmdName)) {
            throw new TclException(this, "exposed command \"" + cmdName + "\" already exists");
        }
        if (cmd.hashKey != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = ns.cmdTable;
            cmd.hashKey = cmdName;
        }
        ns.cmdTable.put(cmdName, cmd);
    }

    public void hideUnsafeCommands() throws TclException {
        int ix = 0;
        while (ix < unsafeCmds.length) {
            block3: {
                try {
                    this.hideCommand(unsafeCmds[ix], unsafeCmds[ix]);
                }
                catch (TclException e) {
                    if (e.getMessage().startsWith("unknown command")) break block3;
                    throw e;
                }
            }
            ++ix;
        }
    }

    public int invokeGlobal(TclObject[] objv, int flags) throws TclException {
        CallFrame savedVarFrame = this.varFrame;
        try {
            this.varFrame = null;
            int n = this.invoke(objv, flags);
            return n;
        }
        finally {
            this.varFrame = savedVarFrame;
        }
    }

    public int invoke(TclObject[] objv, int flags) throws TclException {
        WrappedCommand cmd;
        if (objv.length < 1 || objv == null) {
            throw new TclException(this, "illegal argument vector");
        }
        this.ready();
        String cmdName = objv[0].toString();
        TclObject[] localObjv = null;
        if ((flags & 1) != 0) {
            if (this.hiddenCmdTable == null || !this.hiddenCmdTable.containsKey(cmdName)) {
                throw new TclException(this, "invalid hidden command name \"" + cmdName + "\"");
            }
            cmd = (WrappedCommand)this.hiddenCmdTable.get(cmdName);
        } else {
            cmd = Namespace.findCommand(this, cmdName, null, 1);
            if (cmd == null) {
                if ((flags & 2) == 0 && (cmd = Namespace.findCommand(this, "unknown", null, 1)) != null) {
                    localObjv = new TclObject[objv.length + 1];
                    localObjv[0] = TclString.newInstance("unknown");
                    localObjv[0].preserve();
                    int i = 0;
                    while (i < objv.length) {
                        localObjv[i + 1] = objv[i];
                        ++i;
                    }
                    objv = localObjv;
                }
                if (cmd == null) {
                    throw new TclException(this, "invalid command name \"" + cmdName + "\"");
                }
            }
        }
        this.resetResult();
        ++this.cmdCount;
        int result = 0;
        try {
            if (cmd.mustCallInvoke(this)) {
                cmd.invoke(this, objv);
            } else {
                cmd.cmd.cmdProc(this, objv);
            }
        }
        catch (TclException e) {
            result = e.getCompletionCode();
        }
        if ((flags & 1) != 0 && (cmd = Namespace.findCommand(this, cmdName, null, 1)) != null) {
            cmd.table.remove(cmd.hashKey);
            cmd.table = this.hiddenCmdTable;
            cmd.hashKey = cmdName;
            this.hiddenCmdTable.put(cmdName, cmd);
        }
        if (result == 1 && (flags & 4) == 0 && !this.errAlreadyLogged) {
            StringBuffer ds = this.errInProgress ? new StringBuffer("\n    while invoking\n\"") : new StringBuffer("\n    invoked from within\n\"");
            int i = 0;
            while (i < objv.length) {
                ds.append(objv[i].toString());
                if (i < objv.length - 1) {
                    ds.append(" ");
                } else if (ds.length() > 100) {
                    ds.append("...");
                    break;
                }
                ++i;
            }
            ds.append("\"");
            this.addErrorInfo(ds.toString());
            this.errInProgress = true;
        }
        if (localObjv != null) {
            localObjv[0].release();
        }
        return result;
    }

    public void allowExceptions() {
        this.evalFlags |= 4;
    }

    public void addInterpResolver(String name, Resolver resolver) {
        ResolverScheme res;
        if (this.resolvers != null) {
            ListIterator iter = this.resolvers.listIterator();
            while (iter.hasNext()) {
                res = (ResolverScheme)iter.next();
                if (!name.equals(res.name)) continue;
                res.resolver = resolver;
                return;
            }
        }
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        res = new ResolverScheme(name, resolver);
        this.resolvers.add(0, res);
    }

    public Resolver getInterpResolver(String name) {
        if (this.resolvers != null) {
            ListIterator iter = this.resolvers.listIterator();
            while (iter.hasNext()) {
                ResolverScheme res = (ResolverScheme)iter.next();
                if (!name.equals(res.name)) continue;
                return res.resolver;
            }
        }
        return null;
    }

    public boolean removeInterpResolver(String name) {
        boolean found = false;
        if (this.resolvers != null) {
            ListIterator iter = this.resolvers.listIterator();
            while (iter.hasNext()) {
                ResolverScheme res = (ResolverScheme)iter.next();
                if (!name.equals(res.name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            int index = this.resolvers.indexOf(name);
            if (index == -1) {
                throw new TclRuntimeError("name " + name + " not found in resolvers");
            }
            this.resolvers.remove(index);
        }
        return found;
    }

    public final TclObject checkCommonInteger(long value) {
        if (value == -1L) {
            return this.m_minusoneIntegerResult;
        }
        if (value == 0L) {
            return this.m_zeroIntegerResult;
        }
        if (value == 1L) {
            return this.m_oneIntegerResult;
        }
        if (value == 2L) {
            return this.m_twoIntegerResult;
        }
        if (this.recycledI.getRefCount() == 1 || this.recycledI.getRefCount() == 2 && this.recycledI == this.m_result) {
            this.recycledI.setRecycledIntValue(value);
        } else {
            this.recycledI.release();
            this.recycledI = TclInteger.newInstance(value);
            this.recycledI.preserve();
        }
        return this.recycledI;
    }

    final TclObject checkCommonDouble(double value) {
        if (value == 0.0) {
            return this.m_zeroDoubleResult;
        }
        if (value == 0.5) {
            return this.m_onehalfDoubleResult;
        }
        if (value == 1.0) {
            return this.m_oneDoubleResult;
        }
        if (value == 2.0) {
            return this.m_twoDoubleResult;
        }
        if (this.recycledD.getRefCount() == 1 || this.recycledD.getRefCount() == 2 && this.recycledD == this.m_result) {
            this.recycledD.setRecycledDoubleValue(value);
        } else {
            this.recycledD.release();
            this.recycledD = TclDouble.newInstance(value);
            this.recycledD.preserve();
        }
        return this.recycledD;
    }

    final TclObject checkCommonBoolean(boolean value) {
        return value ? this.m_trueBooleanResult : this.m_falseBooleanResult;
    }

    public final TclObject checkCommonString(String value) {
        if (value == null || "".equals(value) || value.length() == 0) {
            return this.m_nullResult;
        }
        return TclString.newInstance(value);
    }

    public final TclObject checkCommonCharacter(int c) {
        if (c <= 0 || c >= 128) {
            return null;
        }
        return this.m_charCommon[c];
    }

    public int getErrorLine() {
        return this.errorLine;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new TclClassLoader(this, null, Thread.currentThread().getContextClassLoader());
        }
        return this.classLoader;
    }

    InputStream getResourceAsStream(String resName) {
        if (this.classLoader == null) {
            this.getClassLoader();
        }
        try {
            return this.classLoader.getResourceAsStream(resName);
        }
        catch (PackageNameException packageNameException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public void setInterrupted() {
        TclInterruptedExceptionEvent ie;
        if (this.deleted || this.interruptedEvent != null) {
            return;
        }
        this.interruptedEvent = ie = new TclInterruptedExceptionEvent(this);
        if (this.interruptedEvent != ie) {
            return;
        }
        this.getNotifier().queueEvent(this.interruptedEvent, 0);
    }

    public final void checkInterrupted() {
        if (this.interruptedEvent != null && !this.interruptedEvent.exceptionRaised) {
            this.interruptedEvent.exceptionRaised = true;
            throw new TclInterruptedException(this);
        }
    }

    final void disposeInterrupted() {
        if (this.deleted) {
            throw new TclRuntimeError("Interp.disposeInterrupted() invoked for a deleted interp");
        }
        if (this.interruptedEvent == null) {
            throw new TclRuntimeError("Interp.disposeInterrupted() invoked for an interp that was not interrupted via setInterrupted()");
        }
        if (this.interruptedEvent != null && !this.interruptedEvent.wasProcessed) {
            this.getNotifier().deleteEvents(this.interruptedEvent);
        }
        try {
            this.eval("after info", 0);
            TclObject tobj = this.getResult();
            tobj.preserve();
            int len = TclList.getLength(this, tobj);
            int i = 0;
            while (i < len) {
                TclObject evt = TclList.index(this, tobj, i);
                String cmd = "after cancel " + evt;
                this.eval(cmd, 0);
                ++i;
            }
            tobj.release();
        }
        catch (TclException tclException) {}
        this.dispose();
    }

    public int setMaxNestingDepth(int depth) {
        int old = this.maxNestingDepth;
        if (depth > 0) {
            this.maxNestingDepth = depth;
        }
        return old;
    }

    public int getMaxNestingDepth() {
        return this.maxNestingDepth;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String info = super.toString();
        if (info.startsWith("tcl.lang.Interp")) {
            info = info.substring(9);
        }
        buffer.append(info);
        buffer.append(' ');
        buffer.append("allocated in \"" + this.cThreadName + "\"");
        return buffer.toString();
    }

    public String getNameOfExecutable() {
        return this.nameOfExecutable;
    }

    public void setNameOfExecutable(String name) {
        this.nameOfExecutable = name;
    }

    public String getShellClassName() {
        return this.shellClassName == null ? "tcl.lang.NonInteractiveShell" : this.shellClassName;
    }

    public void setShellClassName(String name) {
        this.shellClassName = name;
    }

    public void pushEvalToken(TclToken tclToken) {
        Object[] obj = new Object[]{tclToken == null ? null : new TclToken(tclToken), this.scriptFile};
        this.nestedEvalOffsets.push(obj);
    }

    public void popEvalToken() {
        if (!this.nestedEvalOffsets.isEmpty()) {
            this.nestedEvalOffsets.pop();
        }
    }

    public int getOffset(TclObject obj) {
        TclToken currToken = obj.token == null ? this.getCurrentToken() : obj.token;
        int script_index = currToken == null ? 0 : currToken.script_index;
        int[] result = new int[]{script_index};
        this.nestedEvalOffsets.stream().forEach(x -> {
            int n = result[0] + this.grabOffset((Object[])x, this.scriptFile);
        });
        return result[0];
    }

    private int grabOffset(Object[] x, String currFile) {
        String tokenFile;
        TclToken token;
        block6: {
            block5: {
                try {
                    if (x != null && x.length == 2) break block5;
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            token = (TclToken)x[0];
            tokenFile = (String)x[1];
            if (token != null && tokenFile != null) break block6;
            return 0;
        }
        if (tokenFile.equals(currFile)) {
            return token.script_index;
        }
        return 0;
    }

    public int getLine(TclObject obj) {
        TclToken t = obj.token == null ? this.getCurrentToken() : obj.token;
        int script_index = t == null ? 0 : t.script_index;
        int[] result = new int[]{1};
        int i = 0;
        while (t != null && i < script_index) {
            if (t.script_array[i] == '\n') {
                result[0] = result[0] + 1;
            }
            ++i;
        }
        this.nestedEvalOffsets.stream().forEach(x -> {
            int n = result[0] + this.grabLine((Object[])x, this.scriptFile);
        });
        return result[0];
    }

    private int grabLine(Object[] x, String currFile) {
        String tokenFile;
        TclToken token;
        block6: {
            block5: {
                try {
                    if (x != null && x.length == 2) break block5;
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            token = (TclToken)x[0];
            tokenFile = (String)x[1];
            if (token != null && tokenFile != null) break block6;
            return 0;
        }
        if (tokenFile.equals(currFile)) {
            return token.line;
        }
        return 0;
    }

    private TclToken getCurrentToken() {
        try {
            int i = 0;
            while (i < this.parserObjvUsed.length) {
                if (this.parserObjvUsed[i] != 0) {
                    return this.parserObjv[i][this.parserObjvUsed[i] - 1][0].token;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            return this.parserTokens[this.parserTokensUsed - 2];
        }
        catch (Exception exception) {
            return null;
        }
    }

    class ResolverScheme {
        String name;
        Resolver resolver;

        ResolverScheme(String name, Resolver resolver) {
            this.name = name;
            this.resolver = resolver;
        }
    }
}

