/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ManagedSystemInStream
extends InputStream
implements Runnable {
    private static ReadRequest readRequest = new ReadRequest();
    private static volatile Thread readThread;
    private static volatile FileInputStream stdin;
    private static InputStream originalIn;
    private volatile boolean streamClosed;
    private boolean eofSeen;
    private CountDownLatch disposeLatch;

    static {
        stdin = null;
        originalIn = System.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedSystemInStream() {
        ReadRequest readRequest = ManagedSystemInStream.readRequest;
        synchronized (readRequest) {
            if (stdin == null) {
                ManagedSystemInStream.readRequest.clear();
                this.streamClosed = false;
                this.eofSeen = false;
                this.disposeLatch = new CountDownLatch(1);
                stdin = new FileInputStream(FileDescriptor.in);
                try {
                    System.setIn(this);
                }
                catch (SecurityException securityException) {}
                readThread = new Thread(null, this, "ManagedSystemInStream reader thread");
                readThread.setDaemon(true);
                readThread.start();
            }
        }
    }

    public void dispose() {
        this.streamClosed = true;
        if (readThread != null) {
            try {
                readThread.interrupt();
                this.disposeLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {}
        }
        try {
            System.setIn(originalIn);
        }
        catch (SecurityException securityException) {}
    }

    @Override
    public int available() throws IOException {
        return originalIn.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        ReadRequest readRequest = ManagedSystemInStream.readRequest;
        synchronized (readRequest) {
            this.streamClosed = true;
            ManagedSystemInStream.readRequest.notifyAll();
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int cnt = this.read(b, 0, 1);
        if (cnt == -1) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        boolean requestMade = false;
        while (!this.eofSeen && !this.streamClosed) {
            ReadRequest readRequest = ManagedSystemInStream.readRequest;
            synchronized (readRequest) {
                if (this.eofSeen || this.streamClosed) {
                    return -1;
                }
                if (!requestMade && ManagedSystemInStream.readRequest.validData) {
                    if (ManagedSystemInStream.readRequest.exception != null) {
                        ManagedSystemInStream.readRequest.validData = false;
                        ManagedSystemInStream.readRequest.requestData = false;
                        throw ManagedSystemInStream.readRequest.exception;
                    }
                    if (ManagedSystemInStream.readRequest.actualLength == -1) {
                        this.eofSeen = true;
                        return -1;
                    }
                    int copyLength = length < ManagedSystemInStream.readRequest.actualLength ? length : ManagedSystemInStream.readRequest.actualLength;
                    System.arraycopy(ManagedSystemInStream.readRequest.buf, ManagedSystemInStream.readRequest.offset, b, offset, copyLength);
                    ManagedSystemInStream.readRequest.actualLength -= copyLength;
                    if (ManagedSystemInStream.readRequest.actualLength <= 0) {
                        ManagedSystemInStream.readRequest.validData = false;
                        ManagedSystemInStream.readRequest.requestData = false;
                    }
                    return copyLength;
                }
                if (!(requestMade || ManagedSystemInStream.readRequest.validData || ManagedSystemInStream.readRequest.requestData)) {
                    requestMade = true;
                    ManagedSystemInStream.readRequest.exception = null;
                    ManagedSystemInStream.readRequest.buf = b;
                    ManagedSystemInStream.readRequest.len = length;
                    ManagedSystemInStream.readRequest.offset = offset;
                    ManagedSystemInStream.readRequest.requestData = true;
                    ManagedSystemInStream.readRequest.validData = false;
                    ManagedSystemInStream.readRequest.notifyAll();
                }
                if (requestMade && ManagedSystemInStream.readRequest.validData) {
                    ManagedSystemInStream.readRequest.validData = false;
                    if (ManagedSystemInStream.readRequest.exception != null) {
                        throw ManagedSystemInStream.readRequest.exception;
                    }
                    if (ManagedSystemInStream.readRequest.actualLength == -1) {
                        this.eofSeen = true;
                    }
                    return ManagedSystemInStream.readRequest.actualLength;
                }
                try {
                    ManagedSystemInStream.readRequest.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            boolean doRead;
            ReadRequest readRequest = ManagedSystemInStream.readRequest;
            synchronized (readRequest) {
                boolean bl = doRead = ManagedSystemInStream.readRequest.requestData && !ManagedSystemInStream.readRequest.validData;
                if (!doRead) {
                    try {
                        ManagedSystemInStream.readRequest.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            if (!doRead) continue;
            try {
                ManagedSystemInStream.readRequest.actualLength = stdin.read(ManagedSystemInStream.readRequest.buf, ManagedSystemInStream.readRequest.offset, ManagedSystemInStream.readRequest.len);
            }
            catch (IOException e1) {
                ManagedSystemInStream.readRequest.exception = e1;
            }
            readRequest = ManagedSystemInStream.readRequest;
            synchronized (readRequest) {
                ManagedSystemInStream.readRequest.validData = true;
                ManagedSystemInStream.readRequest.requestData = false;
                ManagedSystemInStream.readRequest.notifyAll();
            }
        }
        stdin = null;
        readThread = null;
        this.disposeLatch.countDown();
    }

    private static class ReadRequest {
        byte[] buf;
        int offset;
        int len;
        int actualLength;
        IOException exception = null;
        boolean validData = false;
        boolean requestData = false;

        private ReadRequest() {
        }

        private void clear() {
            this.buf = null;
            this.actualLength = 0;
            this.len = 0;
            this.offset = 0;
            this.exception = null;
            this.requestData = false;
            this.validData = false;
        }
    }
}

