/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclString;
import tcl.lang.channel.TclByteArrayChannel;
import tcl.lang.process.Redirect;
import tcl.lang.process.TclProcess;

public class Pipeline
implements Runnable {
    private ArrayList<TclProcess> processes = new ArrayList();
    private boolean redirectStderrToResult = false;
    private boolean execInBackground = false;
    Interp interp = null;
    Redirect stdinRedirect = null;
    Redirect stdoutRedirect = null;
    Redirect stderrRedirect = null;
    TclException savedException = null;
    private static final Set<String> redirectors;

    static {
        HashSet<String> rd = new HashSet<String>(13);
        rd.add("<");
        rd.add("<@");
        rd.add("<<");
        rd.add(">");
        rd.add("2>");
        rd.add(">&");
        rd.add(">>");
        rd.add("2>>");
        rd.add(">>&");
        rd.add(">@");
        rd.add("2>@");
        rd.add("2>@1");
        rd.add(">&@");
        redirectors = Collections.unmodifiableSet(rd);
    }

    public Pipeline(Interp interp, TclObject[] objv, int startIndex) throws TclException {
        ArrayList<String> commandList = new ArrayList<String>();
        File cwd = interp.getWorkingDir();
        this.interp = interp;
        int endIndex = objv.length - 1;
        if (objv[endIndex].toString().equals("&")) {
            this.setExecInBackground(true);
            --endIndex;
        }
        int i = startIndex;
        while (i <= endIndex) {
            String arg = objv[i].toString();
            if (arg.equals("|")) {
                if (commandList.size() == 0 || i == endIndex) {
                    throw new TclException(interp, "illegal use of | or |& in command");
                }
                this.addCommand(commandList, cwd);
                commandList = new ArrayList();
            } else if (arg.equals("|&")) {
                if (commandList.size() == 0 || i == endIndex) {
                    throw new TclException(interp, "illegal use of | or |& in command");
                }
                int newCmdIndex = this.addCommand(commandList, cwd);
                this.processes.get(newCmdIndex).setStderrRedirect(Redirect.stderrToStdout());
                commandList = new ArrayList();
            } else {
                int argLen = arg.length();
                String redirector = null;
                int j = argLen > 4 ? 4 : argLen;
                while (j >= 1) {
                    redirector = arg.substring(0, j);
                    if (redirectors.contains(redirector)) break;
                    redirector = null;
                    --j;
                }
                if (redirector == null) {
                    commandList.add(arg);
                } else if ("2>@1".equals(redirector)) {
                    this.redirectStderrToResult = true;
                } else {
                    String redirectee = null;
                    if (arg.length() > redirector.length()) {
                        redirectee = arg.substring(redirector.length());
                    } else {
                        if (++i > endIndex) {
                            throw new TclException(interp, "can't specify \"" + redirector + "\" as last word in command");
                        }
                        redirectee = objv[i].toString();
                    }
                    Redirect redirect = null;
                    if (redirector.contains("@")) {
                        channel = TclIO.getChannel(interp, redirectee);
                        if (channel == null) {
                            throw new TclException(interp, "could not find channel named \"" + redirectee + "\"");
                        }
                        redirect = new Redirect(channel, false);
                    } else if (redirector.equals("<<")) {
                        channel = new TclByteArrayChannel(interp, TclString.newInstance(redirectee));
                        TclIO.registerChannel(interp, channel);
                        redirect = new Redirect(channel, true);
                    } else {
                        File redirfile = FileUtil.getNewFileObj(interp, redirectee);
                        redirect = new Redirect(redirfile, redirectee, redirector.contains(">>"));
                    }
                    if (redirector.startsWith("2")) {
                        this.stderrRedirect = redirect;
                    } else if (redirector.contains(">")) {
                        this.stdoutRedirect = redirect;
                        if (redirector.contains("&")) {
                            this.stderrRedirect = redirect;
                        }
                    } else {
                        this.stdinRedirect = redirect;
                    }
                }
            }
            ++i;
        }
        if (commandList.size() > 0) {
            this.addCommand(commandList, cwd);
        }
    }

    public int addCommand(List<String> command, File workingDir) throws TclException {
        int lastProcIndex;
        String cmd = command.get(0);
        cmd = FileUtil.translateFileName(this.interp, cmd);
        TclProcess proc = TclProcess.newInstance(this.interp);
        proc.setCommand(command);
        if (workingDir != null) {
            proc.setWorkingDir(workingDir);
        }
        if ((lastProcIndex = this.processes.size() - 1) >= 0) {
            TclProcess upstreamProcess = this.processes.get(lastProcIndex);
            proc.setStdinRedirect(new Redirect(upstreamProcess));
            upstreamProcess.setStdoutRedirect(new Redirect(proc));
        }
        this.processes.add(proc);
        return this.processes.size() - 1;
    }

    public void exec() throws TclException {
        if (this.processes.size() == 0) {
            return;
        }
        if (this.stdinRedirect != null) {
            if (this.stdinRedirect.getType() == Redirect.Type.INHERIT && this.execInBackground && !this.processes.get(0).canInheritFileDescriptors()) {
                this.processes.get(0).setStdinRedirect(null);
            } else {
                this.processes.get(0).setStdinRedirect(this.stdinRedirect);
            }
        }
        if (this.stdoutRedirect != null) {
            this.processes.get(this.processes.size() - 1).setStdoutRedirect(this.stdoutRedirect);
        }
        int i = 0;
        while (i < this.processes.size()) {
            TclProcess process = this.processes.get(i);
            if (process.getStderrRedirect() == null && this.stderrRedirect != null) {
                process.setStderrRedirect(this.stderrRedirect);
            }
            try {
                process.start();
            }
            catch (IOException e) {
                throw new TclPosixException(this.interp, e, true, "couldn't execute \"" + process.command().get(0) + "\"");
            }
            ++i;
        }
    }

    public void waitForExitAndCleanup(boolean force) throws TclException {
        int i = 0;
        while (i < this.processes.size()) {
            if (force) {
                this.processes.get(i).destroy();
            } else {
                try {
                    this.processes.get(i).waitFor();
                }
                catch (InterruptedException interruptedException) {
                    this.processes.get(i).destroy();
                }
                catch (IOException e1) {
                    throw new TclPosixException(this.interp, e1, true, "Error");
                }
            }
            ++i;
        }
    }

    public Redirect getStdinRedirect() {
        return this.stdinRedirect;
    }

    public void setStdinRedirect(Redirect stdinRedirect) {
        this.stdinRedirect = stdinRedirect;
    }

    public Redirect getStdoutRedirect() {
        return this.stdoutRedirect;
    }

    public void setStdoutRedirect(Redirect stdoutRedirect) {
        this.stdoutRedirect = stdoutRedirect;
    }

    public Redirect getStderrRedirect() {
        return this.stderrRedirect;
    }

    public void setStderrRedirect(Redirect stderrRedirect) {
        this.stderrRedirect = stderrRedirect;
    }

    public boolean isExecInBackground() {
        return this.execInBackground;
    }

    public void setExecInBackground(boolean execInBackground) {
        this.execInBackground = execInBackground;
    }

    public boolean isErrorRedirectedToResult() {
        return this.redirectStderrToResult;
    }

    public int[] getProcessIdentifiers() {
        int[] pid = new int[this.processes.size()];
        int i = 0;
        while (i < this.processes.size()) {
            pid[i] = this.processes.get(i).getPid();
            ++i;
        }
        return pid;
    }

    public int[] getExitValues() {
        int[] exitValues = new int[this.processes.size()];
        int i = 0;
        while (i < this.processes.size()) {
            try {
                exitValues[i] = this.processes.get(i).exitValue();
            }
            catch (Exception exception) {
                exitValues[i] = 0;
            }
            ++i;
        }
        return exitValues;
    }

    public void throwAnyExceptions() throws TclException {
        if (this.savedException != null) {
            throw this.savedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.waitForExitAndCleanup(false);
        }
        catch (TclException e) {
            Pipeline pipeline = this;
            synchronized (pipeline) {
                this.savedException = e;
            }
        }
    }
}

