/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BinaryMathFunction;
import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclException;

class PowFunction
extends BinaryMathFunction {
    PowFunction() {
    }

    @Override
    void apply(Interp interp, ExprValue[] values) throws TclException {
        double x = values[0].getDoubleValue();
        double y = values[1].getDoubleValue();
        if (x < 0.0 && (double)((int)y) != y) {
            Expression.DomainError(interp);
        }
        double d = Math.pow(x, y);
        Expression.checkDoubleRange(interp, d);
        values[0].setDoubleValue(d);
    }
}

