/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObjectBase;
import tcl.lang.Util;
import tcl.lang.VarTrace;

final class PrecTraceProc
implements VarTrace {
    static final int TCL_MAX_PREC = 17;

    PrecTraceProc() {
    }

    @Override
    public void traceProc(Interp interp, String name1, String name2, int flags) throws TclException {
        if ((flags & 0x40) != 0) {
            if ((flags & 0x80) != 0 && (flags & 0x100) == 0) {
                interp.traceVar(name1, name2, new PrecTraceProc(), 113);
            }
            return;
        }
        if ((flags & 0x10) != 0) {
            interp.setVar(name1, name2, Util.precision, flags & 1);
            return;
        }
        if (interp.isSafe) {
            throw new TclException(interp, "can't modify precision from a safe interpreter");
        }
        TclObjectBase tobj = null;
        try {
            tobj = interp.getVar(name1, name2, flags & 1);
        }
        catch (TclException tclException) {}
        String value = tobj != null ? tobj.toString() : "";
        StrtoulResult r = interp.strtoulResult;
        Util.strtoul(value, 0, 10, r);
        if (r.value <= 0L || r.value > 17L || r.value > 100L || r.index == 0 || r.index != value.length()) {
            interp.setVar(name1, name2, Util.precision, 1);
            throw new TclException(interp, "improper value for precision");
        }
        Util.precision = (int)r.value;
    }
}

