/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class Procedure
implements Command,
CommandWithDispose {
    public TclObject[][] argList;
    public boolean isVarArgs;
    public CharPointer body;
    int body_length;
    public WrappedCommand wcmd;
    String srcFileName;
    int srcLineNumber;

    public Procedure(Interp interp, Namespace ns, String name, TclObject args, TclObject b, String sFileName, int sLineNumber) throws TclException {
        this.srcFileName = sFileName;
        this.srcLineNumber = sLineNumber;
        int numArgs = TclList.getLength(interp, args);
        this.argList = new TclObject[numArgs][2];
        int i = 0;
        while (i < numArgs) {
            TclObject argSpec = TclList.index(interp, args, i);
            int specLen = TclList.getLength(interp, argSpec);
            if (specLen == 0) {
                throw new TclException(interp, "argument with no name");
            }
            if (specLen > 2) {
                throw new TclException(interp, "too many fields in argument specifier \"" + argSpec + "\"");
            }
            TclObject argName = TclList.index(interp, argSpec, 0);
            String argNameStr = argName.toString();
            if (argNameStr.indexOf("::") != -1) {
                throw new TclException(interp, "formal parameter \"" + argSpec + "\" is not a simple name");
            }
            if (Var.isArrayVarname(argNameStr)) {
                throw new TclException(interp, "formal parameter \"" + argSpec + "\" is an array element");
            }
            this.argList[i][0] = argName;
            this.argList[i][0].preserve();
            if (specLen == 2) {
                this.argList[i][1] = TclList.index(interp, argSpec, 1);
                this.argList[i][1].preserve();
            } else {
                this.argList[i][1] = null;
            }
            ++i;
        }
        this.isVarArgs = numArgs > 0 && this.argList[numArgs - 1][0].toString().equals("args");
        this.body = new CharPointer(b.toString());
        this.body_length = this.body.length();
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        block16: {
            CallFrame frame = interp.newCallFrame(this, argv);
            interp.pushDebugStack(this.srcFileName, this.srcLineNumber);
            try {
                try {
                    Parser.eval2(interp, this.body.array, this.body.index, this.body_length, 0);
                }
                catch (TclException e) {
                    int code = e.getCompletionCode();
                    if (code == 2) {
                        int realCode = interp.updateReturnInfo();
                        if (realCode != 0) {
                            e.setCompletionCode(realCode);
                            throw e;
                        }
                    } else {
                        if (code == 1) {
                            if (this.isLambda()) {
                                TclObject name = TclList.newInstance();
                                TclList.append(interp, name, argv, 0, 2);
                                interp.addErrorInfo("\n    (lambda term \"" + name.toString() + "\" line " + interp.errorLine + ")");
                            } else {
                                interp.addErrorInfo("\n    (procedure \"" + argv[0] + "\" line " + interp.errorLine + ")");
                            }
                            throw e;
                        }
                        if (code == 3) {
                            throw new TclException(interp, "invoked \"break\" outside of a loop");
                        }
                        if (code == 4) {
                            throw new TclException(interp, "invoked \"continue\" outside of a loop");
                        }
                        throw e;
                    }
                    interp.popDebugStack();
                    if (interp.errInProgress) {
                        frame.dispose();
                        interp.errInProgress = true;
                        break block16;
                    }
                    frame.dispose();
                }
            }
            finally {
                interp.popDebugStack();
                if (interp.errInProgress) {
                    frame.dispose();
                    interp.errInProgress = true;
                } else {
                    frame.dispose();
                }
            }
        }
    }

    @Override
    public void disposeCmd() {
        this.body = null;
        int i = 0;
        while (i < this.argList.length) {
            this.argList[i][0].release();
            this.argList[i][0] = null;
            if (this.argList[i][1] != null) {
                this.argList[i][1].release();
                this.argList[i][1] = null;
            }
            ++i;
        }
        this.argList = null;
    }

    public boolean isLambda() {
        return this.wcmd.hashKey == null;
    }

    public static boolean isProc(WrappedCommand cmd) {
        return cmd.cmd instanceof Procedure;
    }

    public static Procedure findProc(Interp interp, String procName) {
        WrappedCommand cmd;
        try {
            cmd = Namespace.findCommand(interp, procName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        if (cmd == null) {
            return null;
        }
        WrappedCommand origCmd = Namespace.getOriginalCommand(cmd);
        if (origCmd != null) {
            cmd = origCmd;
        }
        if (!(cmd.cmd instanceof Procedure)) {
            return null;
        }
        return (Procedure)cmd.cmd;
    }
}

