/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public final class QSort {
    public static final int ASCII = 0;
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    public static final int COMMAND = 3;
    public static final int DICTIONARY = 4;
    private int sortMode;
    private int sortIndex;
    private boolean sortIncreasing;
    private String sortCommand;
    private Interp sortInterp;

    /*
     * Unable to fully structure code
     */
    private final void quickSort(TclObject[] a, int lo0, int hi0) throws TclException {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            midIndex = lo0 + hi0 >>> 1;
            mid = a[midIndex];
            ** GOTO lbl17
            {
                ++lo;
                do {
                    if (lo < hi0 && lo != midIndex && this.compare(a[lo], mid) < 0) continue block0;
                    while (hi > lo0 && hi != midIndex && this.compare(a[hi], mid) > 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    QSort.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl17:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private static final void swap(TclObject[] a, int i, int j) {
        TclObject T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    final void sort(Interp interp, TclObject[] a, int mode, int index, boolean increasing, String cmd) throws TclException {
        this.sortInterp = interp;
        this.sortMode = mode;
        this.sortIndex = index;
        this.sortIncreasing = increasing;
        this.sortCommand = cmd;
        this.quickSort(a, 0, a.length - 1);
    }

    final int compare(TclObject obj1, TclObject obj2) throws TclException {
        int code = 0;
        if (this.sortIndex != -1) {
            int index = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, obj1) + (this.sortIndex + 1) : this.sortIndex;
            TclObject obj = TclList.index(this.sortInterp, obj1, index);
            if (obj == null) {
                throw new TclException(this.sortInterp, "element " + index + " missing from sublist \"" + obj1 + "\"");
            }
            obj1 = obj;
            index = this.sortIndex < -1 ? TclList.getLength(this.sortInterp, obj2) + (this.sortIndex + 1) : this.sortIndex;
            obj = TclList.index(this.sortInterp, obj2, index);
            if (obj == null) {
                throw new TclException(this.sortInterp, "element " + index + " missing from sublist \"" + obj2 + "\"");
            }
            obj2 = obj;
        }
        switch (this.sortMode) {
            case 0: {
                code = obj1.toString().compareTo(obj2.toString());
                break;
            }
            case 4: {
                code = this.doDictionary(obj1.toString(), obj2.toString());
                break;
            }
            case 1: {
                try {
                    long int1 = TclInteger.getLong(this.sortInterp, obj1);
                    long int2 = TclInteger.getLong(this.sortInterp, obj2);
                    if (int1 > int2) {
                        code = 1;
                        break;
                    }
                    if (int2 <= int1) break;
                    code = -1;
                    break;
                }
                catch (TclException e1) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to integer)");
                    throw e1;
                }
            }
            case 2: {
                try {
                    double f1 = TclDouble.get(this.sortInterp, obj1);
                    double f2 = TclDouble.get(this.sortInterp, obj2);
                    if (f1 > f2) {
                        code = 1;
                        break;
                    }
                    if (!(f2 > f1)) break;
                    code = -1;
                    break;
                }
                catch (TclException e2) {
                    this.sortInterp.addErrorInfo("\n    (converting list element from string to real)");
                    throw e2;
                }
            }
            case 3: {
                StringBuffer sbuf = new StringBuffer(this.sortCommand);
                Util.appendElement(this.sortInterp, sbuf, obj1.toString());
                Util.appendElement(this.sortInterp, sbuf, obj2.toString());
                try {
                    this.sortInterp.eval(sbuf.toString(), 0);
                }
                catch (TclException e3) {
                    this.sortInterp.addErrorInfo("\n    (-compare command)");
                    throw e3;
                }
                try {
                    code = TclInteger.getInt(this.sortInterp, this.sortInterp.getResult());
                    break;
                }
                catch (TclException tclException) {
                    this.sortInterp.resetResult();
                    TclException e4 = new TclException(this.sortInterp, "-compare command returned non-integer result");
                    throw e4;
                }
            }
            default: {
                throw new TclRuntimeError("Unknown sortMode " + this.sortMode);
            }
        }
        if (this.sortIncreasing) {
            return code;
        }
        return -code;
    }

    private final int doDictionary(String str1, String str2) {
        int index1 = 0;
        int index2 = 0;
        int len1 = str1.length();
        int len2 = str2.length();
        int secondaryDiff = 0;
        while (index1 < len1 && index2 < len2) {
            char lc2;
            char c1 = str1.charAt(index1);
            char c2 = str2.charAt(index2);
            if (Character.isDigit(c1) && Character.isDigit(c2)) {
                long v2;
                int endNum1 = index1 + 1;
                while (endNum1 < len1 && Character.isDigit(str1.charAt(endNum1))) {
                    ++endNum1;
                }
                int endNum2 = index2 + 1;
                while (endNum2 < len2 && Character.isDigit(str2.charAt(endNum2))) {
                    ++endNum2;
                }
                long v1 = Long.parseLong(str1.substring(index1, endNum1));
                if (v1 < (v2 = Long.parseLong(str2.substring(index2, endNum2)))) {
                    return -1;
                }
                if (v1 > v2) {
                    return 1;
                }
                if (secondaryDiff == 0) {
                    if (endNum1 - index1 < endNum2 - index2) {
                        secondaryDiff = -1;
                    } else if (endNum1 - index1 > endNum2 - index2) {
                        secondaryDiff = 1;
                    }
                }
                index1 = endNum1;
                index2 = endNum2;
                continue;
            }
            char lc1 = Character.toLowerCase(c1);
            if (lc1 < (lc2 = Character.toLowerCase(c2))) {
                return -1;
            }
            if (lc1 > lc2) {
                return 1;
            }
            if (secondaryDiff == 0) {
                if (c1 < c2) {
                    secondaryDiff = -1;
                }
                if (c1 > c2) {
                    secondaryDiff = 1;
                }
            }
            ++index1;
            ++index2;
        }
        if (index1 == len1 && index2 < len2) {
            return -1;
        }
        if (index1 < len1 && index2 == len2) {
            return 1;
        }
        return secondaryDiff;
    }
}

