/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class Regex {
    public static final int TCL_REG_BASIC = 0;
    public static final int TCL_REG_EXTENDED = 1;
    public static final int TCL_REG_ADVF = 2;
    public static final int TCL_REG_ADVANCED = 3;
    public static final int TCL_REG_QUOTE = 4;
    public static final int TCL_REG_NOCASE = 8;
    public static final int TCL_REG_NOSUB = 16;
    public static final int TCL_REG_EXPANDED = 32;
    public static final int TCL_REG_NLSTOP = 64;
    public static final int TCL_REG_NLANCH = 128;
    public static final int TCL_REG_NEWLINE = 192;
    public static final int TCL_REG_CANMATCH = 512;
    private Pattern pattern;
    private Matcher matcher;
    private int flags;
    private String regexp;
    private String string;
    private int count;
    private int offset;
    private boolean matchCalled = false;
    private static final Map bracketMap;

    static {
        HashMap<String, String> br = new HashMap<String, String>();
        br.put("[:alnum:]", "\\p{Alnum}");
        br.put("[:alpha:]", "\\p{Alpha}");
        br.put("[:ascii:]", "\\p{ASCII}");
        br.put("[:blank:]", "\\p{Blank}");
        br.put("[:cntrl:]", "\\p{Cntrl}");
        br.put("[:digit:]", "\\d");
        br.put("[:graph:]", "\\p{Graph}");
        br.put("[:lower:]", "\\p{Lower}");
        br.put("[:print:]", "\\p{Print}");
        br.put("[:punct:]", "\\p{Punct}");
        br.put("[:space:]", "\\s");
        br.put("[:upper:]", "\\p{Upper}");
        br.put("[:word:]", "\\w");
        br.put("[:xdigit:]", "\\p{XDigit}");
        br.put("[:<:]", "(?=\\w)(?<=\\W|^)");
        br.put("[:>:]", "(?=\\W|$)(?<=\\w)");
        br.put("[.\\.]", "\\\\");
        br.put("[.-.]", "\\-");
        br.put("[.].]", "\\]");
        br.put("[.^.]", "\\^");
        br.put("[.NUL.]", "\\00");
        br.put("[.SOH.]", "\\001");
        br.put("[.STX.]", "\\002");
        br.put("[.ETX.]", "\\003");
        br.put("[.EOT.]", "\\004");
        br.put("[.ENQ.]", "\\005");
        br.put("[.ACK.]", "\\006");
        br.put("[.BEL.]", "\\007");
        br.put("[.alert.]", "\\007");
        br.put("[.BS.]", "\\010");
        br.put("[.backspace.]", "\\b");
        br.put("[.HT.]", "\\011");
        br.put("[.tab.]", "\\t");
        br.put("[.LF.]", "\\012");
        br.put("[.newline.]", "\\n");
        br.put("[.VT.]", "\\013");
        br.put("[.vertical-tab.]", "\\013");
        br.put("[.FF.]", "\\014");
        br.put("[.form-feed.]", "\\f");
        br.put("[.CR.]", "\\015");
        br.put("[.carriage-return.]", "\\r");
        br.put("[.SO.]", "\\016");
        br.put("[.SI.]", "\\017");
        br.put("[.DLE.]", "\\020");
        br.put("[.DC1.]", "\\021");
        br.put("[.DC2.]", "\\022");
        br.put("[.DC3.]", "\\023");
        br.put("[.DC4.]", "\\024");
        br.put("[.NAK.]", "\\025");
        br.put("[.SYN.]", "\\026");
        br.put("[.ETB.]", "\\027");
        br.put("[.CAN.]", "\\030");
        br.put("[.EM.]", "\\031");
        br.put("[.SUB.]", "\\032");
        br.put("[.ESC.]", "\\033");
        br.put("[.IS4.]", "\\034");
        br.put("[.FS.]", "\\034");
        br.put("[.IS3.]", "\\035");
        br.put("[.GS.]", "\\035");
        br.put("[.IS2.]", "\\036");
        br.put("[.RS.]", "\\036");
        br.put("[.IS1.]", "\\037");
        br.put("[.US.]", "\\037");
        br.put("[.space.]", "\\ ");
        br.put("[.exclamation-mark.]", "!");
        br.put("[.quotation-mark.]", "\"");
        br.put("[.number-sign.]", "\\#");
        br.put("[.dollar-sign.]", "\\$");
        br.put("[.percent-sign.]", "\\%");
        br.put("[.ampersand.]", "&");
        br.put("[.apostrophe.]", "\\'");
        br.put("[.left-parenthesis.]", "\\(");
        br.put("[.right-parenthesis.]", "\\)");
        br.put("[.asterisk.]", "\\*");
        br.put("[.plus-sign.]", "\\+");
        br.put("[.comma.]", ",");
        br.put("[.hyphen.]", "\\-");
        br.put("[.hyphen-minus.]", "\\-");
        br.put("[.period.]", "\\.");
        br.put("[.full-stop.]", "\\.");
        br.put("[.slash.]", "/");
        br.put("[.solidus.]", "/");
        br.put("[.zero.]", "0");
        br.put("[.one.]", "1");
        br.put("[.two.]", "2");
        br.put("[.three.]", "3");
        br.put("[.four.]", "4");
        br.put("[.five.]", "5");
        br.put("[.six.]", "6");
        br.put("[.seven.]", "7");
        br.put("[.eight.]", "8");
        br.put("[.nine.]", "9");
        br.put("[.colon.]", "\\:");
        br.put("[.semicolon.]", ";");
        br.put("[.less-than-sign.]", "<");
        br.put("[.equals-sign.]", "=");
        br.put("[.greater-than-sign.]", ">");
        br.put("[.question-mark.]", "\\?");
        br.put("[.commercial-at.]", "@");
        br.put("[.left-square-bracket.]", "\\[");
        br.put("[.backslash.]", "\\\\");
        br.put("[.reverse-solidus.]", "\\\\");
        br.put("[.right-square-bracket.]", "\\]");
        br.put("[.circumflex.]", "\\^");
        br.put("[.circumflex-accent.]", "\\^");
        br.put("[.underscore.]", "_");
        br.put("[.low-line.]", "_");
        br.put("[.grave-accent.]", "`");
        br.put("[.left-brace.]", "\\{");
        br.put("[.left-curly-bracket.]", "\\{");
        br.put("[.vertical-line.]", "|");
        br.put("[.right-brace.]", "\\}");
        br.put("[.right-curly-bracket.]", "\\}");
        br.put("[.tilde.]", "~");
        br.put("[.DEL.]", "\\0177");
        bracketMap = Collections.unmodifiableMap(br);
    }

    public Regex(String regexp, String string, int offset, int flags) throws PatternSyntaxException {
        this.initialize(regexp, string, offset, flags | 3);
    }

    public Regex(String regexp, String string, int offset) throws PatternSyntaxException {
        this.initialize(regexp, string, offset, 3);
    }

    public Regex(String regexp, String string, int offset, int flags, String xflags) throws PatternSyntaxException {
        this.flags = 3 | flags;
        this.parseFlagString(xflags, false);
        this.initialize(regexp, string, offset, this.flags);
    }

    private void initialize(String regexp, String string, int offset, int flags) throws PatternSyntaxException {
        this.flags = flags;
        this.regexp = regexp;
        this.string = string;
        this.count = 0;
        this.offset = offset;
        this.pattern = this.compile(regexp);
        this.matcher = this.pattern.matcher(this.string);
    }

    public boolean match() {
        boolean found;
        if (this.matchCalled) {
            found = this.matcher.find();
        } else {
            this.matchCalled = true;
            int off = this.offset;
            if (off > this.string.length()) {
                off = this.string.length();
            }
            found = this.matcher.find(off);
        }
        if (found) {
            ++this.count;
        }
        return found;
    }

    public String replace(String tclSubSpec, boolean all) {
        StringBuffer sb = new StringBuffer(this.string.length());
        boolean found = this.match();
        String javaSubSpec = null;
        if (found) {
            javaSubSpec = Regex.parseSubSpec(tclSubSpec);
        }
        while (found) {
            this.matcher.appendReplacement(sb, javaSubSpec);
            boolean bl = found = all && this.match();
        }
        this.matcher.appendTail(sb);
        return sb.toString();
    }

    public TclObject getInfo(Interp interp) throws TclException {
        TclObject props = TclList.newInstance();
        String groupCount = String.valueOf(this.matcher.groupCount());
        this.pattern.flags();
        TclList.append(interp, props, TclString.newInstance(groupCount));
        TclList.append(interp, props, TclString.newInstance(""));
        return props;
    }

    protected static String parseSubSpec(String subSpec) {
        boolean escaped = false;
        StringBuffer sb = new StringBuffer();
        int len = subSpec.length();
        int i = 0;
        while (i < len) {
            char c = subSpec.charAt(i);
            if (c == '&') {
                if (escaped) {
                    sb.append(c);
                    escaped = false;
                } else {
                    sb.append("$0");
                }
            } else if (escaped && c == '0') {
                escaped = false;
                sb.append("$0");
            } else if (escaped && c >= '1' && c <= '9') {
                escaped = false;
                sb.append('$');
                sb.append(c);
            } else if (c == '$') {
                if (escaped) {
                    sb.append("\\\\");
                    escaped = false;
                }
                sb.append("\\$");
            } else if (c == '\\') {
                if (escaped) {
                    sb.append("\\\\");
                    escaped = false;
                } else {
                    escaped = true;
                }
            } else {
                if (escaped) {
                    sb.append("\\\\");
                    escaped = false;
                }
                sb.append(c);
            }
            ++i;
        }
        if (escaped) {
            sb.append("\\\\");
        }
        return sb.toString();
    }

    public int groupCount() {
        return this.matcher.groupCount();
    }

    public int start() {
        return this.matcher.start();
    }

    public int start(int group) {
        return this.matcher.start(group);
    }

    public int end() {
        return this.matcher.end();
    }

    public int end(int group) {
        return this.matcher.end(group);
    }

    public String group() {
        return this.matcher.group();
    }

    public String group(int group) {
        return this.matcher.group(group);
    }

    String getRegexp() {
        return this.regexp;
    }

    String getString() {
        return this.string;
    }

    public int getCount() {
        return this.count;
    }

    public int getOffset() {
        return this.offset;
    }

    private static int endOfDigits(StringBuffer b, int index, boolean hex) {
        int i = index;
        while (i < b.length()) {
            switch (b.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    break;
                }
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (hex) break;
                    return i;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return b.length();
    }

    public static String getPatternSyntaxMessage(PatternSyntaxException ex) {
        String prefix = "couldn't compile regular expression pattern: ";
        String suffix = null;
        String msg = ex.getMessage();
        ex.getIndex();
        ex.getPattern();
        if (msg.indexOf("Unclosed group near") != -1) {
            suffix = "parentheses () not balanced";
        } else if (msg.indexOf("Unclosed character class near") != -1) {
            suffix = "brackets [] not balanced";
        } else if (msg.indexOf("Dangling meta character") != -1) {
            suffix = "quantifier operand invalid";
        } else if (msg.indexOf("Unclosed counted closure") != -1) {
            suffix = "braces {} not balanced";
        }
        if (suffix == null) {
            suffix = ex.getMessage();
        }
        return String.valueOf(prefix) + suffix;
    }

    protected int getJavaFlags() {
        int javaFlags = 0;
        javaFlags = (this.flags & 8) == 8 ? (javaFlags |= 2) : (javaFlags &= 0xFFFFFFFD);
        javaFlags = (this.flags & 0x40) == 64 ? (javaFlags &= 0xFFFFFFDF) : (javaFlags |= 0x20);
        return javaFlags;
    }

    protected int parseFlagString(String optionString, boolean isEmbed) throws PatternSyntaxException {
        int len = optionString.length();
        boolean validFlag = true;
        boolean has_q = false;
        boolean has_eaxn = false;
        if (isEmbed) {
            if (len < 3) {
                return 0;
            }
            if ((this.flags & 4) != 0) {
                return 0;
            }
        } else {
            if ((this.flags & 0x20) != 0) {
                has_eaxn = true;
            }
            if ((this.flags & 0xC0) == 192) {
                has_eaxn = true;
            }
        }
        int i = 0;
        while (i < len) {
            block38: {
                char c;
                block37: {
                    c = optionString.charAt(i);
                    if (!isEmbed) break block37;
                    if (i == 0 && c != '(') {
                        return 0;
                    }
                    if (i == 1 && c != '?') {
                        return 0;
                    }
                    if (i == 2 && c == ':') {
                        return 0;
                    }
                    if (i == 2 && c == '=') {
                        return 0;
                    }
                    if (i > 1 && c == ')') {
                        return i + 1;
                    }
                    if (i < 2) break block38;
                }
                switch (c) {
                    case 'a': {
                        if (isEmbed) {
                            validFlag = false;
                            break;
                        }
                        this.flags |= 2;
                        has_eaxn = true;
                        break;
                    }
                    case 'b': {
                        this.flags &= 0xFFFFFFFC;
                        break;
                    }
                    case 'c': {
                        this.flags &= 0xFFFFFFF7;
                        break;
                    }
                    case 'e': {
                        this.flags &= 0xFFFFFFFC;
                        this.flags |= 1;
                        has_eaxn = true;
                        break;
                    }
                    case 'i': {
                        this.flags |= 8;
                        break;
                    }
                    case 'n': {
                        has_eaxn = true;
                    }
                    case 'm': {
                        this.flags |= 0xC0;
                        break;
                    }
                    case 'p': {
                        this.flags |= 0x40;
                        this.flags &= 0xFFFFFF7F;
                        break;
                    }
                    case 'q': {
                        this.flags |= 4;
                        has_q = true;
                        break;
                    }
                    case 's': {
                        if (!isEmbed) break;
                        this.flags &= 0xFFFFFF3F;
                        break;
                    }
                    case 't': {
                        if (isEmbed) {
                            this.flags &= 0xFFFFFFDF;
                            break;
                        }
                        this.flags |= 0x200;
                        break;
                    }
                    case 'w': {
                        this.flags &= 0xFFFFFFBF;
                        this.flags |= 0x80;
                        break;
                    }
                    case 'x': {
                        this.flags |= 0x20;
                        has_eaxn = true;
                        break;
                    }
                    case '$': 
                    case '+': 
                    case '^': {
                        if (isEmbed) {
                            validFlag = false;
                            break;
                        }
                        throw new PatternSyntaxException("Unsupported xflag " + c, optionString, 0);
                    }
                    default: {
                        if (!isEmbed) break;
                        validFlag = false;
                    }
                }
                if (!validFlag) {
                    throw new PatternSyntaxException("Unknown flag " + c, optionString, i);
                }
            }
            ++i;
        }
        if (!isEmbed && has_q && has_eaxn) {
            throw new PatternSyntaxException("Incompatible xflags: q with e, a, x or n", optionString, 0);
        }
        return len;
    }

    protected void testForUnsupportedFlags() throws PatternSyntaxException {
        if ((this.flags & 3) == 0) {
            throw new PatternSyntaxException("BREs not supported", this.regexp, 0);
        }
        if ((this.flags & 3) == 1) {
            throw new PatternSyntaxException("EREs not supported", this.regexp, 0);
        }
        if ((this.flags & 3) == 2) {
            throw new PatternSyntaxException("RREs not supported", this.regexp, 0);
        }
        if ((this.flags & 0x200) != 0) {
            throw new PatternSyntaxException("TCL_REG_CANMATCH not supported", this.regexp, 0);
        }
    }

    private static boolean isCommentWhitespace(StringBuffer sb, int index, boolean inBrackets, int flags) {
        if ((flags & 0x20) == 0) {
            return false;
        }
        if (inBrackets) {
            return false;
        }
        if (index >= sb.length()) {
            return false;
        }
        return Character.isWhitespace(sb.charAt(index));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Pattern compile(String tclRegex) throws PatternSyntaxException {
        int endOfFlags;
        StringBuffer regexsb = new StringBuffer(tclRegex);
        int index = 0;
        int bracketExprIndex = -1;
        boolean inBrackets = false;
        Stack<Boolean> groupStack = new Stack<Boolean>();
        Stack<Integer> openSubExpressions = new Stack<Integer>();
        Vector<Boolean> validSubExpression = new Vector<Boolean>();
        if (regexsb.length() >= 4 && '*' == regexsb.charAt(0) && (this.flags & 4) != 4) {
            String s = regexsb.substring(0, 4);
            if ("***:".equals(s)) {
                regexsb.delete(0, 4);
                this.flags |= 3;
            } else if ("***=".equals(s)) {
                regexsb.delete(0, 4);
                this.flags |= 4;
            }
        }
        if ((endOfFlags = this.parseFlagString(regexsb.toString(), true)) > 0) {
            regexsb.delete(0, endOfFlags);
        }
        this.testForUnsupportedFlags();
        if (regexsb.length() == 0) {
            regexsb.insert(0, "^|(?!$)");
            index = regexsb.length();
        }
        while (index < regexsb.length() && (this.flags & 4) != 4) {
            if (!inBrackets && regexsb.charAt(index) == '(' && index + 3 < regexsb.length() && regexsb.charAt(index + 1) == '?' && regexsb.charAt(index + 2) == '#') {
                int end = index + 3;
                while (end < regexsb.length() && regexsb.charAt(end) != ')') {
                    ++end;
                }
                regexsb.delete(index, end + 1);
                ++index;
                continue;
            }
            if (!inBrackets && (this.flags & 0x20) != 0) {
                int end = index;
                while (Regex.isCommentWhitespace(regexsb, end, inBrackets, this.flags)) {
                    ++end;
                }
                if (end < regexsb.length() && regexsb.charAt(end) == '#') {
                    ++end;
                    while (end < regexsb.length() && regexsb.charAt(end) != '\n') {
                        ++end;
                    }
                    if (end < regexsb.length()) {
                        ++end;
                    }
                }
                if (end > index) {
                    regexsb.delete(index, end);
                    continue;
                }
            }
            if (!inBrackets && regexsb.charAt(index) == '(') {
                boolean isCaptureGroup;
                if (index + 1 < regexsb.length() && regexsb.charAt(index + 1) != '?') {
                    isCaptureGroup = true;
                    openSubExpressions.push(new Integer(validSubExpression.size()));
                    validSubExpression.add(new Boolean(false));
                } else {
                    isCaptureGroup = false;
                }
                groupStack.push(new Boolean(isCaptureGroup));
                ++index;
                continue;
            }
            if (!inBrackets && regexsb.charAt(index) == ')') {
                if (groupStack.empty()) {
                    throw new PatternSyntaxException("Unbalanced parentheses", regexsb.toString(), index);
                }
                boolean isCaptureGroup = (Boolean)groupStack.pop();
                if (isCaptureGroup) {
                    int closedExpr = (Integer)openSubExpressions.pop();
                    validSubExpression.set(closedExpr, new Boolean(true));
                }
                ++index;
                continue;
            }
            if (!inBrackets && '[' == regexsb.charAt(index)) {
                bracketExprIndex = 0;
                inBrackets = true;
                ++index;
                continue;
            }
            if (inBrackets) {
                ++bracketExprIndex;
                if (regexsb.charAt(index) == ']') {
                    if (bracketExprIndex > 2) {
                        bracketExprIndex = -1;
                        inBrackets = false;
                    } else if (bracketExprIndex == 2 && regexsb.charAt(index - 1) != '^') {
                        bracketExprIndex = -1;
                        inBrackets = false;
                    }
                    ++index;
                    continue;
                }
            }
            if (bracketExprIndex == 1 && (this.flags & 0x40) != 0 && regexsb.charAt(index) == '^') {
                regexsb.insert(index + 1, "\\n");
                index += 3;
                continue;
            }
            if (!inBrackets && (this.flags & 0x80) == 128) {
                String replace = null;
                if ('^' == regexsb.charAt(index)) {
                    replace = this.offset == 0 ? "(?:^|(?<=\\n))" : "(?<=\\n)";
                }
                if ('$' == regexsb.charAt(index)) {
                    replace = "(?:$|(?=\\n))";
                }
                if (replace != null) {
                    regexsb.replace(index, index + 1, replace);
                    index += replace.length();
                    continue;
                }
            }
            if (this.offset > 0 && !inBrackets && regexsb.charAt(index) == '^' && (this.flags & 0x80) == 0) {
                String replace = "(?=_)(?!_)";
                regexsb.replace(index, index + 1, replace);
                index += replace.length();
                continue;
            }
            if ('[' == regexsb.charAt(index)) {
                char c2 = index + 1 < regexsb.length() ? (char)regexsb.charAt(index + 1) : (char)'?';
                if (c2 == ':' || c2 == '.' || c2 == '=') {
                    if (!inBrackets) {
                        throw new PatternSyntaxException(" [::] [..] [==] not allowed outside of a bracket expression", regexsb.toString(), index);
                    }
                    StringBuffer charClass = new StringBuffer("[");
                    charClass.append(c2);
                    int i = index + 2;
                    while (i < regexsb.length()) {
                        char c = regexsb.charAt(i);
                        charClass.append(c);
                        if (c == ']') break;
                        ++i;
                    }
                    String replacement = (String)bracketMap.get(charClass.toString());
                    if (replacement == null && (c2 == '.' || c2 == '=') && charClass.length() == 5) {
                        replacement = charClass.substring(2, 3);
                    }
                    if (replacement == null) throw new PatternSyntaxException(String.valueOf(charClass.toString()) + " not supported", regexsb.toString(), index);
                    if (c2 == ':' && (regexsb.charAt(index + 2) == '>' || regexsb.charAt(index + 2) == '<')) {
                        regexsb.replace(--index, index + 7, replacement);
                    } else {
                        regexsb.replace(index, index + charClass.length(), replacement);
                    }
                    index += replacement.length();
                    continue;
                }
                regexsb.insert(index, '\\');
                index += 2;
                continue;
            }
            if ('{' == regexsb.charAt(index)) {
                ++index;
                while (Regex.isCommentWhitespace(regexsb, index, inBrackets, this.flags)) {
                    regexsb.delete(index, index + 1);
                }
                if (index < regexsb.length() && Character.isDigit(regexsb.charAt(index))) continue;
                regexsb.insert(index - 1, "\\");
                ++index;
                continue;
            }
            if ('\\' == regexsb.charAt(index)) {
                String escapeReplacement = null;
                switch (regexsb.charAt(++index)) {
                    case '0': {
                        escapeReplacement = "00";
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int endOctal = Regex.endOfDigits(regexsb, index, false);
                        int octalLen = endOctal - index;
                        escapeReplacement = null;
                        int value = Integer.parseInt(regexsb.substring(index, endOctal), 8);
                        if (value > validSubExpression.size()) {
                            if (octalLen < 2) throw new PatternSyntaxException("invalid backreference number", regexsb.toString(), index);
                            escapeReplacement = "0" + regexsb.substring(index, index + 1);
                        } else {
                            boolean isValid = (Boolean)validSubExpression.get(value - 1);
                            if (!isValid) {
                                throw new PatternSyntaxException("invalid backreference number", regexsb.toString(), index);
                            }
                        }
                        if (escapeReplacement != null) break;
                        index += octalLen;
                        break;
                    }
                    case 'A': {
                        escapeReplacement = "G";
                        break;
                    }
                    case 'B': {
                        escapeReplacement = "\\";
                        break;
                    }
                    case 'b': {
                        escapeReplacement = "x08";
                        break;
                    }
                    case 'c': {
                        if (++index < regexsb.length()) {
                            regexsb.setCharAt(index, Character.toUpperCase(regexsb.charAt(index)));
                            ++index;
                            break;
                        }
                        escapeReplacement = null;
                        break;
                    }
                    case 'M': {
                        if (inBrackets) {
                            throw new PatternSyntaxException("\\M illegal within a bracket expression", regexsb.toString(), index);
                        }
                        escapeReplacement = (String)bracketMap.get("[:>:]");
                        regexsb.delete(--index, index + 1);
                        break;
                    }
                    case 'm': {
                        if (inBrackets) {
                            throw new PatternSyntaxException("\\m illegal within a bracket expression", regexsb.toString(), index);
                        }
                        escapeReplacement = (String)bracketMap.get("[:<:]");
                        regexsb.delete(--index, index + 1);
                        break;
                    }
                    case 'U': {
                        if (!"0000".equals(regexsb.substring(index + 1, index + 5))) throw new PatternSyntaxException("32-bit unicode value not supported", regexsb.toString(), index);
                        regexsb.setCharAt(index, 'u');
                        regexsb.delete(index + 1, index + 5);
                        index += 4;
                        escapeReplacement = null;
                        break;
                    }
                    case 'v': {
                        escapeReplacement = "x0b";
                        break;
                    }
                    case 'x': {
                        int endHex = Regex.endOfDigits(regexsb, ++index, true);
                        int hexLen = endHex - index;
                        if (hexLen == 0 || hexLen == 2) {
                            index += hexLen;
                        } else if (hexLen == 1) {
                            regexsb.insert(index, '0');
                            index += 2;
                        } else {
                            regexsb.delete(index, endHex - 2);
                            index += 2;
                        }
                        escapeReplacement = null;
                        break;
                    }
                    case 'Y': {
                        if (inBrackets) {
                            throw new PatternSyntaxException("\\Y illegal within a bracket expression", regexsb.toString(), index);
                        }
                        escapeReplacement = "B";
                        break;
                    }
                    case 'y': {
                        if (inBrackets) {
                            throw new PatternSyntaxException("\\y illegal within a bracket expression", regexsb.toString(), index);
                        }
                        escapeReplacement = "b";
                        break;
                    }
                    case 'Z': {
                        escapeReplacement = "z";
                        break;
                    }
                    case 'E': 
                    case 'G': 
                    case 'Q': 
                    case 'p': 
                    case 'z': {
                        throw new PatternSyntaxException("Illegal escape", regexsb.toString(), index);
                    }
                    default: {
                        escapeReplacement = null;
                        ++index;
                    }
                }
                if (escapeReplacement == null) continue;
                regexsb.replace(index, index + 1, escapeReplacement);
                index += escapeReplacement.length();
                continue;
            }
            ++index;
        }
        if ((this.flags & 4) != 4) return Pattern.compile(regexsb.toString(), this.getJavaFlags());
        regexsb.insert(0, "\\Q");
        regexsb.append("\\E");
        return Pattern.compile(regexsb.toString(), this.getJavaFlags());
    }
}

