/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.TclException;

class RoundFunction
extends MathFunction {
    RoundFunction() {
        this.argTypes = new int[1];
        this.argTypes[0] = 2;
    }

    @Override
    void apply(Interp interp, ExprValue[] values) throws TclException {
        ExprValue value = values[0];
        if (value.isDoubleType()) {
            double d = value.getDoubleValue();
            double i = d < 0.0 ? Math.ceil(d) : Math.floor(d);
            double f = d - i;
            if (d < 0.0) {
                if (f <= -0.5) {
                    i += -1.0;
                }
                Expression.checkIntegerRange(interp, i);
                value.setIntValue((long)i);
            } else {
                if (f >= 0.5) {
                    i += 1.0;
                }
                Expression.checkIntegerRange(interp, i);
                value.setIntValue((long)i);
            }
        }
    }
}

