/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.cmd.EncodingCmd;

public class Shell {
    public static boolean forceNonInteractive = false;

    public static void main(String[] args) {
        String fileName = null;
        String encoding = EncodingCmd.systemTclEncoding;
        Interp interp = new Interp();
        int i = 0;
        if (args.length > i && args[i].equals("-encoding") && args.length > ++i) {
            encoding = args[i++];
        }
        if (args.length > i && !args[i].startsWith("-")) {
            fileName = args[i++];
        }
        TclObject argv = TclList.newInstance();
        argv.preserve();
        try {
            try {
                int argc = 0;
                if (fileName == null) {
                    interp.setVar("argv0", "tcl.lang.Shell", 1);
                    interp.setVar("tcl_interactive", forceNonInteractive ? "0" : "1", 1);
                } else {
                    interp.setVar("argv0", fileName, 1);
                    interp.setVar("tcl_interactive", "0", 1);
                }
                while (i < args.length) {
                    TclList.append(interp, argv, TclString.newInstance(args[i]));
                    ++argc;
                    ++i;
                }
                interp.setVar("argv", argv, 1);
                interp.setVar("argc", Integer.toString(argc), 1);
            }
            catch (TclException e) {
                throw new TclRuntimeError("unexpected TclException: " + e);
            }
        }
        finally {
            argv.release();
        }
        if (fileName != null) {
            int exitCode = 0;
            try {
                String javaEncoding = EncodingCmd.getJavaName(encoding);
                if (javaEncoding == null) {
                    System.err.println("unknown encoding \"" + encoding + "\"");
                    exitCode = 2;
                } else {
                    interp.evalFile(fileName, javaEncoding);
                }
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    code = interp.updateReturnInfo();
                    if (code != 0) {
                        System.err.println("command returned bad code: " + code);
                        exitCode = 2;
                    }
                }
                if (code == 1) {
                    try {
                        TclObject errorInfo = interp.getVar("errorInfo", 1);
                        System.err.println(errorInfo.toString());
                    }
                    catch (TclException tclException) {
                        System.err.println(interp.getResult().toString());
                    }
                    exitCode = 1;
                }
                System.err.println("command returned bad code: " + code);
                exitCode = 2;
            }
            interp.dispose();
            System.exit(exitCode);
        }
        if (fileName == null) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            Notifier notifier = interp.getNotifier();
            try {
                Notifier.processTclEvents(notifier);
            }
            finally {
                interp.dispose();
            }
        }
    }
}

