/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.cmd.EncodingCmd;

public class TclByteArray
implements InternalRep {
    private int used;
    private byte[] bytes;

    private TclByteArray() {
        this.used = 0;
        this.bytes = new byte[0];
    }

    private TclByteArray(byte[] b) {
        this.used = b.length;
        this.bytes = new byte[this.used];
        System.arraycopy(b, 0, this.bytes, 0, this.used);
    }

    private TclByteArray(byte[] b, int position, int length) {
        this.used = length;
        this.bytes = new byte[this.used];
        System.arraycopy(b, position, this.bytes, 0, this.used);
    }

    private TclByteArray(char[] c) {
        this.used = c.length;
        this.bytes = new byte[this.used];
        int ix = 0;
        while (ix < this.used) {
            this.bytes[ix] = (byte)c[ix];
            ++ix;
        }
    }

    @Override
    public InternalRep duplicate() {
        return new TclByteArray(this.bytes, 0, this.used);
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        char[] c = new char[this.used];
        int ix = 0;
        while (ix < this.used) {
            c[ix] = (char)(this.bytes[ix] & 0xFF);
            ++ix;
        }
        return new String(c);
    }

    public static TclObject newInstance(byte[] b, int position, int length) {
        return new TclObject(new TclByteArray(b, position, length));
    }

    public static TclObject newInstance(byte[] b) {
        return new TclObject(new TclByteArray(b));
    }

    public static TclObject newInstance() {
        return new TclObject(new TclByteArray());
    }

    static void setByteArrayFromAny(Interp interp, TclObject tobj) {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclByteArray)) {
            char[] c = tobj.toString().toCharArray();
            tobj.setInternalRep(new TclByteArray(c));
        }
    }

    public static byte[] setLength(Interp interp, TclObject tobj, int length) {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclByteArray.setLength() called with shared object");
        }
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        if (length > tbyteArray.bytes.length) {
            byte[] newBytes = new byte[length];
            System.arraycopy(tbyteArray.bytes, 0, newBytes, 0, tbyteArray.used);
            tbyteArray.bytes = newBytes;
        }
        tobj.invalidateStringRep();
        tbyteArray.used = length;
        return tbyteArray.bytes;
    }

    public static final int getLength(Interp interp, TclObject tobj) {
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        return tbyteArray.used;
    }

    public static byte[] getBytes(Interp interp, TclObject tobj) {
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        return tbyteArray.bytes;
    }

    public static String decodeToString(Interp interp, TclObject tobj, String tclEncoding) {
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        if (tclEncoding == null || tclEncoding.equals("identity") || tclEncoding.equals("binary")) {
            return tobj.toString();
        }
        String javaEncoding = EncodingCmd.getJavaName(tclEncoding);
        CharsetDecoder csd = Charset.forName(javaEncoding).newDecoder();
        csd.onMalformedInput(CodingErrorAction.IGNORE);
        csd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer cb = null;
        try {
            cb = csd.decode(ByteBuffer.wrap(tbyteArray.bytes, 0, tbyteArray.used));
        }
        catch (CharacterCodingException characterCodingException) {}
        if (cb == null) {
            return "";
        }
        return cb.toString();
    }
}

