/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.PackageNameException;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

public class TclClassLoader
extends ClassLoader {
    private HashMap class_cache = new HashMap();
    private String[] classpath = null;
    private String[] loadpath = null;
    private String cached_tclclasspath = null;
    private String lastSearchedClassFile = null;
    private String lastSearchedJarFile = null;
    private ClassLoader parent;
    private Interp interp = null;

    public TclClassLoader(Interp interp, TclObject pathList, ClassLoader parent) {
        super(parent);
        if (parent == null) {
            throw new TclRuntimeError("parent ClassLoader can't be null");
        }
        this.parent = parent;
        this.interp = interp;
        this.init(interp, pathList);
    }

    private void init(Interp interp, TclObject pathList) {
        try {
            boolean searchTclClasspath = true;
            if (this.parent instanceof TclClassLoader) {
                if (pathList == null) {
                    throw new TclRuntimeError("TclClassLoader is a child of the interp class loader but it does not have a -classpath to search");
                }
                searchTclClasspath = false;
            }
            if (pathList != null) {
                TclObject[] elem = TclList.getElements(interp, pathList);
                this.classpath = new String[elem.length];
                int i = 0;
                while (i < elem.length) {
                    this.classpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                    ++i;
                }
            }
            if (searchTclClasspath) {
                this.checkTclClasspath();
            }
        }
        catch (TclException tclException) {}
    }

    public void dispose() {
        this.parent = null;
        this.interp = null;
        this.class_cache = null;
    }

    private void checkTclClasspath() {
        TclObject[] elems = null;
        try {
            TclObject tobj = this.interp.getVar("env", "TCL_CLASSPATH", 1);
            String current_tclclasspath = tobj.toString();
            if (current_tclclasspath.length() == 0) {
                this.cached_tclclasspath = "";
                this.loadpath = null;
                return;
            }
            if (this.cached_tclclasspath == null || !current_tclclasspath.equals(this.cached_tclclasspath)) {
                this.cached_tclclasspath = current_tclclasspath;
                elems = TclList.getElements(this.interp, tobj);
            }
        }
        catch (TclException tclException) {
            this.interp.resetResult();
            this.cached_tclclasspath = null;
            this.loadpath = null;
            return;
        }
        if (elems == null) {
            return;
        }
        this.loadpath = new String[elems.length];
        int i = 0;
        while (i < elems.length) {
            this.loadpath[i] = TclClassLoader.absolutePath(this.interp, elems[i].toString());
            ++i;
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException, PackageNameException {
        return this.loadClass(className, true);
    }

    protected Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException, PackageNameException, SecurityException {
        byte[] classData = null;
        Class<?> result = (Class<?>)this.class_cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(className, resolveIt, this.parent);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        if (!className.startsWith("tcl.lang.library.") && (className.startsWith("java.") || className.startsWith("tcl.lang."))) {
            throw new PackageNameException("Java loader failed to load the class and the TclClassLoader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.", className);
        }
        if (this.classpath != null) {
            classData = this.getClassFromPath(this.classpath, className);
        }
        if (classData == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                classData = this.getClassFromPath(this.loadpath, className);
            }
        }
        if (classData == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            result = this.defineClass(className, classData, 0, classData.length);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassFormatError();
        }
        catch (ClassFormatError err) {
            StringBuffer buf = new StringBuffer(50);
            buf.append(err.getMessage());
            buf.append(". ");
            if (this.lastSearchedClassFile != null) {
                buf.append(this.lastSearchedClassFile);
            } else {
                buf.append(className);
            }
            if (this.lastSearchedJarFile != null) {
                buf.append(" loaded from ");
                buf.append(this.lastSearchedJarFile);
            }
            buf.append(": class name does not match");
            buf.append(" the name defined in the classfile");
            throw new ClassFormatError(buf.toString());
        }
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        this.class_cache.put(className, result);
        return result;
    }

    @Override
    protected URL findResource(String resName) throws PackageNameException {
        URL result = null;
        if (resName.length() == 0 || resName.charAt(0) != '/') {
            return null;
        }
        if (!(resName = resName.substring(1)).startsWith("tcl/lang/library/") && (resName.startsWith("java/") || resName.startsWith("tcl/lang/"))) {
            throw new PackageNameException("Can't load resource \"" + resName + "\" with java or tcl prefix via TCL_CLASSPATH", resName);
        }
        if (this.classpath != null) {
            result = this.getURLFromPath(this.classpath, resName);
        }
        if (result == null) {
            this.checkTclClasspath();
            if (this.loadpath != null) {
                result = this.getURLFromPath(this.loadpath, resName);
            }
        }
        return result;
    }

    @Override
    public URL getResource(String resName) {
        URL res = null;
        if (res == null) {
            res = Interp.class.getResource(resName);
        }
        if (res == null) {
            res = this.parent.getResource(resName);
        }
        if (res == null) {
            res = this.findResource(resName);
        }
        return res;
    }

    public Class defineClass(String className, byte[] classData) {
        Class<?> result = null;
        try {
            result = this.defineClass(null, classData, 0, classData.length);
        }
        catch (ClassFormatError ex) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
        }
        catch (LinkageError ex) {
            System.err.println("TclClassLoader.defineClass():");
            System.err.println(String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage());
        }
        if (result != null) {
            if (className == null) {
                className = result.getName();
            }
            this.class_cache.put(className, result);
        }
        return result;
    }

    private byte[] getClassFromPath(String[] paths, String className) {
        int i = 0;
        byte[] classData = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (paths != null) {
            String curDir;
            className = String.valueOf(className.replace('.', '/')) + ".class";
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        classData = this.extractClassFromJar(curDir, className);
                        if (classData != null) {
                            return classData;
                        }
                    } else {
                        File file = new File(curDir, className);
                        if (file.exists()) {
                            FileInputStream fi = new FileInputStream(file);
                            classData = new byte[fi.available()];
                            int total = fi.read(classData);
                            while (total != classData.length) {
                                total += fi.read(classData, total, classData.length - total);
                            }
                            this.lastSearchedClassFile = file.toString();
                            return classData;
                        }
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    classData = this.getClassFromJar(curDir, className);
                    if (classData != null) {
                        return classData;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return null;
    }

    private byte[] getClassFromJar(String curDir, String className) throws IOException {
        byte[] result = null;
        File file = new File(curDir);
        if (!file.isDirectory()) {
            return null;
        }
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = file.list(jarFilter);
        if (jarFiles == null) {
            return null;
        }
        int i = 0;
        while (i < jarFiles.length) {
            result = this.extractClassFromJar(String.valueOf(curDir) + File.separatorChar + jarFiles[i], className);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    private byte[] extractClassFromJar(String jarName, String className) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(jarName));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (!className.equals(entry.getName())) continue;
                int size = this.getEntrySize(jarName, className);
                byte[] result = new byte[size];
                int total = zin.read(result);
                while (total != size) {
                    total += zin.read(result, total, size - total);
                }
                this.lastSearchedClassFile = className;
                this.lastSearchedJarFile = jarName;
                byte[] byArray = result;
                return byArray;
            }
            return null;
        }
    }

    private int getEntrySize(String jarName, String className) throws IOException {
        ZipFile zip = new ZipFile(jarName);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!className.equals(entry.getName())) continue;
            zip.close();
            return (int)entry.getSize();
        }
        return -1;
    }

    private static String absolutePath(Interp interp, String dirName) {
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            String newName = String.valueOf(interp.getWorkingDir().toString()) + System.getProperty("file.separator") + dirName;
            dir = new File(newName);
        }
        return dir.toString();
    }

    public void removeCache(String className) {
        this.class_cache.remove(className);
    }

    private URL getURLFromPath(String[] paths, String resName) {
        int i = 0;
        URL url = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (paths != null) {
            String curDir;
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        url = this.extractURLFromJar(curDir, resName);
                        if (url != null) {
                            return url;
                        }
                    } else {
                        File file = new File(curDir, resName);
                        if (file.exists()) {
                            url = file.toURL();
                            return url;
                        }
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    url = this.getURLFromJar(curDir, resName);
                    if (url != null) {
                        return url;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return null;
    }

    private URL getURLFromJar(String curDir, String resName) throws IOException {
        URL result = null;
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = new File(curDir).list(jarFilter);
        int i = 0;
        while (i < jarFiles.length) {
            result = this.extractURLFromJar(String.valueOf(curDir) + File.separatorChar + jarFiles[i], resName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    private URL extractURLFromJar(String jarName, String resName) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(jarName));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                URL jarURL;
                if (!resName.equals(entry.getName())) continue;
                File file = new File(jarName);
                URL fileURL = file.toURL();
                URL uRL = jarURL = new URL("jar:" + fileURL.toString() + "!/" + resName);
                return uRL;
            }
            return null;
        }
    }
}

