/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.LinkedHashMap;
import java.util.Map;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclDict
implements InternalRep {
    private final Map map;
    private final Map keymap;

    private TclDict() {
        this.map = new LinkedHashMap();
        this.keymap = new LinkedHashMap();
    }

    private TclDict(int size) {
        this.map = new LinkedHashMap(size);
        this.keymap = new LinkedHashMap(size);
    }

    @Override
    public void dispose() {
        for (Map.Entry entry : this.map.entrySet()) {
            TclObject key = (TclObject)entry.getKey();
            TclObject val = (TclObject)entry.getValue();
            key.release();
            val.release();
        }
    }

    @Override
    public InternalRep duplicate() {
        int size = this.map.size();
        TclDict newDict = new TclDict(size);
        for (Map.Entry entry : this.map.entrySet()) {
            TclObject key = (TclObject)entry.getKey();
            TclObject value = (TclObject)entry.getValue();
            key.preserve();
            value.preserve();
            newDict.map.put(key, value);
            newDict.keymap.put(key, key);
        }
        return newDict;
    }

    public String toString() {
        int size = this.map.size();
        if (size == 0) {
            return "";
        }
        int est = size * 8;
        StringBuffer sbuf = new StringBuffer(est > 64 ? est : 64);
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    Util.appendElement(null, sbuf, key.toString());
                } else {
                    Util.appendElement(null, sbuf, "");
                }
                if (val != null) {
                    Util.appendElement(null, sbuf, val.toString());
                    continue;
                }
                Util.appendElement(null, sbuf, "");
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        return sbuf.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclDict());
    }

    private static void setDictFromAny(Interp interp, TclObject tobj) throws TclException {
        TclDict tdict = new TclDict();
        TclDict.splitDict(interp, tdict.map, tdict.keymap, tobj.toString());
        tobj.setInternalRep(tdict);
    }

    private static final void splitDict(Interp interp, Map map, Map keymap, String s) throws TclException {
        int len = s.length();
        int i = 0;
        FindElemResult res = new FindElemResult();
        while (i < len) {
            TclObject key = null;
            TclObject val = null;
            if (!Util.findElement(interp, s, i, len, res)) break;
            key = TclString.newInstance(res.elem);
            i = res.elemEnd;
            if (!Util.findElement(interp, s, i, len, res)) {
                throw new TclException(interp, "missing value to go with key");
            }
            val = TclString.newInstance(res.elem);
            key.preserve();
            val.preserve();
            map.put(key, val);
            keymap.put(key, key);
            i = res.elemEnd;
        }
    }

    public static final TclObject get(Interp interp, TclObject dict, TclObject key) throws TclException {
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        TclDict ir = (TclDict)dict.getInternalRep();
        return (TclObject)ir.map.get(key);
    }

    public static final void put(Interp interp, TclObject dict, TclObject key, TclObject value) throws TclException {
        if (dict.isShared()) {
            throw new TclRuntimeError("TclDict.put() called with shared object");
        }
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        TclDict ir = (TclDict)dict.getInternalRep();
        TclObject oldValue = (TclObject)ir.map.remove(key);
        key.preserve();
        value.preserve();
        if (oldValue != null) {
            oldValue.release();
            TclObject oldKey = (TclObject)ir.keymap.remove(key);
            oldKey.release();
        }
        ir.map.put(key, value);
        ir.keymap.put(key, key);
        dict.invalidateStringRep();
    }

    public static final void remove(Interp interp, TclObject dict, TclObject key) throws TclException {
        if (dict.isShared()) {
            throw new TclRuntimeError("TclDict.remove() called with shared object");
        }
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        dict.invalidateStringRep();
        TclDict ir = (TclDict)dict.getInternalRep();
        TclObject val = (TclObject)ir.map.remove(key);
        if (val != null) {
            val.release();
            TclObject oldKey = (TclObject)ir.keymap.remove(key);
            oldKey.release();
        }
    }

    public static final int size(Interp interp, TclObject dict) throws TclException {
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        TclDict ir = (TclDict)dict.getInternalRep();
        return ir.map.size();
    }

    /*
     * Unable to fully structure code
     */
    public static final Object foreach(Interp interp, Object accum, TclObject dict, Visitor body) throws TclException {
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        dict.preserve();
        ir = (TclDict)dict.getInternalRep();
        for (Map.Entry<K, V> entry : ir.map.entrySet()) {
            key = (TclObject)entry.getKey();
            val = (TclObject)entry.getValue();
            key.preserve();
            val.preserve();
        }
        try {
            for (Map.Entry<K, V> entry : ir.map.entrySet()) {
                key = (TclObject)entry.getKey();
                val = (TclObject)entry.getValue();
                try {
                    accum = body.visit(interp, accum, key, val);
                }
                catch (TclException e) {
                    if (e.getCompletionCode() == 3) {
                    }
                    if (e.getCompletionCode() == 4) continue;
                    throw e;
                }
            }
        }
        finally {
            ** for (entry : ir.map.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            key = (TclObject)entry.getKey();
            val = (TclObject)entry.getValue();
            key.release();
            val.release();
            continue;
        }
lbl31:
        // 1 sources

        dict.release();
        return accum;
    }

    public static final void putKeyList(Interp interp, TclObject dict, TclObject[] keys, int start, int length, TclObject value) throws TclException {
        int end = start + length - 1;
        TclObject current = dict;
        if (dict.isShared()) {
            throw new TclRuntimeError("TclDict.putKeyList() called with shared object");
        }
        int i = start;
        while (i < end) {
            if (!(current.getInternalRep() instanceof TclDict)) {
                TclDict.setDictFromAny(interp, current);
            }
            TclDict ir = (TclDict)current.getInternalRep();
            current.invalidateStringRep();
            TclObject next = (TclObject)ir.map.get(keys[i]);
            if (next == null) {
                next = TclDict.newInstance();
                next.preserve();
                keys[i].preserve();
                ir.map.put(keys[i], next);
                ir.keymap.put(keys[i], keys[i]);
            } else if (next.isShared()) {
                next = next.duplicate();
                next.preserve();
                keys[i].preserve();
                ir.map.put(keys[i], next);
                ir.keymap.put(keys[i], keys[i]);
            }
            current = next;
            ++i;
        }
        if (!(current.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, current);
        }
        TclDict ir = (TclDict)current.getInternalRep();
        TclObject oldValue = (TclObject)ir.map.remove(keys[end]);
        if (oldValue != null) {
            oldValue.release();
            TclObject oldKey = (TclObject)ir.keymap.remove(keys[end]);
            oldKey.release();
        }
        keys[end].preserve();
        value.preserve();
        ir.map.put(keys[end], value);
        ir.keymap.put(keys[end], keys[end]);
        current.invalidateStringRep();
    }

    public static final void removeKeyList(Interp interp, TclObject dict, TclObject[] keys, int start, int length) throws TclException {
        int end = start + length - 1;
        TclObject current = dict;
        if (dict.isShared()) {
            throw new TclRuntimeError("TclDict.removeKeyList() called with shared object");
        }
        int i = start;
        while (i < end) {
            if (!(current.getInternalRep() instanceof TclDict)) {
                TclDict.setDictFromAny(interp, current);
            }
            TclDict ir = (TclDict)current.getInternalRep();
            current.invalidateStringRep();
            TclObject next = (TclObject)ir.map.get(keys[i]);
            if (next == null) {
                throw new TclException(interp, "key \"" + keys[i].toString() + "\" not known in dictionary");
            }
            if (next.isShared()) {
                next = next.duplicate();
                next.preserve();
                keys[i].preserve();
                ir.map.put(keys[i], next);
                ir.keymap.put(keys[i], keys[i]);
            }
            current = next;
            ++i;
        }
        if (!(current.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, current);
        }
        TclDict ir = (TclDict)current.getInternalRep();
        TclObject oldValue = (TclObject)ir.map.remove(keys[end]);
        if (oldValue != null) {
            oldValue.release();
            TclObject oldKey = (TclObject)ir.keymap.remove(keys[end]);
            oldKey.release();
        }
        current.invalidateStringRep();
    }

    public static final void appendToKey(Interp interp, TclObject dict, TclObject key, TclObject[] objv, int start, int end) throws TclException {
        if (dict.isShared()) {
            throw new TclRuntimeError("TclDict.append() called with shared object");
        }
        if (!(dict.getInternalRep() instanceof TclDict)) {
            TclDict.setDictFromAny(interp, dict);
        }
        TclDict ir = (TclDict)dict.getInternalRep();
        TclObject val = (TclObject)ir.map.get(key);
        if (val == null) {
            val = TclString.newInstance("");
            ir.keymap.put(key, key);
            key.preserve();
        } else if (val.isShared()) {
            val = val.duplicate();
        }
        int i = start;
        while (i < end) {
            TclString.append(val, objv[i].toString());
            ++i;
        }
        val.preserve();
        ir.map.put(key, val);
        dict.invalidateStringRep();
    }

    public static interface Visitor {
        public Object visit(Interp var1, Object var2, TclObject var3, TclObject var4) throws TclException;
    }
}

