/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEventScript;
import tcl.lang.channel.StdChannel;

public class TclIO {
    public static final int READ_ALL = 1;
    public static final int READ_LINE = 2;
    public static final int READ_N_BYTES = 3;
    public static final int SEEK_SET = 1;
    public static final int SEEK_CUR = 2;
    public static final int SEEK_END = 3;
    public static final int RDONLY = 1;
    public static final int WRONLY = 2;
    public static final int RDWR = 4;
    public static final int APPEND = 8;
    public static final int CREAT = 16;
    public static final int EXCL = 32;
    public static final int TRUNC = 64;
    public static final int BUFF_FULL = 0;
    public static final int BUFF_LINE = 1;
    public static final int BUFF_NONE = 2;
    public static final int TRANS_AUTO = 0;
    public static final int TRANS_BINARY = 1;
    public static final int TRANS_LF = 2;
    public static final int TRANS_CR = 3;
    public static final int TRANS_CRLF = 4;
    public static int TRANS_PLATFORM = Util.isWindows() ? 4 : (Util.isMac() ? 3 : 2);
    private static StdChannel stdinChan = null;
    private static StdChannel stdoutChan = null;
    private static StdChannel stderrChan = null;

    public static Channel getChannel(Interp interp, String chanName) {
        HashMap<String, Channel> chanTable = TclIO.getInterpChanTable(interp);
        if (interp.systemEncodingChangesStdoutStderr && ("stdout".equals(chanName) || "stderr".equals(chanName))) {
            interp.systemEncodingChangesStdoutStderr = false;
        }
        if (chanTable.containsKey(chanName)) {
            return chanTable.get(chanName);
        }
        String[] stringArray = new String[]{"stdin", "stdout", "stderr"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Channel std = chanTable.get(name);
            if (std != null && std.getChanName().equals(chanName)) {
                return std;
            }
            ++n2;
        }
        return null;
    }

    public static void getChannelNames(Interp interp, TclObject pattern) throws TclException {
        Iterator<String> it = TclIO.getInterpChanTable(interp).keySet().iterator();
        interp.systemEncodingChangesStdoutStderr = false;
        while (it.hasNext()) {
            String chanName = it.next();
            if (pattern == null) {
                interp.appendElement(chanName);
                continue;
            }
            if (!Util.stringMatch(chanName, pattern.toString())) continue;
            interp.appendElement(chanName);
        }
    }

    public static void registerChannel(Interp interp, Channel chan) {
        if (interp != null) {
            HashMap<String, Channel> chanTable = TclIO.getInterpChanTable(interp);
            String registerName = !chanTable.containsKey("stdin") ? "stdin" : (!chanTable.containsKey("stdout") ? "stdout" : (!chanTable.containsKey("stderr") ? "stderr" : chan.getChanName()));
            chanTable.put(registerName, chan);
            ++chan.refCount;
        }
    }

    public static void flushAllOpenChannels(Interp interp) {
        HashMap<String, Channel> chanTable = TclIO.getInterpChanTable(interp);
        for (Channel channel : chanTable.values()) {
            if (!channel.isWriteOnly() && !channel.isReadWrite()) continue;
            boolean blockingMode = channel.getBlocking();
            if (!blockingMode) {
                channel.setBlocking(true);
            }
            try {
                channel.flush(interp);
            }
            catch (Exception exception) {}
            if (blockingMode) continue;
            channel.setBlocking(false);
        }
    }

    public static void giveChannel(Interp master, Interp slave, String chanName, boolean removeFromMaster) throws TclException {
        HashMap<String, Channel> masterTable = TclIO.getInterpChanTable(master);
        HashMap<String, Channel> slaveTable = TclIO.getInterpChanTable(slave);
        slave.systemEncodingChangesStdoutStderr = false;
        Channel channel = masterTable.get(chanName);
        if (channel != null) {
            slaveTable.put(chanName, channel);
        } else {
            String[] stringArray = new String[]{"stdin", "stdout", "stderr"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                channel = masterTable.get(name);
                if (channel != null && channel.getChanName().equals(chanName)) {
                    slaveTable.put(name, channel);
                    break;
                }
                channel = null;
                ++n2;
            }
        }
        if (channel == null) {
            throw new TclException(master, "can not find channel named \"" + chanName + "\"");
        }
        ++channel.refCount;
        if (removeFromMaster) {
            TclIO.unregisterChannel(master, channel);
        }
    }

    public static void unregisterChannel(Interp interp, Channel chan) {
        HashMap<String, Channel> chanTable = TclIO.getInterpChanTable(interp);
        FileEventScript.dispose(interp, chan, 0);
        FileEventScript.dispose(interp, chan, 1);
        if (chanTable.containsKey(chan.getChanName())) {
            chanTable.remove(chan.getChanName());
        } else {
            String[] stringArray = new String[]{"stdin", "stdout", "stderr"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Channel std = chanTable.get(name);
                if (std != null && std.getChanName().equals(chan.getChanName())) {
                    chanTable.remove(name);
                    break;
                }
                ++n2;
            }
        }
        if (--chan.refCount <= 0) {
            try {
                chan.close();
            }
            catch (IOException e) {
                throw new TclRuntimeError("TclIO.unregisterChannel() Error: IOException when closing " + chan.getChanName() + ": " + e.getMessage());
            }
        }
    }

    static HashMap<String, Channel> getInterpChanTable(Interp interp) {
        if (interp.interpChanTable == null) {
            interp.interpChanTable = new HashMap();
            Channel chan = TclIO.getStdChannel(0);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(1);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(2);
            TclIO.registerChannel(interp, chan);
        }
        return interp.interpChanTable;
    }

    public static Channel getStdChannel(int type) {
        StdChannel chan = null;
        switch (type) {
            case 0: {
                if (stdinChan == null) {
                    stdinChan = new StdChannel(0);
                }
                chan = stdinChan;
                break;
            }
            case 1: {
                if (stdoutChan == null) {
                    stdoutChan = new StdChannel(1);
                }
                chan = stdoutChan;
                break;
            }
            case 2: {
                if (stderrChan == null) {
                    stderrChan = new StdChannel(2);
                }
                chan = stderrChan;
                break;
            }
            default: {
                throw new TclRuntimeError("Invalid type for StdChannel");
            }
        }
        return chan;
    }

    public static String getNextDescriptor(Interp interp, String prefix) {
        HashMap<String, Channel> htbl = TclIO.getInterpChanTable(interp);
        int i = prefix.equals("file") ? 3 : 0;
        while (htbl.get(String.valueOf(prefix) + i) != null) {
            ++i;
        }
        return String.valueOf(prefix) + i;
    }

    public static String getTranslationString(int translation) {
        switch (translation) {
            case 0: {
                return "auto";
            }
            case 3: {
                return "cr";
            }
            case 4: {
                return "crlf";
            }
            case 2: {
                return "lf";
            }
            case 1: {
                return "lf";
            }
        }
        throw new TclRuntimeError("bad translation id");
    }

    public static int getTranslationID(String translation) {
        if (translation.equals("auto")) {
            return 0;
        }
        if (translation.equals("cr")) {
            return 3;
        }
        if (translation.equals("crlf")) {
            return 4;
        }
        if (translation.equals("lf")) {
            return 2;
        }
        if (translation.equals("binary")) {
            return 2;
        }
        if (translation.equals("platform")) {
            return TRANS_PLATFORM;
        }
        return -1;
    }

    public static String getBufferingString(int buffering) {
        switch (buffering) {
            case 0: {
                return "full";
            }
            case 1: {
                return "line";
            }
            case 2: {
                return "none";
            }
        }
        throw new TclRuntimeError("bad buffering id");
    }

    public static int getBufferingID(String buffering) {
        if (buffering.equals("full")) {
            return 0;
        }
        if (buffering.equals("line")) {
            return 1;
        }
        if (buffering.equals("none")) {
            return 2;
        }
        return -1;
    }
}

