/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class TclInteger
implements InternalRep {
    static final TclInteger dummy = new TclInteger();
    private static final boolean validate = false;

    private TclInteger() {
    }

    @Override
    public InternalRep duplicate() {
        throw new TclRuntimeError("TclInteger.duplicate() should not be invoked");
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        throw new TclRuntimeError("TclInteger.toString() should not be invoked");
    }

    public static TclObject newInstance(long i) {
        return new TclObject(i);
    }

    private static void setIntegerFromAny(Interp interp, TclObject tobj) throws TclException {
        long ivalue = Util.getInt(interp, tobj.toString());
        tobj.setInternalRep(dummy);
        tobj.ivalue = ivalue;
    }

    @Deprecated
    public static int get(Interp interp, TclObject tobj) throws TclException {
        return (int)TclInteger.getLong(interp, tobj);
    }

    public static long getLong(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tobj);
        }
        return tobj.ivalue;
    }

    public static int getInt(Interp interp, TclObject tobj) throws TclException {
        long v = TclInteger.getLong(interp, tobj);
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            throw new TclException(interp, "integer value too large to represent");
        }
        return (int)v;
    }

    public static boolean isWithinLongRange(Interp interp, TclObject tobj) {
        if (!tobj.isIntType()) {
            try {
                TclInteger.setIntegerFromAny(null, tobj);
            }
            catch (TclException tclException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isWithinIntRange(Interp interp, TclObject tobj) {
        return TclInteger.isWithinLongRange(interp, tobj) && tobj.ivalue >= Integer.MIN_VALUE && tobj.ivalue <= Integer.MAX_VALUE;
    }

    public static void set(TclObject tobj, long i) {
        if (!tobj.isIntType()) {
            tobj.setInternalRep(dummy);
        }
        tobj.invalidateStringRep();
        tobj.ivalue = i;
    }

    public static void incr(Interp interp, TclObject tobj, long incrAmount) throws TclException {
        if (!tobj.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        tobj.ivalue += incrAmount;
    }

    static void exprSetInternalRep(TclObject tobj, long i) {
        tobj.setInternalRep(dummy);
        tobj.ivalue = i;
    }
}

