/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.WrappedCommand;

public class TclLambda
implements InternalRep {
    private final Procedure procedure;
    private final String namespaceName;

    private TclLambda(Procedure procedure, String ns) {
        this.procedure = procedure;
        this.namespaceName = ns;
    }

    @Override
    public void dispose() {
    }

    @Override
    public InternalRep duplicate() {
        return new TclLambda(this.procedure, this.namespaceName);
    }

    public static void apply(Interp interp, TclObject lambdaExpr, TclObject[] args) throws TclException {
        if (!(lambdaExpr.getInternalRep() instanceof TclLambda)) {
            TclLambda.setLambdaFromAny(interp, lambdaExpr);
        }
        TclLambda lambda = (TclLambda)lambdaExpr.getInternalRep();
        Procedure proc = lambda.procedure;
        Namespace ns = Namespace.findNamespace(interp, lambda.namespaceName, null, 513);
        if (ns == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        proc.wcmd.ns = ns;
        proc.cmdProc(interp, args);
    }

    private static void setLambdaFromAny(Interp interp, TclObject lambdaExpr) throws TclException {
        if (lambdaExpr.getInternalRep() instanceof TclLambda) {
            return;
        }
        TclLambda lambda = TclLambda.parseLambda(interp, lambdaExpr);
        lambdaExpr.setInternalRep(lambda);
    }

    private static TclLambda parseLambda(Interp interp, TclObject lambdaExpr) throws TclException {
        String ns;
        TclObject[] elems = TclList.getElements(interp, lambdaExpr);
        if (elems.length < 2 || elems.length > 3) {
            throw new TclException(interp, "can't interpret \"" + lambdaExpr.toString() + "\" as a lambda expression");
        }
        TclObject args = elems[0];
        TclObject body = elems[1];
        String string = ns = elems.length == 3 ? elems[2].toString() : "::";
        if (!ns.startsWith("::")) {
            ns = "::" + ns;
        }
        String name = lambdaExpr.toString();
        Procedure proc = null;
        try {
            proc = new Procedure(interp, null, name, args, body, interp.getScriptFile(), interp.getArgLineNumber(1));
        }
        catch (TclException tex) {
            interp.addErrorInfo("\n    (parsing lambda expression \"" + lambdaExpr.toString() + "\")");
            throw tex;
        }
        proc.wcmd = new WrappedCommand();
        proc.wcmd.cmd = proc;
        proc.wcmd.cmdEpoch = 1;
        proc.wcmd.deleted = false;
        proc.wcmd.hashKey = null;
        proc.wcmd.ns = null;
        TclLambda lambda = new TclLambda(proc, ns);
        return lambda;
    }

    public String toString() {
        throw new TclRuntimeError("string rep of lambda expression is inexplicably null!");
    }
}

