/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
implements InternalRep {
    private ArrayList<TclObject> alist;

    private TclList() {
        this.alist = new ArrayList();
    }

    private TclList(int size) {
        this.alist = new ArrayList(size);
    }

    @Override
    public void dispose() {
        int size = this.alist.size();
        int i = 0;
        while (i < size) {
            this.alist.get(i).release();
            ++i;
        }
        this.alist.clear();
    }

    @Override
    public InternalRep duplicate() {
        int size = this.alist.size();
        TclList newList = new TclList(size);
        int i = 0;
        while (i < size) {
            TclObject tobj = this.alist.get(i);
            tobj.preserve();
            newList.alist.add(tobj);
            ++i;
        }
        return newList;
    }

    public String toString() {
        int size = this.alist.size();
        if (size == 0) {
            return "";
        }
        int est = size * 4;
        StringBuffer sbuf = new StringBuffer(est > 64 ? est : 64);
        try {
            int i = 0;
            while (i < size) {
                TclObject elm = this.alist.get(i);
                if (elm != null) {
                    Util.appendElement(null, sbuf, elm.toString());
                } else {
                    Util.appendElement(null, sbuf, "");
                }
                ++i;
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        return sbuf.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    public static TclObject copy(Interp interp, TclObject list) {
        if (!list.isListType()) {
            try {
                TclList.setListFromAny(interp, list);
            }
            catch (TclException tclException) {
                return null;
            }
        }
        TclObject copy = TclList.newInstance();
        copy.invalidateStringRep();
        copy = list.duplicate();
        return copy;
    }

    private static void setListFromAny(Interp interp, TclObject tobj) throws TclException {
        TclList tlist = new TclList();
        TclList.splitList(interp, tlist.alist, tobj.toString());
        tobj.setInternalRep(tlist);
    }

    private static final void splitList(Interp interp, ArrayList<TclObject> alist, String s) throws TclException {
        int len = s.length();
        int i = 0;
        FindElemResult res = new FindElemResult();
        while (i < len) {
            if (!Util.findElement(interp, s, i, len, res)) break;
            TclObject tobj = TclString.newInstance(res.elem);
            tobj.preserve();
            alist.add(tobj);
            i = res.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tobj, TclObject elemObj) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        elemObj.preserve();
        ((TclList)tobj.getInternalRep()).alist.add(elemObj);
    }

    public static final void append(Interp interp, TclObject tobj, TclObject[] objv, int startIdx, int endIdx) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        ArrayList<TclObject> alist = ((TclList)tobj.getInternalRep()).alist;
        int i = startIdx;
        while (i < endIdx) {
            TclObject elemObj = objv[i];
            elemObj.preserve();
            alist.add(elemObj);
            ++i;
        }
    }

    public static final int getLength(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        return tlist.alist.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.alist.size();
        TclObject[] objArray = new TclObject[size];
        int i = 0;
        while (i < size) {
            objArray[i] = tlist.alist.get(i);
            ++i;
        }
        return objArray;
    }

    public static ArrayList getElementsList(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        return tlist.alist;
    }

    public static void setElement(Interp interp, TclObject list, int index, TclObject value) throws TclException {
        if (list.isShared()) {
            throw new TclRuntimeError("TclListObjSetElement called with shared object");
        }
        if (!list.isListType()) {
            if (list.toString().length() == 0) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(0);
            }
            TclList.setListFromAny(interp, list);
        }
        TclList listRep = (TclList)list.getInternalRep();
        TclObject[] elems = listRep.alist.toArray(new TclObject[listRep.alist.size()]);
        int elemCount = listRep.alist.size();
        if (index < 0 || index >= elemCount) {
            if (interp != null) {
                interp.setResult(TclString.newInstance("list index out of range"));
            }
            throw new TclRuntimeError("list index out of range");
        }
        if (list.getRefCount() > 1) {
            TclList oldListRep = listRep;
            TclObject[] oldElems = elems;
            listRep = new TclList(elemCount);
            if (listRep == null) {
                throw new TclRuntimeError("Not enough memory to allocate list");
            }
            elems = (TclObject[])listRep.alist.toArray();
            int i = 0;
            while (i < elemCount) {
                elems[i] = oldElems[i];
                elems[i].preserve();
                ++i;
            }
            listRep.duplicate();
            list.setInternalRep(listRep);
            oldListRep.dispose();
        }
        --elems[index].refCount;
        elems[index] = value;
        TclList.replace(interp, list, 0, TclList.getLength(interp, list), elems, 0, elems.length - 1);
    }

    public static void lsetElement(Interp interp, TclObject list, int index, TclObject value) throws TclException {
        if (list.isShared()) {
            throw new TclRuntimeError("TclListObjSetElement called with shared object");
        }
        if (!list.isListType()) {
            if (list.toString().length() == 0) {
                interp.setResult(TclString.newInstance("list index out of range"));
                throw new TclException(0);
            }
            TclList.setListFromAny(interp, list);
        }
        TclList listRep = (TclList)list.getInternalRep();
        ArrayList<TclObject> elemList = listRep.alist;
        int elemCount = elemList.size();
        if (index < 0 || index >= elemCount) {
            if (interp != null) {
                interp.setResult(TclString.newInstance("list index out of range"));
            }
            throw new TclRuntimeError("list index out of range");
        }
        if (list.getRefCount() > 1) {
            TclList oldListRep = listRep;
            listRep = new TclList(elemCount);
            if (listRep == null) {
                throw new TclRuntimeError("Not enough memory to allocate list");
            }
            listRep.duplicate();
            list.setInternalRep(listRep);
            oldListRep.dispose();
            elemList = listRep.alist;
        }
        --elemList.get((int)index).refCount;
        elemList.set(index, value);
        value.preserve();
    }

    public static final TclObject index(Interp interp, TclObject tobj, int index) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        if (index < 0 || index >= tlist.alist.size()) {
            return null;
        }
        return tlist.alist.get(index);
    }

    public static final void insert(Interp interp, TclObject tobj, int index, TclObject[] elements, int from, int to) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.insert() called with shared object");
        }
        TclList.replace(interp, tobj, index, 0, elements, from, to);
    }

    public static final void replace(Interp interp, TclObject tobj, int index, int count, TclObject[] elements, int from, int to) throws TclException {
        int i;
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.replace() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.alist.size();
        if (index >= size) {
            index = size;
        } else {
            if (index < 0) {
                index = 0;
            }
            if (count > size - index) {
                count = size - index;
            }
            i = 0;
            while (i < count) {
                tlist.alist.get(index);
                tlist.alist.remove(index);
                ++i;
            }
        }
        i = from;
        while (i <= to) {
            elements[i].preserve();
            tlist.alist.add(index++, elements[i]);
            ++i;
        }
    }

    public static void sort(Interp interp, TclObject tobj, int sortMode, int sortIndex, boolean sortIncreasing, boolean unique, String command) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        TclObject[] objArray = TclList.getElements(interp, tobj);
        tlist.alist.clear();
        QSort s = new QSort();
        s.sort(interp, objArray, sortMode, sortIndex, sortIncreasing, command);
        int i = 0;
        while (i < objArray.length) {
            TclObject o2;
            TclObject o1;
            if (!unique || i >= objArray.length - 1 || s.compare(o1 = objArray[i], o2 = objArray[i + 1]) != 0) {
                tlist.alist.add(objArray[i]);
                objArray[i] = null;
            }
            ++i;
        }
    }
}

