/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.InternalRep;
import tcl.lang.TclDouble;
import tcl.lang.TclInteger;
import tcl.lang.TclObjectBase;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;

public final class TclObject
extends TclObjectBase {
    static final boolean saveObjRecords = false;
    static Hashtable objRecordMap = TclObjectBase.objRecordMap;
    public TclToken token;
    public String file;
    public int offset = -1;
    public TclParse parse;

    public TclObject(InternalRep rep) {
        super(rep);
    }

    protected TclObject(TclString rep, String s) {
        super(rep, s);
    }

    protected TclObject(long ivalue) {
        super(ivalue);
    }

    public final void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("TclObject has been deallocated");
        }
        ++this.refCount;
    }

    public final void release() {
        if (--this.refCount <= 0) {
            this.disposeObject();
        }
    }

    public static String getObjRecords() {
        return TclObjectBase.getObjRecords();
    }

    final void setRecycledIntValue(long i) {
        if (this.internalRep != TclInteger.dummy) {
            this.setInternalRep(TclInteger.dummy);
        }
        this.ivalue = i;
        this.stringRep = null;
    }

    final void setRecycledDoubleValue(double d) {
        if (!this.isDoubleType()) {
            TclDouble.setRecycledInternalRep(this);
        }
        ((TclDouble)this.internalRep).value = d;
        this.stringRep = null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof TclObject && ((TclObject)o).toString().equals(this.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setToken(TclToken saveToken) {
        this.token = saveToken;
    }

    public void fixCommandStart() {
        if (this.parse == null || this.token == null) {
            return;
        }
        this.parse.fixedCommandStart = this.token.script_index;
    }
}

