/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ParseExpr;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.UTF8CharPointer;
import tcl.lang.Util;

public class TclParser
implements Command {
    private static final String[] options = new String[]{"command", "expr", "varname", "list", "getrange", "getstring", "charindex", "charlength", "countnewline"};
    private static final int PARSE_COMMAND = 0;
    private static final int PARSE_EXPR = 1;
    private static final int PARSE_VARNAME = 2;
    private static final int PARSE_LIST = 3;
    private static final int PARSE_GET_RANGE = 4;
    private static final int PARSE_GET_STR = 5;
    private static final int PARSE_CHAR_INDEX = 6;
    private static final int PARSE_CHAR_LEN = 7;
    private static final int PARSE_COUNT_NWLNE = 8;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        UTF8CharPointer script;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "option arg ?arg ...?");
        }
        int option = TclIndex.get(interp, objv[1], options, "option", 0);
        TclObject tobj = objv[2];
        InternalRep irep = tobj.getInternalRep();
        if (irep instanceof UTF8CharPointer) {
            script = (UTF8CharPointer)irep;
        } else {
            script = new UTF8CharPointer(tobj.toString());
            tobj.setInternalRep(script);
        }
        if (script == null) {
            System.out.println(script);
        }
        int scriptLength = script.getByteLength();
        switch (option) {
            case 4: {
                int length;
                int index;
                if (objv.length == 3) {
                    index = 0;
                    length = scriptLength;
                } else if (objv.length == 5) {
                    index = TclInteger.getInt(interp, objv[3]);
                    length = TclInteger.getInt(interp, objv[4]);
                    if (index < 0) {
                        index = 0;
                    } else if (index >= scriptLength) {
                        index = scriptLength - 1;
                    }
                    if (length < 0) {
                        length = 0;
                    } else if (length > scriptLength - index) {
                        length = scriptLength - index;
                    }
                } else {
                    throw new TclNumArgsException(interp, 2, objv, "string ?index length?");
                }
                interp.setResult(TclParser.ParseMakeRange(script, index, length));
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "string range");
                }
                ParseGetIndexAndLengthResult result = new ParseGetIndexAndLengthResult();
                TclParser.ParseGetIndexAndLength(interp, objv[3], scriptLength, result);
                int index = result.indexPtr;
                int length = result.lengthPtr;
                switch (option) {
                    case 0: {
                        TclParser.ParseCommand(interp, script, index, length);
                        return;
                    }
                    case 1: {
                        TclParser.ParseExpr(interp, script, index, length);
                        return;
                    }
                    case 2: {
                        TclParser.ParseVarName(interp, script, index, length);
                        return;
                    }
                    case 3: {
                        TclParser.ParseList(interp, script, index, length);
                        return;
                    }
                    case 5: {
                        TclParser.ParseGetString(interp, script, index, length);
                        return;
                    }
                    case 6: {
                        TclParser.ParseCharIndex(interp, script, index, length);
                        return;
                    }
                    case 7: {
                        TclParser.ParseCharLength(interp, script, index, length);
                        return;
                    }
                }
                break;
            }
            case 8: {
                TclObject range2;
                if (objv.length == 5) {
                    range2 = objv[4];
                } else if (objv.length == 4) {
                    range2 = null;
                } else {
                    throw new TclNumArgsException(interp, 2, objv, "string range ?range?");
                }
                TclParser.ParseCountNewline(interp, script, scriptLength, objv[3], range2);
                return;
            }
        }
        throw new TclException(interp, "unmatched option");
    }

    static void ParseCommand(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        int charIndex = script.getCharIndex(index);
        int charLength = script.getCharRange(index, length);
        TclParse parse = Parser.parseCommand(interp, script.array, charIndex, charLength, null, -1, false);
        if (parse.result != 0) {
            TclParser.ParseSetErrorCode(interp, script, parse);
        }
        TclObject resultPtr = TclList.newInstance();
        if (parse.commentStart != -1) {
            TclList.append(interp, resultPtr, TclParser.ParseMakeByteRange(script, parse.commentStart, parse.commentSize));
        } else {
            TclList.append(interp, resultPtr, TclParser.ParseMakeRange(script, script.index, 0));
        }
        TclList.append(interp, resultPtr, TclParser.ParseMakeByteRange(script, parse.commandStart, parse.commandSize));
        int endCharIndex = parse.commandStart + parse.commandSize;
        TclList.append(interp, resultPtr, TclParser.ParseMakeByteRange(script, endCharIndex, charLength - (endCharIndex - charIndex)));
        TclObject listPtr = TclList.newInstance();
        ParseMakeTokenListResult result = new ParseMakeTokenListResult();
        int i = 0;
        while (i < parse.numTokens) {
            i = TclParser.ParseMakeTokenList(script, parse, i, result);
            TclObject tokenPtr = result.newList;
            TclList.append(null, listPtr, tokenPtr);
        }
        TclList.append(interp, resultPtr, listPtr);
        interp.setResult(resultPtr);
    }

    static void ParseExpr(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        int charIndex = script.getCharIndex(index);
        int charLength = script.getCharRange(index, length);
        TclParse parse = ParseExpr.parseExpr(interp, script.array, charIndex, charLength);
        if (parse.result != 0) {
            TclParser.ParseSetErrorCode(interp, script, parse);
        }
        ParseMakeTokenListResult lresult = new ParseMakeTokenListResult();
        TclParser.ParseMakeTokenList(script, parse, 0, lresult);
        interp.setResult(lresult.newList);
    }

    static void ParseList(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        FindElemResult fer = new FindElemResult();
        int charIndex = script.getCharIndex(index);
        int charListOffset = charIndex - script.index;
        TclObject resultPtr = TclList.newInstance();
        String list = script.getByteRangeAsString(index, length);
        int charLength = list.length();
        int listIndex = 0;
        while (true) {
            boolean found;
            try {
                found = Util.findElement(interp, list, listIndex, charLength, fer);
            }
            catch (TclException te) {
                TclObject errorCode = TclList.newInstance();
                TclList.append(interp, errorCode, TclString.newInstance("PARSE"));
                TclList.append(interp, errorCode, TclString.newInstance("list"));
                int byteRange = script.getByteRange(script.index, charListOffset + listIndex);
                TclList.append(interp, errorCode, TclInteger.newInstance(byteRange));
                TclList.append(interp, errorCode, interp.getResult());
                interp.setErrorCode(errorCode);
                throw te;
            }
            if (!found) break;
            listIndex = fer.elemEnd;
            int elementIndex = fer.elemStart;
            int size = fer.size;
            int c = elementIndex > 0 ? (int)list.charAt(elementIndex - 1) : 0;
            if (c == 123 || c == 34) {
                --elementIndex;
                size += 2;
            }
            TclList.append(interp, resultPtr, TclParser.ParseMakeByteRange(script, charListOffset + elementIndex, size));
        }
        interp.setResult(resultPtr);
    }

    static void ParseVarName(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        int charIndex = script.getCharIndex(index);
        int charLength = script.getCharRange(index, length);
        TclParse parse = Parser.parseVarName(interp, script.array, charIndex, charLength, null, false);
        if (parse.result != 0) {
            TclParser.ParseSetErrorCode(interp, script, parse);
        }
        ParseMakeTokenListResult lresult = new ParseMakeTokenListResult();
        TclParser.ParseMakeTokenList(script, parse, 0, lresult);
        interp.setResult(lresult.newList);
    }

    static void ParseSetErrorCode(Interp interp, UTF8CharPointer script, TclParse parse) throws TclException {
        String type = switch (parse.errorType) {
            case 1 -> "quoteExtra";
            case 2 -> "braceExtra";
            case 3 -> "missingBrace";
            case 4 -> "missingBracket";
            case 5 -> "missingParen";
            case 6 -> "missingQuote";
            case 7 -> "missingVarBrace";
            case 8 -> "syntax";
            case 9 -> "badNumber";
            default -> throw new TclException(interp, "unexpected error type from Tcl_ParseCommand");
        };
        TclObject tlist = TclList.newInstance();
        TclList.append(interp, tlist, TclString.newInstance("PARSE"));
        TclList.append(interp, tlist, TclString.newInstance(type));
        if (parse.termIndex > 0) {
            int byteRange = script.getByteRange(script.index, parse.termIndex);
            TclList.append(interp, tlist, TclInteger.newInstance(byteRange));
        } else {
            TclList.append(interp, tlist, TclInteger.newInstance(0L));
        }
        TclList.append(interp, tlist, interp.getResult());
        interp.setErrorCode(tlist);
        throw new TclException(interp, interp.getResult().toString());
    }

    static int ParseMakeTokenList(UTF8CharPointer script, TclParse parse, int index, ParseMakeTokenListResult result) throws TclException {
        TclToken token = parse.tokenList[index];
        String type = switch (token.type) {
            case 1 -> "word";
            case 2 -> "simple";
            case 4 -> "text";
            case 8 -> "backslash";
            case 16 -> "command";
            case 32 -> "variable";
            case 64 -> "subexpr";
            case 128 -> "operator";
            default -> "unknown";
        };
        TclObject resultList = TclList.newInstance();
        TclList.append(null, resultList, TclString.newInstance(type));
        TclList.append(null, resultList, TclParser.ParseMakeByteRange(script, token.script_index, token.size));
        TclObject resultIndexList = TclList.newInstance();
        TclList.append(null, resultList, resultIndexList);
        int start = index++;
        ParseMakeTokenListResult lresult = new ParseMakeTokenListResult();
        while (index <= start + token.numComponents) {
            index = TclParser.ParseMakeTokenList(script, parse, index, lresult);
            TclList.append(null, resultIndexList, lresult.newList);
        }
        result.newList = resultList;
        return index;
    }

    static TclObject ParseMakeRange(UTF8CharPointer script, int start, int length) throws TclException {
        int scriptByteIndex = script.getByteIndex(script.index);
        TclObject tlist = TclList.newInstance();
        TclList.append(null, tlist, TclInteger.newInstance(start - scriptByteIndex));
        TclList.append(null, tlist, TclInteger.newInstance(length));
        return tlist;
    }

    static TclObject ParseMakeByteRange(UTF8CharPointer script, int start, int length) throws TclException {
        if (start < 0) {
            throw new TclRuntimeError("char index can't be < 0, was " + start);
        }
        if (length < 0) {
            throw new TclRuntimeError("char length can't be < 0, was " + length);
        }
        int byteStart = script.getByteIndex(start);
        int byteLength = script.getByteRange(start, length);
        return TclParser.ParseMakeRange(script, byteStart, byteLength);
    }

    static void ParseGetString(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        String str = script.getByteRangeAsString(index, length);
        interp.setResult(str);
    }

    static void ParseCharIndex(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        int charIndex = script.getCharIndex(index);
        interp.setResult(charIndex - script.index);
    }

    static void ParseCharLength(Interp interp, UTF8CharPointer script, int index, int length) throws TclException {
        int charLength = script.getCharRange(index, length);
        interp.setResult(charLength);
    }

    static void ParseCountNewline(Interp interp, UTF8CharPointer script, int scriptLength, TclObject rangePtr1, TclObject rangePtr2) throws TclException {
        int length;
        int offset;
        int listLen2;
        int index2 = 0;
        int listLen1 = TclList.getLength(interp, rangePtr1);
        ParseGetIndexAndLengthResult result = new ParseGetIndexAndLengthResult();
        TclParser.ParseGetIndexAndLength(interp, rangePtr1, scriptLength, result);
        int index1 = result.indexPtr;
        int length1 = result.lengthPtr;
        if (rangePtr2 != null) {
            listLen2 = TclList.getLength(interp, rangePtr2);
            TclParser.ParseGetIndexAndLength(interp, rangePtr2, scriptLength, result);
            index2 = result.indexPtr;
            int cfr_ignored_0 = result.lengthPtr;
        } else {
            listLen2 = 0;
        }
        if (listLen1 == 0 && listLen2 == 2) {
            offset = 0;
            length = index2;
        } else if (listLen1 == 2 && listLen2 == 2) {
            offset = index1;
            length = index2 - offset;
        } else {
            offset = index1;
            length = length1;
        }
        int subStrIndex = offset;
        int cfr_ignored_1 = subStrIndex + length;
        int numNewline = 0;
        String range = script.getByteRangeAsString(subStrIndex, length);
        int range_length = range.length();
        int i = 0;
        while (i < range_length) {
            if (range.charAt(i) == '\n') {
                ++numNewline;
            }
            ++i;
        }
        interp.setResult(numNewline);
    }

    static void ParseGetIndexAndLength(Interp interp, TclObject rangePtr, int scriptLen, ParseGetIndexAndLengthResult result) throws TclException {
        int listLen = TclList.getLength(interp, rangePtr);
        if (listLen != 0 && listLen != 2) {
            throw new TclException(interp, "invalid range input: incorrect list size");
        }
        if (listLen == 0 && scriptLen < 0) {
            throw new TclException(interp, "empty range: no index or length values");
        }
        if (listLen == 0) {
            result.indexPtr = 0;
            result.lengthPtr = scriptLen;
        } else {
            TclObject itemPtr = TclList.index(interp, rangePtr, 0);
            result.indexPtr = TclInteger.getInt(interp, itemPtr);
            itemPtr = TclList.index(interp, rangePtr, 1);
            String bytes = itemPtr.toString();
            bytes.length();
            result.lengthPtr = bytes.equals("end") ? scriptLen : TclInteger.getInt(interp, itemPtr);
            if (scriptLen >= 0) {
                if (result.indexPtr < 0) {
                    result.indexPtr = 0;
                }
                if (result.lengthPtr < 0) {
                    result.lengthPtr = 0;
                }
                if (result.indexPtr >= scriptLen) {
                    result.indexPtr = scriptLen;
                }
                if (result.indexPtr + result.lengthPtr >= scriptLen) {
                    result.lengthPtr = scriptLen - result.indexPtr;
                }
            }
        }
    }

    static class ParseGetIndexAndLengthResult {
        int indexPtr;
        int lengthPtr;

        ParseGetIndexAndLengthResult() {
        }
    }

    static class ParseMakeTokenListResult {
        TclObject newList;

        ParseMakeTokenListResult() {
        }
    }
}

