/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.TclObject;

public class TclString
implements InternalRep {
    private static TclString dummy = new TclString();
    StringBuffer sbuf;

    private TclString() {
        this.sbuf = null;
    }

    private TclString(StringBuffer sb) {
        this.sbuf = sb;
    }

    @Override
    public InternalRep duplicate() {
        return dummy;
    }

    public StringBuffer getSbuf() {
        return this.sbuf;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        if (this.sbuf == null) {
            return "";
        }
        return this.sbuf.toString();
    }

    public static TclObject newInstance(String str) {
        return new TclObject(dummy, str);
    }

    public static TclObject newInstance(StringBuffer sb) {
        return new TclObject(new TclString(sb));
    }

    public static final TclObject newInstance(Object o) {
        return TclString.newInstance(o.toString());
    }

    public static final TclObject newInstance(char c) {
        char[] charArray = new char[]{c};
        return TclString.newInstance(new String(charArray));
    }

    private static void setStringFromAny(TclObject tobj) {
        tobj.toString();
        tobj.setInternalRep(dummy);
    }

    public static final void append(TclObject tobj, String string) {
        TclString tstr;
        if (!tobj.isStringType()) {
            TclString.setStringFromAny(tobj);
        }
        if ((tstr = (TclString)tobj.getInternalRep()) == dummy) {
            tstr = new TclString();
            tobj.setInternalRep(tstr);
        }
        if (tstr.sbuf == null) {
            tstr.sbuf = new StringBuffer(tobj.toString());
        }
        tobj.invalidateStringRep();
        tstr.sbuf.append(string);
    }

    public static final void append(TclObject tobj, char[] charArr, int offset, int length) {
        TclString tstr;
        if (!tobj.isStringType()) {
            TclString.setStringFromAny(tobj);
        }
        if ((tstr = (TclString)tobj.getInternalRep()) == dummy) {
            tstr = new TclString();
            tobj.setInternalRep(tstr);
        }
        if (tstr.sbuf == null) {
            tstr.sbuf = new StringBuffer(tobj.toString());
        }
        tobj.invalidateStringRep();
        tstr.sbuf.append(charArr, offset, length);
    }

    public static final void append(TclObject tobj, TclObject tobj2) {
        TclString.append(tobj, tobj2.toString());
    }

    public static final void append(TclObject tobj, TclObject[] objv, int startIdx, int endIdx) {
        TclString tstr;
        if (!tobj.isStringType()) {
            TclString.setStringFromAny(tobj);
        }
        if ((tstr = (TclString)tobj.getInternalRep()) == dummy) {
            tstr = new TclString();
            tobj.setInternalRep(tstr);
        }
        if (tstr.sbuf == null) {
            tstr.sbuf = new StringBuffer(tobj.toString());
        }
        StringBuffer sb = tstr.sbuf;
        int currentLen = tstr.sbuf.length();
        tobj.invalidateStringRep();
        int i = 0;
        while (i < endIdx) {
            currentLen += objv[i].toString().length();
            ++i;
        }
        currentLen = currentLen > 10240 ? (currentLen += currentLen / 10) : (currentLen += currentLen / 4);
        sb.ensureCapacity(currentLen);
        i = 0;
        while (i < endIdx) {
            sb.append(objv[i].toString());
            ++i;
        }
    }

    public static void empty(TclObject tobj) {
        TclString tstr;
        if (!tobj.isStringType()) {
            TclString.setStringFromAny(tobj);
        }
        if ((tstr = (TclString)tobj.getInternalRep()) == dummy) {
            tstr = new TclString();
            tobj.setInternalRep(tstr);
        }
        if (tstr.sbuf == null) {
            tstr.sbuf = new StringBuffer();
        } else {
            tstr.sbuf.setLength(0);
        }
        tobj.invalidateStringRep();
    }
}

