/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

public class TclToken {
    public char[] script_array;
    public int script_index;
    int size;
    int type;
    int numComponents;
    int line;

    public TclToken(TclToken other) {
        if (other == null) {
            return;
        }
        this.script_array = other.script_array;
        this.script_index = other.script_index;
        this.size = other.size;
        this.type = other.type;
        this.numComponents = other.numComponents;
        this.line = 0;
        int i = 0;
        while (i < this.script_index) {
            if (this.script_array[i] == '\n') {
                ++this.line;
            }
            ++i;
        }
    }

    TclToken() {
        this.script_array = null;
        this.script_index = -1;
    }

    String getTokenString() {
        return new String(this.script_array, this.script_index, this.size);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        switch (this.type) {
            case 1: {
                sbuf.append("\n  Token Type: TCL_TOKEN_WORD");
                break;
            }
            case 2: {
                sbuf.append("\n  Token Type: TCL_TOKEN_SIMPLE_WORD");
                break;
            }
            case 4: {
                sbuf.append("\n  Token Type: TCL_TOKEN_TEXT");
                break;
            }
            case 8: {
                sbuf.append("\n  Token Type: TCL_TOKEN_BS");
                break;
            }
            case 16: {
                sbuf.append("\n  Token Type: TCL_TOKEN_COMMAND");
                break;
            }
            case 32: {
                sbuf.append("\n  Token Type: TCL_TOKEN_VARIABLE");
                break;
            }
            case 64: {
                sbuf.append("\n  Token Type: TCL_TOKEN_SUB_EXPR");
                break;
            }
            case 128: {
                sbuf.append("\n  Token Type: TCL_TOKEN_OPERATOR");
            }
        }
        String ts = this.getTokenString();
        sbuf.append("\n  String:      " + ts);
        sbuf.append("\n  String Size: " + ts.length());
        sbuf.append("\n  ScriptIndex: " + this.script_index);
        sbuf.append("\n  NumComponents: " + this.numComponents);
        sbuf.append("\n  Token Size: " + this.size);
        return sbuf.toString();
    }
}

