/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class TimerHandler {
    Notifier notifier;
    long atTime;
    boolean isCancelled;
    int generation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerHandler(Notifier n, long milliseconds) {
        this.atTime = System.currentTimeMillis() + milliseconds;
        this.notifier = n;
        this.isCancelled = false;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            this.generation = this.notifier.timerGeneration;
            int i = 0;
            while (i < this.notifier.timerList.size()) {
                TimerHandler q = this.notifier.timerList.get(i);
                if (this.atTime < q.atTime) break;
                ++i;
            }
            this.notifier.timerList.add(i, this);
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            int i = 0;
            while (i < this.notifier.timerList.size()) {
                if (this.notifier.timerList.get(i) == this) {
                    this.notifier.timerList.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processTimerEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processTimerEvent();
}

