/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.Expression;
import tcl.lang.FindElemResult;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.Regex;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;
import tcl.lang.cmd.FormatCmd;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn;
    static final int maxExponent = 511;
    static final double[] powersOf10;
    static final int DEFAULT_PRECISION = 12;
    static int precision;

    static {
        char[] cArray = new char[75];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 100;
        cArray[11] = 100;
        cArray[12] = 100;
        cArray[13] = 100;
        cArray[14] = 100;
        cArray[15] = 100;
        cArray[16] = 100;
        cArray[17] = 10;
        cArray[18] = 11;
        cArray[19] = 12;
        cArray[20] = 13;
        cArray[21] = 14;
        cArray[22] = 15;
        cArray[23] = 16;
        cArray[24] = 17;
        cArray[25] = 18;
        cArray[26] = 19;
        cArray[27] = 20;
        cArray[28] = 21;
        cArray[29] = 22;
        cArray[30] = 23;
        cArray[31] = 24;
        cArray[32] = 25;
        cArray[33] = 26;
        cArray[34] = 27;
        cArray[35] = 28;
        cArray[36] = 29;
        cArray[37] = 30;
        cArray[38] = 31;
        cArray[39] = 32;
        cArray[40] = 33;
        cArray[41] = 34;
        cArray[42] = 35;
        cArray[43] = 100;
        cArray[44] = 100;
        cArray[45] = 100;
        cArray[46] = 100;
        cArray[47] = 100;
        cArray[48] = 100;
        cArray[49] = 10;
        cArray[50] = 11;
        cArray[51] = 12;
        cArray[52] = 13;
        cArray[53] = 14;
        cArray[54] = 15;
        cArray[55] = 16;
        cArray[56] = 17;
        cArray[57] = 18;
        cArray[58] = 19;
        cArray[59] = 20;
        cArray[60] = 21;
        cArray[61] = 22;
        cArray[62] = 23;
        cArray[63] = 24;
        cArray[64] = 25;
        cArray[65] = 26;
        cArray[66] = 27;
        cArray[67] = 28;
        cArray[68] = 29;
        cArray[69] = 30;
        cArray[70] = 31;
        cArray[71] = 32;
        cArray[72] = 33;
        cArray[73] = 34;
        cArray[74] = 35;
        cvtIn = cArray;
        powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        precision = 12;
    }

    private Util() {
    }

    public static void strtoul(String s, int start, int base, StrtoulResult strtoulResult) {
        long result = 0L;
        boolean anyDigits = false;
        boolean negative = false;
        int len = s.length();
        int i = start;
        char c = '\u0000';
        while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
            ++i;
        }
        if (i >= len) {
            strtoulResult.update(0L, 0, -1);
            return;
        }
        if (c == '-') {
            negative = true;
        }
        if (c == '-' || c == '+') {
            if (++i >= len) {
                strtoulResult.update(0L, 0, -1);
                return;
            }
            c = s.charAt(i);
        }
        if (base == 0) {
            if (c == '0') {
                if (i < len - 2 && ((c = s.charAt(++i)) == 'x' || c == 'X')) {
                    ++i;
                    base = 16;
                }
                if (base == 0) {
                    anyDigits = true;
                    base = 8;
                }
            } else {
                base = 10;
            }
        } else if (base == 16 && i < len - 2 && c == '0' && s.charAt(i + 1) == 'x') {
            i += 2;
        }
        boolean overflowed = false;
        long previousResult = 0L;
        int digitCount = 0;
        while (i < len) {
            ++digitCount;
            int digit = s.charAt(i) - 48;
            if (digit < 0 || digit > 74 || (digit = cvtIn[digit]) >= base) break;
            switch (base) {
                case 2: {
                    result = result << 1 | (long)digit;
                    overflowed = digitCount > 64;
                    break;
                }
                case 8: {
                    result = result << 3 | (long)digit;
                    overflowed = digitCount == 22 && digit > 1 || digitCount > 22;
                    break;
                }
                case 16: {
                    result = result << 4 | (long)digit;
                    overflowed = digitCount > 16;
                    break;
                }
                default: {
                    result = result * (long)base + (long)digit;
                    if (result < previousResult) {
                        overflowed = true;
                    }
                    previousResult = result;
                }
            }
            anyDigits = true;
            ++i;
        }
        if (negative) {
            result = -result;
        }
        if (!anyDigits) {
            strtoulResult.update(0L, 0, -1);
        } else if (overflowed) {
            strtoulResult.update(result, i, -2);
        } else {
            strtoulResult.update(result, i, 0);
        }
    }

    public static long getInt(Interp interp, String s) throws TclException {
        int len = s.length();
        int i = 0;
        StrtoulResult res = interp == null ? new StrtoulResult() : interp.strtoulResult;
        Util.strtoul(s, i, 0, res);
        if (res.errno < 0) {
            if (res.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
        }
        if (res.index < len) {
            i = res.index;
            while (i < len) {
                char c = s.charAt(i);
                if (c != ' ' && !Character.isWhitespace(c)) {
                    throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
                }
                ++i;
            }
        }
        return res.value;
    }

    public static long getWideInt(Interp interp, String str) throws TclException {
        return Util.getInt(interp, str);
    }

    public static final int getIntForIndex(Interp interp, TclObject tobj, int endValue) throws TclException {
        if (tobj.isIntType()) {
            return (int)TclInteger.getLong(interp, tobj);
        }
        String bytes = tobj.toString();
        int length = bytes.length();
        if (length == 0 || !"end".regionMatches(0, bytes, 0, length > 3 ? 3 : length)) {
            int offset;
            int i = 0;
            while (i < length) {
                if (!Character.isDigit(bytes.charAt(i)) && bytes.charAt(i) != '-') {
                    throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?");
                }
                ++i;
            }
            try {
                offset = (int)TclInteger.getLong(null, tobj);
            }
            catch (TclException tclException) {
                throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes));
            }
            return offset;
        }
        if (length <= 3) {
            return endValue;
        }
        if (length > 4 && bytes.charAt(3) == '-') {
            String offsetStr = bytes.substring(4);
            int i = 0;
            while (i < offsetStr.length()) {
                if (!Character.isDigit(offsetStr.charAt(i)) && offsetStr.charAt(i) != '-') {
                    throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?");
                }
                ++i;
            }
            try {
                int offset = (int)Util.getInt(interp, offsetStr);
                offset = -offset;
                return endValue + offset;
            }
            catch (TclException tclException) {}
        }
        throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes.substring(3)));
    }

    public static final String checkBadOctal(Interp interp, String value) {
        int p = 0;
        int len = value.length();
        while (p < len && Character.isWhitespace(value.charAt(p))) {
            ++p;
        }
        if (p < len && (value.charAt(p) == '+' || value.charAt(p) == '-')) {
            ++p;
        }
        if (p < len && value.charAt(p) == '0') {
            while (p < len && Character.isDigit(value.charAt(p))) {
                ++p;
            }
            while (p < len && Character.isWhitespace(value.charAt(p))) {
                ++p;
            }
            if (p >= len && interp != null) {
                return " (looks like invalid octal number)";
            }
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static void strtod(String s, int start, int len, StrtodResult strtodResult) {
        block28: {
            decPt = -1;
            i = start < 0 ? 0 : start;
            negative = false;
            c = '\u0000';
            if (len < 0) {
                len = s.length();
            }
            while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
                ++i;
            }
            if (i >= len) {
                strtodResult.update(0.0, 0, -3);
                return;
            }
            if (c == 'N' || c == 'n') {
                v0 = sub = i == 0 ? s : s.substring(i);
                if (sub.toLowerCase().startsWith("nan")) {
                    strtodResult.update(NaN, i + 3, 0);
                    return;
                }
            }
            if (c == '-') {
                negative = true;
            }
            if (c == '-' || c == '+') {
                if (++i >= len) {
                    strtodResult.update(0.0, 0, -3);
                    return;
                }
                c = s.charAt(i);
            }
            if (c == 'I') {
                infLen = 0;
                v1 = sub = i == 0 ? s : s.substring(i);
                if (sub.startsWith("Infinity")) {
                    infLen = "Infinity".length();
                } else if (sub.startsWith("Inf")) {
                    infLen = "Inf".length();
                }
                if (infLen > 0) {
                    strtodResult.update(negative != false ? -Infinity : Infinity, i + infLen, 0);
                    return;
                }
            }
            si = i;
            maybeZero = true;
            mantSize = 0;
            while (true) {
                if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
                    if (c != '.' || decPt >= 0) break;
                    decPt = mantSize;
                }
                if (c != '0' && c != '.') {
                    maybeZero = false;
                }
                if (++i >= len) break;
                c = s.charAt(i);
                ++mantSize;
            }
            if (i >= len) break block28;
            if (si != i) {
                c = s.charAt(i);
            }
            if (c != 'E' && c != 'e' || i >= len - 1 || ++i >= len) break block28;
            c = s.charAt(i);
            if (c == '-') {
                ++i;
            } else if (c == '+') {
                ++i;
            }
            notdigit = false;
            if (!(i >= len || (c = s.charAt(i)) >= '0' && c <= '9' || Character.isDigit(c))) {
                notdigit = true;
            }
            if (i < len && !notdigit) ** GOTO lbl69
            if (c == '-' || c == '+') {
                --i;
            }
            --i;
            break block28;
            while ((c = s.charAt(i)) >= '0' && c <= '9' || Character.isDigit(c)) {
                ++i;
lbl69:
                // 2 sources

                if (i < len) continue;
            }
        }
        if (si == i) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        s = s.substring(si, i);
        result = 0.0;
        try {
            result = Double.valueOf(s);
        }
        catch (NumberFormatException v2) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        if (result == -Infinity || result == Infinity || result == 0.0 && !maybeZero) {
            strtodResult.update(result, i, -4);
            return;
        }
        if (Double.isNaN(result)) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        strtodResult.update(negative != false ? -result : result, i, 0);
    }

    public static double getDouble(Interp interp, String s) throws TclException {
        int len = s.length();
        int i = 0;
        StrtodResult res = interp == null ? new StrtodResult() : interp.strtodResult;
        Util.strtod(s, i, len, res);
        if (res.errno != 0) {
            if (res.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        if (res.index < len) {
            i = res.index;
            while (i < len) {
                char c = s.charAt(i);
                if (c != ' ' && !Character.isWhitespace(c)) {
                    throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
                }
                ++i;
            }
        }
        return res.value;
    }

    public static TclObject concat(int from, int to, TclObject[] objv) throws TclException {
        int elemLength;
        String element;
        TclObject obj;
        if (from > objv.length) {
            return TclString.newInstance("");
        }
        if (to <= objv.length) {
            to = objv.length - 1;
        }
        boolean allList = true;
        int i = from;
        while (i <= to) {
            obj = objv[i];
            if (!obj.hasNoStringRep() || !obj.isListType()) {
                allList = false;
                break;
            }
            ++i;
        }
        if (allList) {
            TclObject tlist = TclList.newInstance();
            i = from;
            while (i <= to) {
                obj = objv[i];
                TclObject[] elements = TclList.getElements(null, obj);
                TclList.replace(null, tlist, Integer.MAX_VALUE, 0, elements, 0, elements.length - 1);
                ++i;
            }
            return tlist;
        }
        int allocSize = 0;
        i = from;
        while (i <= to) {
            obj = objv[i];
            element = obj.toString();
            elemLength = element.length();
            if (element != null && elemLength > 0) {
                allocSize += elemLength + 1;
            }
            ++i;
        }
        if (allocSize == 0) {
            allocSize = 1;
        }
        StringBuffer concatStr = new StringBuffer(allocSize);
        i = from;
        while (i <= to) {
            obj = objv[i];
            element = obj.toString();
            element = Util.TrimLeft(element, " ");
            elemLength = element.length();
            int j = elemLength - 1;
            while (j >= 0) {
                char c = element.charAt(j);
                if (c != ' ' && !Character.isWhitespace(c) || j > 0 && element.charAt(j - 1) == '\\') break;
                --j;
            }
            if (j != elemLength - 1) {
                element = element.substring(0, j + 1);
            }
            if (element.length() == 0) {
                if (i == to && concatStr.length() > 0) {
                    concatStr.setLength(concatStr.length() - 1);
                }
            } else {
                concatStr.append(element);
                if (i < to) {
                    concatStr.append(' ');
                }
            }
            ++i;
        }
        return TclString.newInstance(concatStr);
    }

    public static final boolean stringMatch(String str, String pat) {
        char[] strArr = str.toCharArray();
        char[] patArr = pat.toCharArray();
        int strLen = str.length();
        int patLen = pat.length();
        int pIndex = 0;
        int sIndex = 0;
        boolean incrIndex = false;
        while (true) {
            if (incrIndex) {
                ++pIndex;
                ++sIndex;
                incrIndex = false;
            }
            if (pIndex == patLen) {
                return sIndex == strLen;
            }
            if (sIndex == strLen && patArr[pIndex] != '*') {
                return false;
            }
            if (patArr[pIndex] == '*') {
                if (++pIndex == patLen) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(str.substring(sIndex), pat.substring(pIndex))) {
                        return true;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            if (patArr[pIndex] == '?') {
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '[') {
                ++pIndex;
                while (true) {
                    if (pIndex == patLen || patArr[pIndex] == ']') {
                        return false;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    char ch1 = patArr[pIndex];
                    char strch = strArr[sIndex];
                    if (pIndex + 1 != patLen && patArr[pIndex + 1] == '-') {
                        if ((pIndex += 2) == patLen) {
                            return false;
                        }
                        char ch2 = patArr[pIndex];
                        if (ch1 <= strch && ch2 >= strch || ch1 >= strch && ch2 <= strch) {
                            break;
                        }
                    } else if (ch1 == strch) break;
                    ++pIndex;
                }
                ++pIndex;
                while (pIndex != patLen && patArr[pIndex] != ']') {
                    ++pIndex;
                }
                if (pIndex == patLen) {
                    --pIndex;
                }
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '\\' && ++pIndex == patLen) {
                return false;
            }
            if (sIndex == strLen || patArr[pIndex] != strArr[sIndex]) {
                return false;
            }
            incrIndex = true;
        }
    }

    public static String toTitle(String str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(Character.toTitleCase(str.charAt(0)));
        buf.append(str.substring(1).toLowerCase());
        return buf.toString();
    }

    public static final boolean regExpMatch(Interp interp, String string, TclObject pattern) throws TclException {
        Regex r = TclRegexp.compile(interp, pattern, string);
        return r.match();
    }

    public static final void appendElement(Interp interp, StringBuffer sbuf, String s) throws TclException {
        if (sbuf.length() > 0) {
            sbuf.append(' ');
        }
        int flags = Util.scanElement(interp, s);
        Util.convertElement(s, flags, sbuf);
    }

    public static final boolean findElement(Interp interp, String s, int i, int len, FindElemResult fer) throws TclException {
        int openBraces = 0;
        boolean inQuotes = false;
        char c = '\u0000';
        int size = 0;
        while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        if (c == '{') {
            openBraces = 1;
            ++i;
        } else if (c == '\"') {
            inQuotes = true;
            ++i;
        }
        StringBuffer sbuf = null;
        int elemStart = i;
        int simpleStart = i;
        block8: while (true) {
            if (i >= len) {
                String elem;
                int elemEnd = i;
                size = elemEnd - elemStart;
                if (openBraces != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (inQuotes) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                if (sbuf == null) {
                    elem = s.substring(elemStart, elemEnd);
                } else {
                    sbuf.append(s.substring(simpleStart, elemEnd));
                    elem = sbuf.toString();
                }
                fer.update(elemStart, elemEnd, elem, size);
                return true;
            }
            c = s.charAt(i);
            switch (c) {
                case '{': {
                    if (openBraces != 0) {
                        ++openBraces;
                    }
                    ++i;
                    continue block8;
                }
                case '}': {
                    if (openBraces == 1) {
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            String elem;
                            if (sbuf == null) {
                                elem = s.substring(elemStart, elemEnd);
                            } else {
                                sbuf.append(s.substring(simpleStart, elemEnd));
                                elem = sbuf.toString();
                            }
                            fer.update(elemStart, elemEnd + 1, elem, size);
                            return true;
                        }
                        int errEnd = i + 1;
                        while (errEnd < len) {
                            if (Character.isWhitespace(s.charAt(errEnd))) break;
                            ++errEnd;
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    if (openBraces != 0) {
                        --openBraces;
                    }
                    ++i;
                    continue block8;
                }
                case '\\': {
                    BackSlashResult bs = Interp.backslash(s, i, len);
                    if (openBraces <= 0) {
                        if (sbuf == null) {
                            sbuf = new StringBuffer();
                        }
                        sbuf.append(s.substring(simpleStart, i));
                        sbuf.append(bs.c);
                        simpleStart = bs.nextIndex;
                    }
                    i = bs.nextIndex;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (openBraces == 0 && !inQuotes) {
                        String elem;
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (sbuf == null) {
                            elem = s.substring(elemStart, elemEnd);
                        } else {
                            sbuf.append(s.substring(simpleStart, elemEnd));
                            elem = sbuf.toString();
                        }
                        fer.update(elemStart, elemEnd, elem, size);
                        return true;
                    }
                    ++i;
                    continue block8;
                }
                case '\"': {
                    if (inQuotes) {
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            String elem;
                            if (sbuf == null) {
                                elem = s.substring(elemStart, elemEnd);
                            } else {
                                sbuf.append(s.substring(simpleStart, elemEnd));
                                elem = sbuf.toString();
                            }
                            fer.update(elemStart, elemEnd + 1, elem, size);
                            return true;
                        }
                        int errEnd = i + 1;
                        while (errEnd < len) {
                            if (Character.isWhitespace(s.charAt(errEnd))) break;
                            ++errEnd;
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    ++i;
                    continue block8;
                }
            }
            ++i;
        }
    }

    public static int scanElement(Interp interp, String string) throws TclException {
        char c;
        int len;
        int nestingLevel = 0;
        int flags = 0;
        int i = 0;
        if (string == null) {
            string = "";
        }
        if (i == (len = string.length())) {
            flags |= 2;
        } else {
            c = string.charAt(i);
            if (c == '{' || c == '\"') {
                flags |= 2;
            }
        }
        while (i < len) {
            c = string.charAt(i);
            switch (c) {
                case '{': {
                    ++nestingLevel;
                    break;
                }
                case '}': {
                    if (--nestingLevel >= 0) break;
                    flags |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 2;
                    break;
                }
                case '\\': {
                    if (i >= len - 1 || string.charAt(i + 1) == '\n') {
                        flags = 5;
                        break;
                    }
                    BackSlashResult bs = Interp.backslash(string, i, len);
                    i = bs.nextIndex - 1;
                    flags |= 2;
                }
            }
            ++i;
        }
        if (nestingLevel != 0) {
            flags = 5;
        }
        return flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void convertElement(String s, int flags, StringBuffer sbuf) {
        int len;
        int i = 0;
        int n = len = s == null ? 0 : s.length();
        if (len == 0) {
            sbuf.append("{}");
            return;
        }
        if ((flags & 2) != 0 && (flags & 1) == 0) {
            sbuf.append('{');
            sbuf.append(s);
            sbuf.append('}');
            return;
        }
        char c = s.charAt(0);
        if (c == '{') {
            sbuf.append('\\');
            sbuf.append('{');
            ++i;
            flags |= 4;
        }
        while (i < len) {
            block13: {
                c = s.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        sbuf.append('\\');
                        break;
                    }
                    case '{': 
                    case '}': {
                        if ((flags & 4) == 0) break;
                        sbuf.append('\\');
                        break;
                    }
                    case '\f': {
                        sbuf.append('\\');
                        sbuf.append('f');
                        break block13;
                    }
                    case '\n': {
                        sbuf.append('\\');
                        sbuf.append('n');
                        break block13;
                    }
                    case '\r': {
                        sbuf.append('\\');
                        sbuf.append('r');
                        break block13;
                    }
                    case '\t': {
                        sbuf.append('\\');
                        sbuf.append('t');
                        break block13;
                    }
                    case '\u000b': {
                        sbuf.append('\\');
                        sbuf.append('v');
                        break block13;
                    }
                }
                sbuf.append(c);
            }
            ++i;
        }
    }

    public static String TrimLeft(String str, String pattern) {
        char[] strArray = str.toCharArray();
        char[] patternArray = pattern.toCharArray();
        int strLen = strArray.length;
        int patLen = patternArray.length;
        int i = 0;
        while (i < strLen) {
            char c = str.charAt(i);
            boolean done = true;
            int j = 0;
            while (j < patLen) {
                char p = pattern.charAt(j);
                if (c == p || p == ' ' && Character.isWhitespace(c)) {
                    done = false;
                    break;
                }
                ++j;
            }
            if (done) break;
            ++i;
        }
        return str.substring(i, strLen);
    }

    public static String TrimLeft(String str) {
        return Util.TrimLeft(str, " \n\t\r");
    }

    public static String TrimRight(String str, String pattern) {
        char[] strArray = str.toCharArray();
        char[] patternArray = pattern.toCharArray();
        int patLen = patternArray.length;
        int last = strArray.length - 1;
        while (last >= 0) {
            char c = strArray[last];
            boolean done = true;
            int j = 0;
            while (j < patLen) {
                char p = patternArray[j];
                if (c == p || p == ' ' && Character.isWhitespace(c)) {
                    done = false;
                    break;
                }
                ++j;
            }
            if (done) break;
            --last;
        }
        return str.substring(0, last + 1);
    }

    public static String TrimRight(String str) {
        return Util.TrimRight(str, " \n\t\r");
    }

    public static boolean getBoolean(Interp interp, String string) throws TclException {
        String s = string.toLowerCase();
        int slen = s.length();
        if (slen > 0) {
            char c = s.charAt(0);
            switch (c) {
                case '0': {
                    if (slen != 1) break;
                    return false;
                }
                case '1': {
                    if (slen != 1) break;
                    return true;
                }
                case 'f': {
                    if (!"false".startsWith(s)) break;
                    return false;
                }
                case 'o': {
                    if (slen > 1 && "on".startsWith(s)) {
                        return true;
                    }
                    if (slen <= 1 || !"off".startsWith(s)) break;
                    return false;
                }
                case 'n': {
                    if (!"no".startsWith(s)) break;
                    return false;
                }
                case 't': {
                    if (!"true".startsWith(s)) break;
                    return true;
                }
                case 'y': {
                    if (!"yes".startsWith(s)) break;
                    return true;
                }
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    public static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    public static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    public static final boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac") && !os.endsWith("x");
    }

    public static final boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    static boolean isJacl() {
        return true;
    }

    public static boolean looksLikeInt(String s) {
        return Expression.looksLikeInt(s, s.length(), 0, true);
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
    }

    public static String printDouble(double number) {
        String s = FormatCmd.toString(number, precision, 10);
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == '.' || Character.isLetter(s.charAt(i))) {
                return s;
            }
            ++i;
        }
        return String.valueOf(s) + ".0";
    }

    static String tryGetSystemProperty(String propName, String defautlValue) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException securityException) {
            return defautlValue;
        }
    }
}

