/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import tcl.lang.Command;
import tcl.lang.CommandTrace;
import tcl.lang.ExecutionTrace;
import tcl.lang.ImportRef;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class WrappedCommand {
    public HashMap<String, WrappedCommand> table;
    public String hashKey;
    public Namespace ns;
    public Command cmd;
    private ArrayList<CommandTrace> commandTraces = null;
    private ArrayList<ExecutionTrace> executionTraces = null;
    private boolean deleteTraceInProgress = false;
    private boolean renameTraceInProgress = false;
    private boolean executionTraceInProgress = false;
    private boolean hasStepTrace = false;
    public boolean deleted;
    ImportRef importRef;
    public int cmdEpoch;

    public boolean hasCommandTraces() {
        return this.commandTraces != null;
    }

    public void removeAllCommandTraces() {
        this.commandTraces = null;
    }

    public void untraceCommand(int type, String callbackCmd) throws TclException {
        if (this.commandTraces == null) {
            return;
        }
        int i = 0;
        while (i < this.commandTraces.size()) {
            CommandTrace trace = this.commandTraces.get(i);
            if (type == trace.getType() && trace.getCallbackCmd().equals(callbackCmd)) {
                this.commandTraces.remove(i);
                break;
            }
            ++i;
        }
        if (this.commandTraces.size() == 0) {
            this.commandTraces = null;
        }
    }

    public void traceCommand(CommandTrace trace) throws TclException {
        this.untraceCommand(trace.getType(), trace.getCallbackCmd());
        if (this.commandTraces == null) {
            this.commandTraces = new ArrayList();
        }
        this.commandTraces.add(trace);
    }

    public TclObject traceCommandInfo(Interp interp) throws TclException {
        if (this.commandTraces == null || this.commandTraces.size() == 0) {
            return TclString.newInstance("");
        }
        TclObject rv = TclList.newInstance();
        boolean[] reported = new boolean[this.commandTraces.size()];
        int i = 0;
        while (i < reported.length) {
            reported[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.commandTraces.size()) {
            if (!reported[i]) {
                reported[i] = true;
                TclObject traceInfo = TclList.newInstance();
                TclList.append(interp, rv, traceInfo);
                CommandTrace trace = this.commandTraces.get(i);
                boolean isDelete = trace.getType() == 0;
                boolean isRename = trace.getType() == 1;
                int j = i + 1;
                while (j < this.commandTraces.size()) {
                    CommandTrace trace2;
                    if (!reported[j] && (trace2 = this.commandTraces.get(j)).getCallbackCmd().equals(trace.getCallbackCmd())) {
                        reported[j] = true;
                        if (trace2.getType() == 0) {
                            isDelete = true;
                            break;
                        }
                        isRename = true;
                        break;
                    }
                    ++j;
                }
                TclObject ops = TclList.newInstance();
                if (isRename) {
                    TclList.append(interp, ops, TclString.newInstance("rename"));
                }
                if (isDelete) {
                    TclList.append(interp, ops, TclString.newInstance("delete"));
                }
                TclList.append(interp, traceInfo, ops);
                TclList.append(interp, traceInfo, TclString.newInstance(trace.getCallbackCmd()));
            }
            ++i;
        }
        return rv;
    }

    void callCommandTraces(int type, String newName) {
        boolean inProgress = false;
        switch (type) {
            case 0: {
                inProgress = this.deleteTraceInProgress;
                this.deleteTraceInProgress = true;
                break;
            }
            case 1: {
                inProgress = this.renameTraceInProgress;
                this.renameTraceInProgress = true;
            }
        }
        if (this.commandTraces != null && !inProgress && !this.ns.interp.deleted) {
            Object[] copyOfTraces;
            String oldCommand = String.valueOf(this.ns.fullName) + (this.ns.fullName.endsWith("::") ? "" : "::") + this.hashKey;
            Object[] objectArray = copyOfTraces = this.commandTraces.toArray();
            int n = copyOfTraces.length;
            int n2 = 0;
            while (n2 < n) {
                Object commandTrace = objectArray[n2];
                ((CommandTrace)commandTrace).trace(this.ns.interp, type, oldCommand, type == 0 ? "" : newName);
                ++n2;
            }
            this.ns.interp.resetResult();
        }
        switch (type) {
            case 0: {
                this.deleteTraceInProgress = false;
                break;
            }
            case 1: {
                this.renameTraceInProgress = false;
            }
        }
    }

    public void traceExecution(ExecutionTrace trace) throws TclException {
        this.untraceExecution(trace.getType(), trace.getCallbackCmd());
        if (this.executionTraces == null) {
            this.executionTraces = new ArrayList();
        }
        this.executionTraces.add(trace);
        if (trace.getType() == 2 || trace.getType() == 3) {
            this.hasStepTrace = true;
        }
    }

    public void untraceExecution(int type, String callbackCmd) throws TclException {
        if (this.executionTraces == null) {
            return;
        }
        int i = 0;
        while (i < this.executionTraces.size()) {
            ExecutionTrace trace = this.executionTraces.get(i);
            if (type == trace.getType() && trace.getCallbackCmd().equals(callbackCmd)) {
                trace.setDeleted(true);
                this.executionTraces.remove(i);
                break;
            }
            ++i;
        }
        if (this.executionTraces.size() == 0) {
            this.hasStepTrace = false;
            this.executionTraces = null;
        }
        if (this.executionTraces != null && (type == 2 || type == 3)) {
            this.hasStepTrace = false;
            for (ExecutionTrace trace : this.executionTraces) {
                if (trace.getType() != 2 && trace.getType() != 3) continue;
                this.hasStepTrace = true;
                break;
            }
        }
    }

    void callExecutionTraces(Interp interp, TclObject[] objv, int type, int completionCode, TclObject result) throws TclException {
        if (this.executionTraces != null && this.executionTraces.size() > 0 && !this.executionTraceInProgress) {
            this.executionTraceInProgress = true;
            TclObject commandString = TclList.newInstance();
            TclList.append(interp, commandString, objv, 0, objv.length);
            ExecutionTrace[] copyOfTraces = new ExecutionTrace[]{};
            copyOfTraces = this.executionTraces.toArray(copyOfTraces);
            try {
                if (type == 0 || type == 2) {
                    int i = copyOfTraces.length - 1;
                    while (i >= 0) {
                        copyOfTraces[i].trace(interp, type, commandString.toString(), completionCode, result);
                        --i;
                    }
                } else {
                    int i = 0;
                    while (i < copyOfTraces.length) {
                        copyOfTraces[i].trace(interp, type, commandString.toString(), completionCode, result);
                        ++i;
                    }
                }
            }
            finally {
                this.executionTraceInProgress = false;
            }
        }
    }

    public TclObject traceExecutionInfo(Interp interp) throws TclException {
        if (this.executionTraces == null || this.executionTraces.size() == 0) {
            return TclString.newInstance("");
        }
        TclObject rv = TclList.newInstance();
        boolean[] reported = new boolean[this.executionTraces.size()];
        int i = 0;
        while (i < reported.length) {
            reported[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.executionTraces.size()) {
            if (!reported[i]) {
                reported[i] = true;
                TclObject traceInfo = TclList.newInstance();
                TclList.append(interp, rv, traceInfo);
                ExecutionTrace trace = this.executionTraces.get(i);
                boolean[] traceTypes = new boolean[4];
                int k = 0;
                while (k < 3) {
                    traceTypes[k] = false;
                    ++k;
                }
                traceTypes[trace.getType()] = true;
                int j = i + 1;
                while (j < this.executionTraces.size()) {
                    ExecutionTrace trace2;
                    if (!reported[j] && (trace2 = this.executionTraces.get(j)).getCallbackCmd().equals(trace.getCallbackCmd())) {
                        reported[j] = true;
                        traceTypes[trace2.getType()] = true;
                    }
                    ++j;
                }
                TclObject ops = TclList.newInstance();
                if (traceTypes[0]) {
                    TclList.append(interp, ops, TclString.newInstance("enter"));
                }
                if (traceTypes[2]) {
                    TclList.append(interp, ops, TclString.newInstance("enterstep"));
                }
                if (traceTypes[1]) {
                    TclList.append(interp, ops, TclString.newInstance("leave"));
                }
                if (traceTypes[3]) {
                    TclList.append(interp, ops, TclString.newInstance("leavestep"));
                }
                TclList.append(interp, traceInfo, ops);
                TclList.append(interp, traceInfo, TclString.newInstance(trace.getCallbackCmd()));
            }
            ++i;
        }
        return rv;
    }

    public final boolean mustCallInvoke(Interp interp) {
        return this.executionTraces != null && !this.executionTraceInProgress || interp.hasActiveExecutionStepTraces();
    }

    public void invoke(Interp interp, TclObject[] objv) throws TclException {
        if (!this.mustCallInvoke(interp)) {
            this.cmd.cmdProc(interp, objv);
            return;
        }
        TclException savedException = null;
        if (interp.hasActiveExecutionStepTraces()) {
            WrappedCommand[] cmds;
            WrappedCommand[] wrappedCommandArray = cmds = interp.getCopyOfActiveExecutionStepTraces();
            int n = cmds.length;
            int n2 = 0;
            while (n2 < n) {
                WrappedCommand cmd = wrappedCommandArray[n2];
                cmd.callExecutionTraces(interp, objv, 2, 0, null);
                ++n2;
            }
        }
        interp.enableExecutionStepTracing(false);
        try {
            this.callExecutionTraces(interp, objv, 0, 0, null);
        }
        finally {
            interp.enableExecutionStepTracing(true);
        }
        if (this.deleted) {
            WrappedCommand newCmd = Namespace.findCommand(interp, objv[0].toString(), this.ns, 0);
            if (newCmd == null) {
                throw new TclException(interp, "invalid command name \"" + objv[0] + "\"");
            }
            newCmd.invoke(interp, objv);
            return;
        }
        boolean hadStepTrace = this.hasStepTrace;
        if (this.hasStepTrace) {
            hadStepTrace = interp.activateExecutionStepTrace(this);
        }
        try {
            this.cmd.cmdProc(interp, objv);
        }
        catch (TclException e) {
            savedException = e;
        }
        if (hadStepTrace) {
            interp.deactivateExecutionStepTrace(this);
        }
        TclObject savedResult = interp.getResult();
        savedResult.preserve();
        int savedReturnCode = interp.returnCode;
        boolean errAlreadyLogged = interp.errAlreadyLogged;
        try {
            this.callExecutionTraces(interp, objv, 1, savedException == null ? 0 : savedException.getCompletionCode(), savedResult);
            if (interp.hasActiveExecutionStepTraces()) {
                WrappedCommand[] cmds;
                WrappedCommand[] wrappedCommandArray = cmds = interp.getCopyOfActiveExecutionStepTraces();
                int n = cmds.length;
                int n3 = 0;
                while (n3 < n) {
                    WrappedCommand cmd = wrappedCommandArray[n3];
                    cmd.callExecutionTraces(interp, objv, 3, savedException == null ? 0 : savedException.getCompletionCode(), savedResult);
                    ++n3;
                }
            }
        }
        catch (TclException tclException) {}
        interp.errAlreadyLogged = errAlreadyLogged;
        interp.returnCode = savedReturnCode;
        interp.setResult(savedResult);
        savedResult.release();
        if (savedException != null) {
            throw savedException;
        }
    }

    void incrEpoch() {
        ++this.cmdEpoch;
        if (this.cmdEpoch == Integer.MIN_VALUE) {
            this.cmdEpoch = 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Wrapper for ");
        if (this.ns != null) {
            sb.append(this.ns.fullName);
            if (!this.ns.fullName.equals("::")) {
                sb.append("::");
            }
        }
        if (this.table != null) {
            sb.append(this.hashKey);
        }
        sb.append(" -> ");
        sb.append(this.cmd.getClass().getName());
        sb.append(" cmdEpoch is ");
        sb.append(this.cmdEpoch);
        return sb.toString();
    }
}

