/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.net.InetAddress;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;

public abstract class AbstractSocketChannel
extends Channel {
    public TclObject getPeerName(Interp interp) throws TclException {
        InetAddress address = this.getPeerAddress();
        if (address == null) {
            throw new TclException(interp, "can't get peername: socket is not connected");
        }
        TclObject rv = TclList.newInstance();
        TclList.append(interp, rv, TclString.newInstance(address.getHostAddress()));
        TclList.append(interp, rv, TclString.newInstance(address.getHostName()));
        TclList.append(interp, rv, TclInteger.newInstance(this.getPeerPort()));
        return rv;
    }

    public TclObject getSockName(Interp interp) throws TclException {
        InetAddress address = this.getLocalAddress();
        if (address == null) {
            throw new TclException(interp, "can't get localname");
        }
        TclObject rv = TclList.newInstance();
        TclList.append(interp, rv, TclString.newInstance(address.getHostAddress()));
        TclList.append(interp, rv, TclString.newInstance(address.getHostName()));
        TclList.append(interp, rv, TclInteger.newInstance(this.getLocalPort()));
        return rv;
    }

    @Override
    String getChanType() {
        return "tcp";
    }

    @Override
    public void setOutputTranslation(int translation) {
        if (translation == 0) {
            translation = 4;
        }
        super.setOutputTranslation(translation);
    }

    public abstract TclObject getError(Interp var1) throws TclException;

    abstract InetAddress getPeerAddress();

    abstract int getPeerPort();

    abstract InetAddress getLocalAddress();

    abstract int getLocalPort();
}

