/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.io.Writer;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.channel.EofInputFilter;
import tcl.lang.channel.EofOutputFilter;
import tcl.lang.channel.EolInputFilter;
import tcl.lang.channel.EolOutputFilter;
import tcl.lang.channel.InputBuffer;
import tcl.lang.channel.MarkableInputStream;
import tcl.lang.channel.NonBlockingOutputStream;
import tcl.lang.channel.OutputBuffer;
import tcl.lang.channel.UnicodeDecoder;
import tcl.lang.channel.UnicodeEncoder;
import tcl.lang.cmd.EncodingCmd;

public abstract class Channel {
    protected int mode;
    private String chanName;
    public int refCount = 0;
    protected boolean blocking = true;
    protected InputBuffer inputBuffer = null;
    protected InputStream rawInputStream = null;
    protected OutputStream rawOutputStream = null;
    protected EolInputFilter eolInputFilter = null;
    protected EofInputFilter eofInputFilter = null;
    protected UnicodeDecoder unicodeDecoder = null;
    protected InputStream finalInputStream = null;
    protected MarkableInputStream markableInputStream = null;
    protected Reader finalReader = null;
    protected EolOutputFilter eolOutputFilter = null;
    protected UnicodeEncoder unicodeEncoder = null;
    protected OutputBuffer outputBuffer = null;
    protected EofOutputFilter eofOutputFilter = null;
    protected NonBlockingOutputStream nonBlockingOutputStream = null;
    protected Writer firstWriter = null;
    protected OutputStream firstOutputStream = null;
    protected int buffering = 0;
    protected int bufferSize = 4096;
    protected String encoding;
    protected int inputTranslation = 0;
    protected int outputTranslation = TclIO.TRANS_PLATFORM;
    protected char inputEofChar = '\u0000';
    protected char outputEofChar = '\u0000';
    boolean eofSeen = false;
    long readOwningThread = -1L;
    long writeOwningThread = -1L;
    public static final int READ_OWNERSHIP = 1;
    public static final int WRITE_OWNERSHIP = 2;
    Object ownershipNotifier = new Object();
    volatile boolean closed = false;
    boolean encodingChangedSinceLastRead = false;

    Channel() {
        this.setEncoding(EncodingCmd.systemJavaEncoding);
    }

    public int read(Interp interp, TclObject tobj, int readType, int numBytes) throws IOException, TclException {
        if (!this.setOwnership(true, 1)) {
            throw new TclException(interp, "channel is busy");
        }
        try {
            boolean readChars;
            this.checkRead(interp);
            this.initInput();
            this.encodingChangedSinceLastRead = false;
            if (this.eofSeen) {
                this.setOwnership(false, 1);
                return -1;
            }
            boolean bl = readChars = this.encoding != null || this.inputTranslation != 1 && this.inputTranslation != 2;
            if (readChars) {
                TclString.empty(tobj);
            } else {
                TclByteArray.setLength(interp, tobj, 0);
            }
            switch (readType) {
                case 1: {
                    numBytes = Integer.MAX_VALUE;
                }
                case 3: {
                    int bufsize;
                    int cnt = 0;
                    int total = 0;
                    char[] buf = null;
                    int n = bufsize = numBytes < 8192 ? numBytes : 8192;
                    if (readChars) {
                        buf = new char[bufsize];
                    } else {
                        TclByteArray.setLength(interp, tobj, 0);
                    }
                    while (total < numBytes) {
                        if (readChars) {
                            cnt = this.finalReader.read(buf, 0, Math.min(buf.length, numBytes - total));
                        } else {
                            int curBufLen = TclByteArray.getLength(interp, tobj);
                            if (curBufLen < total + bufsize) {
                                TclByteArray.setLength(interp, tobj, curBufLen + bufsize);
                            }
                            cnt = this.finalInputStream.read(TclByteArray.getBytes(interp, tobj), total, Math.min(bufsize, numBytes - total));
                        }
                        if (cnt == -1) {
                            this.eofSeen = true;
                            break;
                        }
                        if (cnt == 0 && !this.blocking) {
                            this.setEofSeenWithoutRead();
                            break;
                        }
                        if (readChars) {
                            TclString.append(tobj, buf, 0, cnt);
                        }
                        total += cnt;
                    }
                    if (!readChars) {
                        TclByteArray.setLength(interp, tobj, total);
                    }
                    if (this.eofSeen && total == 0) {
                        this.setOwnership(false, 1);
                        return -1;
                    }
                    this.setOwnership(false, 1);
                    int n2 = total;
                    return n2;
                }
                case 2: {
                    if (this.finalReader != this.eolInputFilter) {
                        throw new TclRuntimeError("finalReader != eolInputFilter, programmer error!");
                    }
                    StringBuffer sb = new StringBuffer(64);
                    int rv = this.eolInputFilter.readLine(sb, this.blocking);
                    TclString.empty(tobj);
                    this.setOwnership(false, 1);
                    switch (rv) {
                        case 0: {
                            TclString.append(tobj, sb.toString());
                            this.eofSeen = this.eolInputFilter.eofSeen();
                            int n = sb.length();
                            return n;
                        }
                        case -1: {
                            this.eofSeen = true;
                            return -1;
                        }
                        case -2: {
                            this.setEofSeenWithoutRead();
                            return -1;
                        }
                    }
                }
            }
            throw new TclRuntimeError("Channel.read: Invalid read mode.");
        }
        finally {
            this.setOwnership(false, 1);
        }
    }

    public void write(Interp interp, TclObject outData) throws IOException, TclException {
        block10: {
            if (!this.setOwnership(true, 2)) {
                throw new TclException(interp, "channel is busy");
            }
            try {
                char[] cbuf;
                this.checkWrite(interp);
                this.initOutput();
                if (outData.isByteArrayType() && this.encoding == null && (this.outputTranslation == 1 || this.outputTranslation == 2)) {
                    byte[] bytes;
                    this.firstOutputStream.write(TclByteArray.getBytes(interp, outData), 0, TclByteArray.getLength(interp, outData));
                    if (this.buffering != 1) break block10;
                    byte[] byArray = bytes = TclByteArray.getBytes(interp, outData);
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        if (b == 10) {
                            this.firstOutputStream.flush();
                            break block10;
                        }
                        ++n2;
                    }
                    break block10;
                }
                if (outData.isByteArrayType() && this.encoding != null) {
                    cbuf = TclByteArray.decodeToString(interp, outData, EncodingCmd.systemTclEncoding).toCharArray();
                    if (cbuf.length == 0 && TclByteArray.getLength(interp, outData) > 0) {
                        throw new TclException(interp, "error writing \"" + this.getChanName() + "\": invalid argument");
                    }
                } else {
                    cbuf = outData.toString().toCharArray();
                }
                this.firstWriter.write(cbuf, 0, cbuf.length);
            }
            finally {
                this.setOwnership(false, 2);
            }
        }
    }

    public void write(Interp interp, String outStr) throws IOException, TclException {
        this.write(interp, TclString.newInstance(outStr));
    }

    public synchronized boolean setOwnership(boolean takeOwnership, int type) {
        return this.setOwnership(takeOwnership, type, Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOwnership(boolean takeOwnership, int type, long threadId) {
        Object object = this.ownershipNotifier;
        synchronized (object) {
            block12: {
                long owningThread;
                block11: {
                    long l = owningThread = type == 1 ? this.readOwningThread : this.writeOwningThread;
                    if (type == 1 || type == 2) break block11;
                    return false;
                }
                if (owningThread >= 0L && threadId != owningThread) break block12;
                if (takeOwnership) {
                    if (type == 1) {
                        this.readOwningThread = threadId;
                    }
                    if (type == 2) {
                        this.writeOwningThread = threadId;
                    }
                } else {
                    if (type == 1) {
                        this.readOwningThread = -1L;
                    }
                    if (type == 2) {
                        this.writeOwningThread = -1L;
                    }
                    this.ownershipNotifier.notifyAll();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOwnership(int type) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Object object = this.ownershipNotifier;
        synchronized (object) {
            while (!this.setOwnership(true, type, threadId)) {
                this.ownershipNotifier.wait();
            }
        }
    }

    abstract void implClose() throws IOException;

    public synchronized void close() throws IOException {
        IOException ex = null;
        boolean implCloseCalled = false;
        this.closed = true;
        if (this.finalReader != null) {
            try {
                this.finalReader.close();
            }
            catch (IOException e) {
                ex = e;
            }
            this.finalReader = null;
            this.finalInputStream = null;
            this.eolInputFilter = null;
            this.unicodeDecoder = null;
            this.markableInputStream = null;
            this.inputBuffer = null;
            this.eofInputFilter = null;
        }
        if (this.firstWriter != null) {
            try {
                this.firstWriter.close();
                implCloseCalled = true;
            }
            catch (IOException e) {
                ex = e;
            }
            this.firstWriter = null;
            this.firstOutputStream = null;
            this.eolOutputFilter = null;
            this.unicodeEncoder = null;
            this.outputBuffer = null;
            this.eofOutputFilter = null;
            this.nonBlockingOutputStream = null;
        }
        if (!implCloseCalled) {
            this.implClose();
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void flush(Interp interp) throws IOException, TclException {
        this.checkWrite(interp);
        if (!this.setOwnership(true, 2)) {
            throw new TclException(interp, "channel is busy");
        }
        try {
            if (this.firstWriter != null) {
                this.firstWriter.flush();
            }
        }
        finally {
            this.setOwnership(false, 2);
        }
    }

    void sync() throws SyncFailedException, IOException {
    }

    public void seek(Interp interp, long offset, int mode) throws IOException, TclException {
        throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
    }

    public long tell() throws IOException {
        return -1L;
    }

    void setEofSeenWithoutRead() {
    }

    protected void initInput() throws IOException {
        if (this.finalReader != null) {
            return;
        }
        this.rawInputStream = this.getInputStream();
        this.eofInputFilter = new EofInputFilter(this.rawInputStream, (byte)(this.inputEofChar & 0xFF));
        this.inputBuffer = new InputBuffer(this.eofInputFilter, this.bufferSize, this.buffering, this.blocking, this);
        this.markableInputStream = new MarkableInputStream(this.inputBuffer);
        this.unicodeDecoder = new UnicodeDecoder(this.markableInputStream, this.encoding);
        this.eolInputFilter = new EolInputFilter(this.unicodeDecoder, this.inputTranslation);
        this.finalReader = this.eolInputFilter;
        this.finalInputStream = this.markableInputStream;
        this.encodingChangedSinceLastRead = false;
        this.closed = false;
    }

    protected void initOutput() throws IOException {
        if (this.firstWriter != null) {
            return;
        }
        this.rawOutputStream = this.getOutputStream();
        this.eofOutputFilter = new EofOutputFilter(this.rawOutputStream, (byte)(this.outputEofChar & 0xFF));
        this.nonBlockingOutputStream = new NonBlockingOutputStream(this.eofOutputFilter, this.blocking, this);
        this.outputBuffer = new OutputBuffer(this.nonBlockingOutputStream, this.bufferSize, this.buffering);
        this.unicodeEncoder = new UnicodeEncoder(this.outputBuffer, this.encoding);
        this.eolOutputFilter = new EolOutputFilter(this.unicodeEncoder, this.outputTranslation);
        this.firstWriter = this.eolOutputFilter;
        this.firstOutputStream = this.outputBuffer;
        this.closed = false;
    }

    boolean isWritable() {
        if (this.outputBuffer == null && !this.closed) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        return this.outputBuffer.getBufferedByteCount() < this.bufferSize;
    }

    boolean isReadable() {
        if (this.inputBuffer == null) {
            return false;
        }
        if (this.encodingChangedSinceLastRead) {
            return true;
        }
        if (this.inputBuffer.eof()) {
            return true;
        }
        try {
            if (this.buffering == 1 && !this.inputBuffer.lastReadWouldHaveBlocked() && this.inputBuffer.isRefillInProgress()) {
                return true;
            }
        }
        catch (IOException iOException) {}
        try {
            return this.inputBuffer.available() > 0;
        }
        catch (IOException e) {
            return !e.getMessage().toLowerCase().contains("closed");
        }
    }

    void fillInputBuffer() throws IOException {
        if ((this.isReadOnly() || this.isReadWrite()) && !this.closed) {
            this.initInput();
            if (this.inputBuffer != null) {
                this.inputBuffer.requestRefill(false);
            }
        }
    }

    public boolean eof() {
        return this.eofSeen;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    public String getChanName() {
        return this.chanName;
    }

    abstract String getChanType();

    int getRefCount() {
        return this.refCount;
    }

    void setChanName(String chan) {
        this.chanName = chan;
    }

    public boolean isReadOnly() {
        return (this.mode & 1) != 0;
    }

    public boolean isWriteOnly() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadWrite() {
        return (this.mode & 4) != 0;
    }

    protected void checkRead(Interp interp) throws TclException {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for reading");
        }
    }

    protected void checkWrite(Interp interp) throws TclException {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean inBlocking) {
        this.blocking = inBlocking;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBlockingMode(this.blocking);
        }
        if (this.nonBlockingOutputStream != null) {
            this.nonBlockingOutputStream.setBlocking(this.blocking);
        }
    }

    public int getBuffering() {
        return this.buffering;
    }

    public void setBuffering(int inBuffering) {
        if (inBuffering < 0 || inBuffering > 2) {
            throw new TclRuntimeError("invalid buffering mode in Channel.setBuffering()");
        }
        this.buffering = inBuffering;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBuffering(inBuffering);
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.setBuffering(inBuffering);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if (size < 1 || size > 0x100000) {
            return;
        }
        this.bufferSize = size;
        if (this.inputBuffer != null) {
            this.inputBuffer.setBufferSize(size);
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.setBufferSize(size);
        }
    }

    int getNumBufferedInputBytes() {
        if (this.inputBuffer != null) {
            try {
                return this.unicodeDecoder.available() - this.rawInputStream.available();
            }
            catch (IOException iOException) {
                return 0;
            }
        }
        return 0;
    }

    int getNumBufferedOutputBytes() {
        if (this.outputBuffer != null) {
            return this.outputBuffer.getBufferedByteCount();
        }
        return 0;
    }

    public boolean isBlocked(Interp interp) throws TclException {
        this.checkRead(interp);
        if (this.inputBuffer != null) {
            return this.inputBuffer.lastReadWouldHaveBlocked() && !this.eof();
        }
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String inEncoding) {
        this.encoding = inEncoding;
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.setEncoding(this.encoding);
            this.encodingChangedSinceLastRead = true;
        }
        if (this.unicodeEncoder != null) {
            this.unicodeEncoder.setEncoding(this.encoding);
        }
    }

    public int getInputTranslation() {
        return this.inputTranslation;
    }

    public void setInputTranslation(int translation) {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            return;
        }
        this.inputTranslation = translation;
        if (this.eolInputFilter != null) {
            this.eolInputFilter.setTranslation(translation);
        }
    }

    public int getOutputTranslation() {
        return this.outputTranslation;
    }

    public void setOutputTranslation(int translation) {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            return;
        }
        this.outputTranslation = translation == 0 ? TclIO.TRANS_PLATFORM : translation;
        if (this.eolOutputFilter != null) {
            this.eolOutputFilter.setTranslation(this.outputTranslation);
        }
    }

    public char getInputEofChar() {
        return this.inputEofChar;
    }

    public void setInputEofChar(char inEof) {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            return;
        }
        if ((inEof = (char)(inEof & 0xFF)) == this.inputEofChar) {
            return;
        }
        this.inputEofChar = (char)(inEof & 0xFF);
        if (this.eofInputFilter != null) {
            this.eofInputFilter.setEofChar((byte)this.inputEofChar);
        }
        if (this.inputBuffer != null) {
            this.inputBuffer.cancelEof();
        }
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.cancelEof();
        }
        this.eofSeen = false;
    }

    public char getOutputEofChar() {
        return this.outputEofChar;
    }

    public void setOutputEofChar(char outEof) {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            return;
        }
        this.outputEofChar = (char)(outEof & 0xFF);
        if (this.eofOutputFilter != null) {
            this.eofOutputFilter.setEofChar((byte)this.outputEofChar);
        }
    }
}

