/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class EofInputFilter
extends FilterInputStream {
    private byte eofchar;
    private boolean eofSeen = false;
    private boolean sawEofChar = false;
    private int eofCharacterThatWasSeen = 0;

    EofInputFilter(InputStream in) {
        super(in);
        this.eofchar = 0;
    }

    EofInputFilter(InputStream in, byte eofchar) {
        super(in);
        this.eofchar = eofchar;
    }

    void seekReset() {
        this.cancelEof();
        this.sawEofChar = false;
    }

    void cancelEof() {
        this.eofSeen = false;
    }

    void setEofChar(byte eofChar) {
        if (eofChar != this.eofchar) {
            this.cancelEof();
        }
        this.eofchar = eofChar;
    }

    boolean sawEofChar() {
        return this.sawEofChar;
    }

    @Override
    public int available() throws IOException {
        int avail = 0;
        try {
            avail = this.in.available();
        }
        catch (IOException iOException) {
            avail = 0;
        }
        return avail + (this.sawEofChar ? 1 : 0);
    }

    @Override
    public int read() throws IOException {
        if (this.eofSeen) {
            return -1;
        }
        if (this.sawEofChar) {
            this.sawEofChar = false;
            return this.eofCharacterThatWasSeen;
        }
        int c = super.read();
        if (c == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.eofchar != 0 && c == this.eofchar) {
            this.eofSeen = true;
            this.sawEofChar = true;
            this.eofCharacterThatWasSeen = c;
            return -1;
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eofSeen) {
            return -1;
        }
        if (this.sawEofChar && len > 0) {
            b[off] = (byte)(this.eofCharacterThatWasSeen & 0xFF);
            this.sawEofChar = false;
            return 1;
        }
        if (this.eofchar == 0) {
            return super.read(b, off, len);
        }
        int cnt = 0;
        while (cnt < len) {
            int c = this.read();
            if (c == -1) break;
            b[off + cnt] = (byte)(c & 0xFF);
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void close() throws IOException {
    }
}

