/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterReader;
import java.io.IOException;
import tcl.lang.channel.UnicodeDecoder;

class EolInputFilter
extends FilterReader {
    static final int EOF = -1;
    static final int INCOMPLETE_LINE = -2;
    static final int COMPLETE_LINE = 0;
    private int translation;
    private boolean eofSeen = false;
    private UnicodeDecoder unicodeDecoder = null;

    EolInputFilter(UnicodeDecoder in, int translation) {
        super(in);
        this.setTranslation(translation);
        this.unicodeDecoder = in;
    }

    void setTranslation(int translation) {
        this.translation = translation;
    }

    void seekReset() {
        this.eofSeen = false;
    }

    boolean eofSeen() {
        return this.eofSeen;
    }

    int readLine(StringBuffer sb, boolean block) throws IOException {
        char[] cbuf = new char[1];
        boolean sawEol = false;
        if (!block) {
            this.unicodeDecoder.mark(1024);
        }
        while (true) {
            int cnt;
            if ((cnt = super.read(cbuf, 0, 1)) == -1) {
                this.eofSeen = true;
                break;
            }
            if (cnt == 0) {
                if (!block) break;
                continue;
            }
            char c1 = cbuf[0];
            if (this.isEolChar(c1)) {
                sawEol = true;
                break;
            }
            if (this.mightBeEol2CharSequence(c1)) {
                int c2;
                if (block) {
                    c2 = this.unicodeDecoder.peek(false);
                } else {
                    if (this.unicodeDecoder.available() <= 0) break;
                    c2 = this.unicodeDecoder.peek(false);
                }
                if (this.isEol1CharSequence(c1, c2)) {
                    sawEol = true;
                    break;
                }
                if (this.isEol2CharSequence(c1, c2)) {
                    sawEol = true;
                    this.unicodeDecoder.peek(true);
                    break;
                }
            }
            sb.append(c1);
        }
        if (this.eofSeen && sb.length() == 0) {
            return -1;
        }
        if (block) {
            return 0;
        }
        if (sawEol || this.eofSeen) {
            this.unicodeDecoder.mark(0);
            return 0;
        }
        this.unicodeDecoder.reset();
        return -2;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.isEolChar(c)) {
            return 10;
        }
        if (this.mightBeEol2CharSequence(c)) {
            int c2 = this.unicodeDecoder.peek(false);
            boolean bl = this.eofSeen = c2 == -1;
            if (this.isEol1CharSequence(c, c2)) {
                return 10;
            }
            if (this.isEol2CharSequence(c, c2)) {
                this.unicodeDecoder.peek(true);
                return 10;
            }
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesRead = super.read(cbuf, off, len);
        if (bytesRead < 1 || this.translation == 1 || this.translation == 2) {
            this.eofSeen = bytesRead == -1;
            return bytesRead;
        }
        if (this.translation == 3) {
            int i = off;
            while (i < off + bytesRead) {
                if (cbuf[i] == '\r') {
                    cbuf[i] = 10;
                }
                ++i;
            }
            return bytesRead;
        }
        int i = 0;
        int newCount = 0;
        boolean collapsedTwoCharEol = false;
        while (i < bytesRead - 1) {
            if (this.isEol1CharSequence(cbuf[i + off], cbuf[i + off + 1])) {
                cbuf[newCount + off] = 10;
                ++newCount;
                ++i;
                continue;
            }
            if (this.isEol2CharSequence(cbuf[i + off], cbuf[i + off + 1])) {
                cbuf[newCount + off] = 10;
                ++newCount;
                i += 2;
                collapsedTwoCharEol = true;
                continue;
            }
            if (collapsedTwoCharEol) {
                cbuf[newCount + off] = cbuf[i + off];
            }
            ++newCount;
            ++i;
        }
        if (i >= bytesRead) {
            return newCount;
        }
        char lastChar = cbuf[off + bytesRead - 1];
        if (this.isEolChar(lastChar)) {
            cbuf[newCount + off] = 10;
            return ++newCount;
        }
        if (this.mightBeEol2CharSequence(lastChar)) {
            int c2 = this.unicodeDecoder.peek(false);
            boolean bl = this.eofSeen = c2 == -1;
            if (this.isEol1CharSequence(lastChar, c2)) {
                cbuf[newCount + off] = 10;
                return ++newCount;
            }
            if (this.isEol2CharSequence(lastChar, c2)) {
                this.unicodeDecoder.peek(true);
                cbuf[newCount + off] = 10;
                return ++newCount;
            }
        }
        cbuf[newCount + off] = lastChar;
        return ++newCount;
    }

    private final boolean isEolChar(int c) {
        switch (this.translation) {
            case 0: 
            case 1: 
            case 2: {
                return c == 10;
            }
            case 3: {
                return c == 13;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    private final boolean mightBeEol2CharSequence(int c) {
        return c == 13 && (this.translation == 0 || this.translation == 4);
    }

    private final boolean isEol1CharSequence(int c1, int c2) {
        if (this.isEolChar(c1)) {
            return true;
        }
        return this.translation == 0 && c1 == 13 && c2 != 10 && c2 != -1;
    }

    private final boolean isEol2CharSequence(int c1, int c2) {
        switch (this.translation) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return c1 == 13 && c2 == 10;
            }
            case 0: {
                return c1 == 13 && (c2 == 10 || c2 == -1);
            }
        }
        return false;
    }
}

