/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

class EolOutputFilter
extends FilterWriter {
    private int translation;

    EolOutputFilter(Writer out, int translation) {
        super(out);
        this.setTranslation(translation);
    }

    void setTranslation(int translation) {
        this.translation = translation;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.translation == 2 || this.translation == 1) {
            this.out.write(cbuf, off, len);
            return;
        }
        if (this.translation == 3) {
            int i = off;
            while (i < off + len) {
                if (cbuf[i] == '\n') {
                    cbuf[i] = 13;
                }
                ++i;
            }
            this.out.write(cbuf, off, len);
            return;
        }
        if (this.translation == 4) {
            int eolCnt = 0;
            int i = off;
            while (i < off + len) {
                if (cbuf[i] == '\n') {
                    ++eolCnt;
                }
                ++i;
            }
            if (eolCnt == 0) {
                this.out.write(cbuf, off, len);
            } else {
                char[] tcbuf = new char[len + eolCnt];
                int i2 = off;
                int j = 0;
                while (i2 < off + len) {
                    if (cbuf[i2] == '\n') {
                        tcbuf[j++] = 13;
                    }
                    tcbuf[j] = cbuf[i2];
                    ++i2;
                    ++j;
                }
                this.out.write(tcbuf, 0, len + eolCnt);
            }
        }
    }
}

