/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.channel.Channel;

public class Fcopy {
    Channel source;
    Channel destination;
    long size;
    long bytesWritten = 0L;
    String callback;
    boolean sourceBlocking;
    boolean destinationBlocking;
    int sourceBuffering;
    int destinationBuffering;
    boolean transferBytes;
    boolean doUtf8OutputEncoding = false;
    boolean doUtf8InputEncoding = false;
    char[] cbuf = null;
    byte[] bbuf = null;
    Thread backgroundCopy = null;
    Interp interp;

    public Fcopy(Interp interp, Channel source, Channel destination, long size, String callback) throws TclException {
        source.checkRead(interp);
        destination.checkWrite(interp);
        this.source = source;
        this.destination = destination;
        this.size = size;
        this.callback = callback;
        this.interp = interp;
    }

    public long getWrittenByteCount() {
        return this.bytesWritten;
    }

    public long start() throws TclException {
        if (this.callback == null) {
            this.getChannelOwnership(Thread.currentThread().getId());
            try {
                try {
                    this.setup();
                    this.doCopy();
                }
                catch (IOException e) {
                    throw new TclException(this.interp, e.getMessage());
                }
            }
            finally {
                this.tearDown();
            }
            return this.bytesWritten;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String errormsg;
                block6: {
                    errormsg = null;
                    try {
                        try {
                            Fcopy.this.setup();
                            Fcopy.this.doCopy();
                        }
                        catch (Exception e) {
                            errormsg = e.getMessage();
                            Fcopy.this.tearDown();
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        Fcopy.this.tearDown();
                        throw throwable;
                    }
                    Fcopy.this.tearDown();
                }
                if (Fcopy.this.source.isClosed() || Fcopy.this.destination.isClosed()) {
                    return;
                }
                final String callbackWithArgs = String.valueOf(Fcopy.this.callback) + " " + Fcopy.this.bytesWritten + (errormsg == null ? "" : " {" + errormsg + "}");
                TclEvent event = new TclEvent(){

                    @Override
                    public int processEvent(int flags) {
                        try {
                            (this).Fcopy.this.interp.eval(callbackWithArgs);
                        }
                        catch (TclException tclException) {
                            (this).Fcopy.this.interp.addErrorInfo("\n    (\"fcopy\" script)");
                            (this).Fcopy.this.interp.backgroundError();
                        }
                        return 1;
                    }
                };
                Fcopy.this.interp.getNotifier().queueEvent(event, 0);
            }
        };
        this.backgroundCopy = new Thread(r);
        this.getChannelOwnership(this.backgroundCopy.getId());
        this.backgroundCopy.setDaemon(true);
        this.backgroundCopy.setName("Fcopy (" + this.interp.toString() + "): " + this.source.getChanName() + " -> " + this.destination.getChanName());
        this.backgroundCopy.start();
        return 0L;
    }

    private void getChannelOwnership(long id) throws TclException {
        if (!this.source.setOwnership(true, 1, id)) {
            throw new TclException(this.interp, "channel \"" + this.source.getChanName() + "\" is busy");
        }
        if (!this.destination.setOwnership(true, 2, id)) {
            this.source.setOwnership(false, 1);
            throw new TclException(this.interp, "channel \"" + this.destination.getChanName() + "\" is busy");
        }
    }

    private void setup() throws TclException, IOException {
        this.source.initInput();
        this.destination.initOutput();
        this.sourceBlocking = this.source.getBlocking();
        this.destinationBlocking = this.destination.getBlocking();
        this.source.setBlocking(true);
        this.destination.setBlocking(true);
        this.sourceBuffering = this.source.getBuffering();
        this.destinationBuffering = this.destination.getBuffering();
        if (this.sourceBuffering == 0) {
            this.source.setBuffering(2);
        }
        if (this.destinationBuffering == 0) {
            this.destination.setBuffering(2);
        }
        String srcEncoding = this.source.getEncoding() == null ? "binary" : this.source.getEncoding();
        String dstEncoding = this.destination.getEncoding() == null ? "binary" : this.destination.getEncoding();
        boolean bl = this.transferBytes = srcEncoding.equals(dstEncoding) && this.source.getInputTranslation() == this.destination.getOutputTranslation();
        if (this.source.getEncoding() != null && this.destination.getEncoding() == null) {
            this.doUtf8OutputEncoding = true;
            this.destination.setEncoding("utf-8");
        } else if (this.source.getEncoding() == null && this.destination.getEncoding() != null) {
            this.doUtf8InputEncoding = true;
            this.source.setEncoding("utf-8");
        }
        int bufsize = this.source.getBufferSize();
        if (bufsize == 0 || this.sourceBuffering == 2) {
            bufsize = 1;
        }
        if (this.transferBytes) {
            this.bbuf = new byte[bufsize];
        } else {
            this.cbuf = new char[bufsize];
        }
    }

    private void tearDown() {
        this.source.setBlocking(this.sourceBlocking);
        this.destination.setBlocking(this.destinationBlocking);
        this.source.setBuffering(this.sourceBuffering);
        this.destination.setBuffering(this.destinationBuffering);
        this.source.setOwnership(false, 1);
        this.destination.setOwnership(false, 2);
        if (this.doUtf8OutputEncoding) {
            this.destination.setEncoding(null);
        }
        if (this.doUtf8InputEncoding) {
            this.source.setEncoding(null);
        }
    }

    private long doCopy() throws IOException {
        long startCount = this.destination.outputBuffer.getReceivedByteCount();
        while (!this.source.eof()) {
            int transferSize;
            int n = transferSize = this.transferBytes ? this.bbuf.length : this.cbuf.length;
            if (this.size >= 0L) {
                long remaining = this.size - this.bytesWritten;
                if (remaining <= 0L) break;
                if (!this.transferBytes && remaining <= 16L) {
                    remaining = 1L;
                }
                int n2 = transferSize = remaining < (long)transferSize ? (int)remaining : transferSize;
            }
            if (this.source.isClosed()) break;
            int cnt = this.transferBytes ? this.source.finalInputStream.read(this.bbuf, 0, transferSize) : this.source.finalReader.read(this.cbuf, 0, transferSize);
            if (cnt == -1) {
                this.source.eofSeen = true;
                break;
            }
            if (this.destination.isClosed()) break;
            if (this.transferBytes) {
                this.destination.firstOutputStream.write(this.bbuf, 0, cnt);
            } else {
                this.destination.firstWriter.write(this.cbuf, 0, cnt);
            }
            this.bytesWritten = this.destination.outputBuffer.getReceivedByteCount() - startCount;
        }
        if (!this.destination.isClosed()) {
            this.destination.firstWriter.flush();
        }
        return this.bytesWritten;
    }
}

