/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.SeekableChannel;

public class FileChannel
extends SeekableChannel {
    private RandomAccessFile file = null;

    public String open(Interp interp, String fileName, int modeFlags) throws IOException, TclException {
        boolean appendModeCreate;
        this.mode = modeFlags;
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        boolean bl = appendModeCreate = (modeFlags & 8) != 0 && !fileObj.exists();
        if ((modeFlags & 0x10) != 0 && (modeFlags & 0x20) != 0 && fileObj.exists()) {
            throw new TclException(interp, "couldn't open \"" + fileName + "\": file exists");
        }
        if ((modeFlags & 0x10) != 0 && !fileObj.exists()) {
            this.file = new RandomAccessFile(fileObj, "rw");
            this.file.close();
        }
        if ((modeFlags & 4) != 0) {
            if (!appendModeCreate) {
                this.checkFileExists(interp, fileObj);
                this.checkReadWritePerm(interp, fileObj, 0);
            }
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else if ((modeFlags & 1) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, -1);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "r");
        } else if ((modeFlags & 2) != 0) {
            if (!appendModeCreate) {
                this.checkFileExists(interp, fileObj);
                this.checkReadWritePerm(interp, fileObj, 1);
            }
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            if (!appendModeCreate && !fileObj.canRead()) {
                throw new TclException(interp, "Java IO limitation: Cannot open a file that has only write permissions set.");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else {
            throw new TclRuntimeError("FileChannel.java: invalid mode value");
        }
        if ((modeFlags & 8) != 0) {
            this.file.seek(this.file.length());
        }
        if ((modeFlags & 0x40) != 0) {
            java.nio.channels.FileChannel chan = this.file.getChannel();
            chan.truncate(0L);
        }
        String fName = TclIO.getNextDescriptor(interp, "file");
        this.setChanName(fName);
        return fName;
    }

    @Override
    void implClose() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.close(): null file object");
        }
        this.file.close();
        this.file = null;
    }

    @Override
    void sync() throws SyncFailedException, IOException {
        if (this.file != null) {
            this.file.getChannel().force(this.closed);
        }
    }

    @Override
    void implSeek(long offset) throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
        this.file.seek(offset);
    }

    @Override
    long implTell() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.implTell(): null file object");
        }
        return this.file.getFilePointer();
    }

    @Override
    long getMaxSeek() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.getMaxSeek(): null file object");
        }
        return this.file.length();
    }

    private void checkFileExists(Interp interp, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    private void checkReadWritePerm(Interp interp, File fileObj, int inmode) throws TclException {
        boolean error = false;
        if (inmode <= 0 && !fileObj.canRead()) {
            error = true;
        }
        if (inmode >= 0 && !fileObj.canWrite()) {
            error = true;
        }
        if (error) {
            throw new TclPosixException(interp, 13, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    @Override
    String getChanType() {
        return "file";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.file == null) {
            throw new IOException("file has not been opened, or has been closed");
        }
        return new FileInputStream(this.file.getFD());
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                if (FileChannel.this.file != null) {
                    FileChannel.this.file.write(b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (FileChannel.this.file != null) {
                    FileChannel.this.file.write(b, off, len);
                }
            }
        };
    }
}

