/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TimerHandler;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEventScript;
import tcl.lang.channel.StdChannel;

public class FileEvent
extends TclEvent {
    private static final long FILE_EVENT_DELAY_MS = 30L;
    public static final int READABLE = 0;
    public static final int WRITABLE = 1;
    static boolean stdinUsedForCommandInput = false;
    Interp interp;
    int type;
    Channel channel;

    private FileEvent(Interp interp, Channel channel, int type) {
        this.interp = interp;
        this.channel = channel;
        this.type = type;
    }

    public static void queueFileEvent(Interp interp, Channel channel, int type) {
        Notifier notifier = interp.getNotifier();
        if (notifier != null) {
            FileEvent ev = new FileEvent(interp, channel, type);
            notifier.queueEvent(ev, 0);
        }
    }

    private void requeue() {
        FileEvent.queueFileEvent(this.interp, this.channel, this.type);
    }

    private void requeueLater() {
        new FileEventTimer(30L, this.interp, this.channel, this.type);
    }

    void dispose() {
        FileEventScript.dispose(this.interp, this.channel, this.type);
    }

    @Override
    public int processEvent(int flags) {
        FileEventScript script = FileEventScript.find(this.interp, this.channel, this.type);
        if (script == null) {
            return 1;
        }
        if (this.channel instanceof StdChannel && "stdin".equals(this.channel.getChanName()) && FileEvent.isStdinUsedForCommandInput()) {
            this.requeue();
            return 1;
        }
        if (this.type == 0 && !this.channel.isReadable()) {
            try {
                this.channel.fillInputBuffer();
                this.requeueLater();
            }
            catch (IOException e) {
                new TclException(this.interp, e.getMessage());
                this.interp.backgroundError();
                this.dispose();
            }
            return 1;
        }
        if (this.type == 1 && !this.channel.isWritable()) {
            this.requeueLater();
            return 1;
        }
        try {
            this.interp.eval(script.getScript(), 1);
        }
        catch (TclException tclException) {
            this.interp.backgroundError();
            this.dispose();
            return 1;
        }
        this.requeue();
        return 1;
    }

    public static synchronized boolean isStdinUsedForCommandInput() {
        return stdinUsedForCommandInput;
    }

    public static synchronized boolean setStdinUsedForCommandInput(boolean stdinUsedForCommandInput) {
        boolean rv = FileEvent.stdinUsedForCommandInput;
        FileEvent.stdinUsedForCommandInput = stdinUsedForCommandInput;
        return rv;
    }

    class FileEventTimer
    extends TimerHandler {
        private Interp interp;
        private Channel channel;
        private int type;

        public FileEventTimer(long milliseconds, Interp interp, Channel channel, int type) {
            super(interp.getNotifier(), milliseconds);
            this.interp = interp;
            this.channel = channel;
            this.type = type;
        }

        @Override
        public void processTimerEvent() {
            FileEvent.queueFileEvent(this.interp, this.channel, this.type);
        }
    }
}

