/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import tcl.lang.AssocData;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEvent;

public class FileEventScript
implements AssocData {
    TclObject script;

    private FileEventScript(TclObject script) {
        this.script = script;
        this.script.preserve();
    }

    public static void register(Interp interp, Channel channel, int type, TclObject script) {
        FileEventScript fes = new FileEventScript(script);
        interp.setAssocData(FileEventScript.getName(channel, type), fes);
        FileEvent.queueFileEvent(interp, channel, type);
    }

    public TclObject getScript() {
        return this.script;
    }

    @Override
    public void disposeAssocData(Interp interp) {
        this.script.release();
    }

    private static String getName(Channel channel, int type) {
        String channelName = channel.getChanName();
        return String.valueOf(channelName) + (type == 0 ? " readable " : " writeable ") + FileEventScript.class.getName();
    }

    public static FileEventScript find(Interp interp, Channel channel, int type) {
        String name = FileEventScript.getName(channel, type);
        AssocData data = interp.getAssocData(name);
        if (data != null && data instanceof FileEventScript) {
            return (FileEventScript)data;
        }
        return null;
    }

    public static void dispose(Interp interp, Channel channel, int type) {
        String name = FileEventScript.getName(channel, type);
        interp.deleteAssocData(name);
    }
}

