/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import tcl.lang.TclIO;
import tcl.lang.channel.Channel;
import tcl.lang.channel.EofInputFilter;

class InputBuffer
extends FilterInputStream {
    private byte[] buffer = null;
    private int requestedBufferSize;
    private volatile int buffering;
    private int position = 0;
    private int limit = 0;
    boolean eofSeen = false;
    private static final int eolChar = TclIO.TRANS_PLATFORM == 3 ? 13 : 10;
    private volatile boolean blockingMode;
    private boolean lastReadWouldHaveBlocked = false;
    private volatile boolean refillInProgress = false;
    private EofInputFilter eofInputFilter = null;
    boolean requestRefill = false;
    Refiller refiller = null;
    boolean closed = false;

    InputBuffer(EofInputFilter in, int size, int buffering, boolean blockingMode, Channel channel) {
        super(in);
        this.eofInputFilter = in;
        this.setBuffering(buffering);
        this.setBlockingMode(true);
        this.setBufferSize(size);
        this.setBlockingMode(blockingMode);
        this.refiller = new Refiller();
        this.resizeBuffer();
        this.refiller.setDaemon(true);
        this.refiller.setName("InputBuffer Refiller: " + channel.getChanName());
        this.refiller.start();
    }

    void setBlockingMode(boolean blockingMode) {
        this.blockingMode = blockingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeBuffer() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            int size;
            if (this.refillInProgress) {
                return;
            }
            int n = size = this.buffering == 2 ? 1 : this.requestedBufferSize;
            if (this.remaining() > 0 || this.buffer != null && this.buffer.length == size) {
                return;
            }
            this.buffer = new byte[size];
            this.limit = 0;
            this.position = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBufferSize(int size) {
        if (this.refiller == null) {
            this.requestedBufferSize = size;
        } else {
            Object object = this.getRefillerNotifier();
            synchronized (object) {
                this.requestedBufferSize = size;
                this.resizeBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBuffering(int buffering) {
        if (this.refiller == null) {
            this.buffering = buffering;
        } else {
            Object object = this.getRefillerNotifier();
            synchronized (object) {
                this.buffering = buffering;
                this.resizeBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void seekReset() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            this.position = 0;
            this.limit = 0;
            this.cancelEof();
        }
    }

    boolean lastReadWouldHaveBlocked() {
        return this.lastReadWouldHaveBlocked;
    }

    boolean eof() {
        return this.eofSeen;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.refiller != null) {
            this.refiller.interrupt();
        }
        super.close();
    }

    void cancelEof() {
        this.eofSeen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int remaining() {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            return this.limit - this.position;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isRefillInProgress()) {
            return 0;
        }
        return this.remaining() + this.eofInputFilter.available();
    }

    final Object getRefillerNotifier() {
        return this.refiller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isRefillInProgress() throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            block4: {
                if (!this.requestRefill && !this.refillInProgress) break block4;
                return true;
            }
            this.refiller.throwIOExceptionIfCaught();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRefill(boolean wait) throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            this.requestRefill = true;
            this.refiller.notifyAll();
            if (wait) {
                while (this.isRefillInProgress()) {
                    try {
                        this.getRefillerNotifier().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            block10: {
                while (true) {
                    if (!this.isRefillInProgress()) {
                        if (this.remaining() != 0) break;
                        this.requestRefill(true);
                        break block10;
                    }
                    try {
                        this.getRefillerNotifier().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.refiller.throwIOExceptionIfCaught();
            }
            if (this.eofSeen) {
                return -1;
            }
            if (this.buffer.length != 0) {
                return this.buffer[this.position++];
            }
            int c = super.read();
            if (c == -1) {
                this.eofSeen = true;
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.getRefillerNotifier();
        synchronized (object) {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            this.lastReadWouldHaveBlocked = false;
                            if (!this.refillInProgress) break block11;
                            this.lastReadWouldHaveBlocked = true;
                            return 0;
                        }
                        if (!this.eofSeen) break block12;
                        return -1;
                    }
                    this.refiller.throwIOExceptionIfCaught();
                    if (this.remaining() != 0) break block13;
                    if (this.buffering != 1 && super.available() > 0) {
                        int cnt;
                        int directRequestSize = Math.min(len, super.available());
                        if (this.requestedBufferSize > 0 && directRequestSize > this.requestedBufferSize) {
                            directRequestSize = this.requestedBufferSize;
                        }
                        if ((cnt = super.read(b, off, directRequestSize)) == -1) {
                            this.eofSeen = true;
                        }
                        this.lastReadWouldHaveBlocked = !this.blockingMode && cnt < len && !this.eofSeen;
                        return cnt;
                    }
                    if (this.blockingMode) {
                        this.requestRefill(true);
                        break block13;
                    }
                    this.requestRefill(false);
                    this.lastReadWouldHaveBlocked = true;
                    return 0;
                }
                if (this.remaining() != 0 || !this.eofSeen) break block14;
                return -1;
            }
            int cnt = Math.min(len, this.remaining());
            System.arraycopy(this.buffer, this.position, b, off, cnt);
            this.position += cnt;
            this.lastReadWouldHaveBlocked = !this.blockingMode && cnt < len && !this.eofSeen;
            return cnt;
        }
    }

    private class Refiller
    extends Thread {
        IOException ioException = null;

        private Refiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void throwIOExceptionIfCaught() throws IOException {
            Object object = InputBuffer.this.getRefillerNotifier();
            synchronized (object) {
                if (this.ioException != null) {
                    IOException e = this.ioException;
                    this.ioException = null;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refill() throws IOException {
            if (InputBuffer.this.eofSeen) {
                return;
            }
            if (InputBuffer.this.remaining() > 0) {
                return;
            }
            if (InputBuffer.this.buffering == 0 || InputBuffer.this.buffering == 2) {
                int readSize = Math.min(InputBuffer.this.buffer.length, InputBuffer.this.eofInputFilter.available());
                if (readSize < 1) {
                    readSize = 1;
                }
                int cnt = InputBuffer.this.eofInputFilter.read(InputBuffer.this.buffer, 0, readSize);
                Object object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    if (cnt == -1) {
                        InputBuffer.this.eofSeen = true;
                        InputBuffer.this.position = 0;
                        InputBuffer.this.limit = 0;
                        return;
                    }
                    InputBuffer.this.position = 0;
                    InputBuffer.this.limit = cnt;
                    return;
                }
            }
            Object readSize = InputBuffer.this.getRefillerNotifier();
            synchronized (readSize) {
                InputBuffer.this.limit = 0;
                InputBuffer.this.position = 0;
            }
            while (true) {
                int c = InputBuffer.this.eofInputFilter.read();
                Object object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    if (c == -1) {
                        if (InputBuffer.this.limit == 0) {
                            InputBuffer.this.eofSeen = true;
                        }
                        return;
                    }
                    InputBuffer.this.buffer[InputBuffer.this.limit++] = (byte)(c & 0xFF);
                    if (c == eolChar || InputBuffer.this.limit >= InputBuffer.this.buffer.length) {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.ioException = null;
            while (!InputBuffer.this.closed) {
                Object object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    while (!InputBuffer.this.closed && !InputBuffer.this.requestRefill) {
                        try {
                            InputBuffer.this.getRefillerNotifier().wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    this.ioException = null;
                    InputBuffer.this.resizeBuffer();
                    InputBuffer.this.refillInProgress = true;
                }
                try {
                    this.refill();
                }
                catch (IOException e) {
                    Object object2 = InputBuffer.this.getRefillerNotifier();
                    synchronized (object2) {
                        this.ioException = e;
                    }
                }
                object = InputBuffer.this.getRefillerNotifier();
                synchronized (object) {
                    InputBuffer.this.refillInProgress = false;
                    InputBuffer.this.requestRefill = false;
                    InputBuffer.this.getRefillerNotifier().notifyAll();
                }
            }
        }
    }
}

