/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MarkableInputStream
extends FilterInputStream {
    protected boolean marked = false;
    private byte[] buf = new byte[0];
    int readPos = 0;
    int writePos = 0;
    int markPos = 0;
    static final int GrowSize = 512;

    public MarkableInputStream(InputStream in) {
        super(in);
    }

    private void saveBytes(byte[] b, int off, int len) {
        int additionalSpaceRequired = len - (this.buf.length - this.writePos);
        if (additionalSpaceRequired > 0) {
            int newSize = (additionalSpaceRequired / 512 + 1) * 512 + this.buf.length;
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.writePos);
            this.buf = newBuf;
        }
        System.arraycopy(b, off, this.buf, this.writePos, len);
        this.writePos += len;
        this.readPos += len;
    }

    private void trimBuf() {
        if (!this.marked && this.readPos == this.writePos && this.buf.length > 0) {
            this.buf = new byte[0];
            this.readPos = 0;
            this.writePos = 0;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marked = readlimit > 0;
        this.trimBuf();
        this.markPos = this.readPos;
    }

    public void seekReset() {
        this.readPos = 0;
        this.writePos = 0;
        this.mark(0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public void unread(int c) {
        if (c != -1) {
            byte[] b = new byte[]{(byte)(c & 0xFF)};
            if (!this.marked) {
                this.saveBytes(b, 0, 1);
            }
            --this.readPos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readPos == this.writePos) {
            int c = super.read();
            if (this.marked && c != -1) {
                byte[] b = new byte[]{(byte)(c & 0xFF)};
                this.saveBytes(b, 0, 1);
            }
            return c;
        }
        byte c = this.buf[this.readPos++];
        this.trimBuf();
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int cnt;
        int nBytes = 0;
        int remaining = this.writePos - this.readPos;
        if (remaining > 0) {
            cnt = Math.min(remaining, len);
            System.arraycopy(this.buf, this.readPos, b, off, cnt);
            this.readPos += cnt;
            nBytes = cnt;
            off += cnt;
            len -= cnt;
        }
        this.trimBuf();
        if (len > 0) {
            cnt = super.read(b, off, len);
            if (cnt == -1 && nBytes == 0) {
                nBytes = -1;
            } else {
                if (this.writePos == this.readPos && this.marked) {
                    this.saveBytes(b, off, cnt);
                }
                nBytes += cnt;
            }
        }
        return nBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("Stream was not marked prior to reset()");
        }
        this.readPos = this.markPos;
    }

    @Override
    public int available() throws IOException {
        return this.writePos - this.readPos + super.available();
    }

    @Override
    public void close() throws IOException {
        this.seekReset();
        super.close();
    }
}

