/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import tcl.lang.channel.Channel;
import tcl.lang.channel.SeekableChannel;

class NonBlockingOutputStream
extends FilterOutputStream
implements Runnable {
    private boolean blocking;
    private ConcurrentLinkedQueue<Transaction> queue;
    private Thread bkgndWriter = null;
    private Object notifier = new Object();
    private Channel channel = null;
    private volatile IOException ioException = null;
    private boolean closed = false;

    NonBlockingOutputStream(OutputStream out, boolean blocking, Channel channel) {
        super(out);
        this.setBlocking(blocking);
        this.channel = channel;
        this.queue = new ConcurrentLinkedQueue();
        this.bkgndWriter = new Thread(this);
        this.bkgndWriter.setDaemon(true);
        this.bkgndWriter.setName("NonBlockingOutputStream: " + channel.getChanName());
        this.bkgndWriter.start();
    }

    void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(1));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            if (this.blocking) {
                this.queue.offer(new Transaction(b, off, len));
            } else {
                byte[] copy = new byte[len];
                System.arraycopy(b, off, copy, 0, len);
                this.queue.offer(new Transaction(copy, 0, len));
            }
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAssumingExclusiveBufferUse(byte[] b, int off, int len) throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(b, off, len));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.writeAssumingExclusiveBufferUse(buf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.notifier;
        synchronized (object) {
            this.checkClosed();
            this.queue.offer(new Transaction(2));
            this.notifier.notifyAll();
        }
        if (this.blocking) {
            this.waitForEmptyQueue();
        }
        this.throwExceptionIfCaught();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is already closed");
        }
    }

    private void throwExceptionIfCaught() throws IOException {
        if (this.ioException != null) {
            IOException e = this.ioException;
            this.ioException = null;
            throw e;
        }
    }

    boolean isQueueEmpty() {
        return this.queue.peek() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEmptyQueue() {
        while (true) {
            Object object = this.notifier;
            synchronized (object) {
                if (this.isQueueEmpty()) {
                    return;
                }
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Transaction transaction;
            Object object = this.notifier;
            synchronized (object) {
                transaction = this.queue.peek();
                if (transaction == null) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.closed = true;
                        return;
                    }
                }
            }
            try {
                transaction.perform();
            }
            catch (IOException e) {
                this.ioException = e;
            }
            object = this.notifier;
            synchronized (object) {
                this.queue.poll();
                if (transaction.type == 2) {
                    this.closed = true;
                    this.channel = null;
                    this.queue.clear();
                    this.notifier.notifyAll();
                    return;
                }
                if (this.isQueueEmpty()) {
                    this.notifier.notifyAll();
                }
            }
        }
    }

    private class Transaction {
        byte[] b;
        int off;
        int len;
        int type;
        static final int Write = 0;
        static final int Flush = 1;
        static final int Close = 2;

        Transaction(int type) {
            this.type = type;
        }

        Transaction(byte[] b, int off, int len) {
            this.b = b;
            this.off = off;
            this.len = len;
            this.type = 0;
        }

        void perform() throws IOException {
            if (NonBlockingOutputStream.this.channel instanceof SeekableChannel && (NonBlockingOutputStream.this.channel.mode & 8) != 0) {
                ((SeekableChannel)NonBlockingOutputStream.this.channel).prepareForAppendWrite();
            }
            switch (this.type) {
                case 0: {
                    NonBlockingOutputStream.this.out.write(this.b, this.off, this.len);
                    break;
                }
                case 1: {
                    NonBlockingOutputStream.this.out.flush();
                    NonBlockingOutputStream.this.channel.sync();
                    break;
                }
                case 2: {
                    NonBlockingOutputStream.this.out.close();
                    NonBlockingOutputStream.this.channel.implClose();
                }
            }
        }
    }
}

