/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.FilterOutputStream;
import java.io.IOException;
import tcl.lang.channel.NonBlockingOutputStream;

class OutputBuffer
extends FilterOutputStream {
    private int requestedSize = 0;
    private int bufferingMode;
    private byte[] buffer = null;
    private int position = 0;
    private NonBlockingOutputStream nonBlockingOutputStream = null;
    private long receivedByteCount = 0L;

    OutputBuffer(NonBlockingOutputStream out, int size, int bufferingMode) {
        super(out);
        this.nonBlockingOutputStream = out;
        this.setBufferSize(size);
        this.setBuffering(bufferingMode);
    }

    void setBuffering(int bufferingMode) {
        this.bufferingMode = bufferingMode;
        this.resizeBuffer();
    }

    void setBufferSize(int bufferSize) {
        this.requestedSize = bufferSize;
        this.resizeBuffer();
    }

    private void resizeBuffer() {
        if (this.position != 0) {
            return;
        }
        int size = this.bufferingMode == 2 ? 0 : this.requestedSize;
        this.buffer = new byte[size];
    }

    int getBufferedByteCount() {
        return this.position;
    }

    long getReceivedByteCount() {
        return this.receivedByteCount;
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.nonBlockingOutputStream.writeAssumingExclusiveBufferUse(this.buffer, 0, this.position);
        }
        this.nonBlockingOutputStream.flush();
        this.position = 0;
        this.resizeBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int nChunks;
        this.receivedByteCount += (long)len;
        if (this.bufferingMode == 2 && this.buffer.length > 0) {
            this.flush();
        }
        if (this.buffer.length == 0) {
            this.nonBlockingOutputStream.write(b, off, len);
            this.nonBlockingOutputStream.flush();
            return;
        }
        int cnt = Math.min(len, this.buffer.length - this.position);
        System.arraycopy(b, off, this.buffer, this.position, cnt);
        this.position += cnt;
        len -= cnt;
        off += cnt;
        if (this.position == this.buffer.length) {
            this.flush();
        }
        if (this.buffer.length > 0 && (nChunks = len / this.buffer.length) > 0) {
            cnt = nChunks * this.buffer.length;
            this.nonBlockingOutputStream.write(b, off, cnt);
            this.nonBlockingOutputStream.flush();
            len -= cnt;
            off += cnt;
        }
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
        if (this.position == this.buffer.length) {
            this.flush();
        }
        if (this.bufferingMode == 1) {
            int i = this.position - 1;
            while (i >= 0) {
                if (this.buffer[i] == 10 || this.buffer[i] == 13) {
                    this.flush();
                    break;
                }
                --i;
            }
        }
    }
}

