/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tcl.lang.Interp;
import tcl.lang.Pipeline;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.TclByteArrayChannel;
import tcl.lang.process.Redirect;

public class PipelineChannel
extends Channel {
    private Pipeline pipeline;
    private TclByteArrayChannel stderr;
    Interp interp = null;

    public String open(Interp interp, String execString, int modeFlags) throws IOException, TclException {
        TclObject[] objv;
        this.interp = interp;
        if (execString.startsWith("|")) {
            execString = execString.substring(1);
        }
        if ((objv = TclList.getElements(interp, TclString.newInstance(execString))).length == 0) {
            throw new TclException(interp, "illegal use of | or |& in command");
        }
        this.pipeline = new Pipeline(interp, objv, 0);
        this.stderr = new TclByteArrayChannel(interp);
        if (modeFlags == 1) {
            this.mode = 1;
            if (this.pipeline.getStdoutRedirect() != null) {
                throw new TclException(interp, "can't read output from command: standard output was redirected");
            }
            this.pipeline.setStdoutRedirect(Redirect.stream());
            if (this.pipeline.getStdinRedirect() == null) {
                this.pipeline.setStdinRedirect(Redirect.inherit());
            }
        } else if (modeFlags == 2) {
            this.mode = 2;
            if (this.pipeline.getStdinRedirect() != null) {
                throw new TclException(interp, "can't write input to command: standard input was redirected");
            }
            this.pipeline.setStdinRedirect(Redirect.stream());
            this.setBuffering(2);
            if (this.pipeline.getStdoutRedirect() == null) {
                this.pipeline.setStdoutRedirect(Redirect.inherit());
            }
        } else if (modeFlags == 4) {
            this.mode = 4;
            boolean setRedir = false;
            if (this.pipeline.getStdoutRedirect() == null) {
                setRedir = true;
                this.pipeline.setStdoutRedirect(Redirect.stream());
            } else {
                this.mode = 2;
            }
            if (this.pipeline.getStdinRedirect() == null) {
                setRedir = true;
                this.pipeline.setStdinRedirect(Redirect.stream());
            } else {
                this.mode = 1;
            }
            if (!setRedir) {
                throw new TclException(interp, "can't read/write output/input to command: standard output/input was redirected");
            }
        }
        if (this.pipeline.getStderrRedirect() == null) {
            this.pipeline.setStderrRedirect(new Redirect(this.stderr, true));
        }
        this.pipeline.setExecInBackground(true);
        this.pipeline.exec();
        this.setChanName(TclIO.getNextDescriptor(interp, this.getChanType()));
        return this.getChanName();
    }

    public String getStderrOutput() {
        if (this.stderr != null) {
            return this.stderr.getTclByteArray().toString();
        }
        return "";
    }

    @Override
    String getChanType() {
        return "pipeline";
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.pipeline.getStdoutRedirect().getType() == Redirect.Type.STREAM) {
            return this.pipeline.getStdoutRedirect().getInputStream();
        }
        throw new IOException("should not call getInputStream()");
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (this.pipeline.getStdinRedirect().getType() == Redirect.Type.STREAM) {
            return this.pipeline.getStdinRedirect().getOutputStream();
        }
        throw new IOException("should not call getOutputStream()");
    }

    @Override
    void implClose() throws IOException {
        IOException ex = null;
        if (this.pipeline.getStdinRedirect().getType() == Redirect.Type.STREAM) {
            try {
                this.pipeline.getStdinRedirect().getOutputStream().close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (this.pipeline.getStdoutRedirect().getType() == Redirect.Type.STREAM) {
            try {
                this.pipeline.getStdoutRedirect().getInputStream().close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        try {
            this.pipeline.waitForExitAndCleanup(false);
        }
        catch (TclException e) {
            throw new IOException(e.getMessage());
        }
        if (ex != null) {
            throw ex;
        }
    }
}

