/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public class ResourceChannel
extends Channel {
    private InputStream file = null;

    public String open(Interp interp, String fileName, int modeFlags) throws IOException, TclException {
        this.mode = modeFlags;
        if (modeFlags != 1) {
            throw new TclException(interp, "invalid mode(s), only RDONLY mode allowed for resource:");
        }
        try {
            this.file = interp.getClassLoader().getResourceAsStream(fileName);
        }
        catch (NullPointerException nullPointerException) {
            throw new TclPosixException(interp, 2, true, "ResourceChannel.open: no file specified for \"resource:\" ");
        }
        if (this.file == null) {
            throw new TclPosixException(interp, 2, true, "ResourceChannel.open: cannot find \"resource:" + fileName + "\"");
        }
        String fName = TclIO.getNextDescriptor(interp, "resource");
        this.setChanName(fName);
        return fName;
    }

    @Override
    void implClose() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("ResourceChannel.close(): null file object");
        }
        this.file.close();
        this.file = null;
    }

    @Override
    String getChanType() {
        return "resource";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.file;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        throw new IOException("ResourceChannel: output stream not available");
    }
}

