/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public abstract class SeekableChannel
extends Channel {
    abstract void implSeek(long var1) throws IOException;

    abstract long implTell() throws IOException;

    abstract long getMaxSeek() throws IOException;

    @Override
    public void seek(Interp interp, long offset, int mode) throws IOException, TclException {
        if (!this.setOwnership(true, 1)) {
            throw new TclException(interp, "channel is busy");
        }
        if (!this.setOwnership(true, 2)) {
            this.setOwnership(false, 1);
            throw new TclException(interp, "channel is busy");
        }
        try {
            int inputBuffered = this.getNumBufferedInputBytes();
            int outputBuffered = this.getNumBufferedOutputBytes();
            if (inputBuffered != 0 && outputBuffered != 0) {
                throw new TclPosixException(interp, 14, true, "error during seek on \"" + this.getChanName() + "\"");
            }
            if (mode == 2) {
                offset -= (long)inputBuffered;
            }
            this.seekReset();
            boolean wasAsync = false;
            if (!this.getBlocking()) {
                wasAsync = true;
                this.setBlocking(true);
            }
            if (this.firstWriter != null) {
                this.flush(interp);
            }
            long actual_offset = switch (mode) {
                case 1 -> offset;
                case 2 -> this.implTell() + offset;
                case 3 -> this.getMaxSeek() + offset;
                default -> throw new TclRuntimeError("invalid seek mode");
            };
            if (actual_offset < 0L) {
                throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
            }
            this.implSeek(actual_offset);
            if (wasAsync) {
                this.setBlocking(false);
            }
        }
        finally {
            this.setOwnership(false, 2);
            this.setOwnership(false, 1);
        }
    }

    @Override
    public long tell() throws IOException {
        long filepos = this.implTell();
        int inputBuffered = this.getNumBufferedInputBytes();
        int outputBuffered = this.getNumBufferedOutputBytes();
        if (inputBuffered != 0 && outputBuffered != 0) {
            return -1L;
        }
        if (filepos == -1L) {
            return -1L;
        }
        if (inputBuffered != 0) {
            return filepos - (long)inputBuffered;
        }
        return filepos + (long)outputBuffered;
    }

    void seekReset() {
        if (this.inputBuffer != null) {
            this.inputBuffer.seekReset();
        }
        if (this.eolInputFilter != null) {
            this.eolInputFilter.seekReset();
        }
        if (this.eofInputFilter != null) {
            this.eofInputFilter.seekReset();
        }
        if (this.unicodeDecoder != null) {
            this.unicodeDecoder.seekReset();
        }
        if (this.markableInputStream != null) {
            this.markableInputStream.seekReset();
        }
        this.eofSeen = false;
    }

    void prepareForAppendWrite() throws IOException {
        this.implSeek(this.getMaxSeek());
    }

    @Override
    void setEofSeenWithoutRead() {
        try {
            if (this.getNumBufferedInputBytes() == 0 && this.implTell() >= this.getMaxSeek()) {
                this.eofSeen = true;
            }
        }
        catch (IOException iOException) {}
    }
}

