/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.AbstractSocketChannel;

public class SocketChannel
extends AbstractSocketChannel {
    private Socket sock = null;
    private IOException connectException = null;
    private Thread asyncConnectThread = null;
    InetAddress localAddress = null;
    InetAddress addr = null;
    InputStream istream = null;
    OutputStream ostream = null;
    Object asyncNotifier = new Object();

    public SocketChannel(Interp interp, int mode, String localAddr, final int localPort, boolean async, String address, final int port) throws IOException, TclException {
        if (!localAddr.equals("")) {
            try {
                this.localAddress = InetAddress.getByName(localAddr);
            }
            catch (UnknownHostException unknownHostException) {
                throw new TclException(interp, "host unknown: " + localAddr);
            }
        }
        try {
            this.addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException unknownHostException) {
            throw new TclException(interp, "host unknown: " + address);
        }
        this.mode = mode;
        if (async) {
            this.asyncConnectThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SocketChannel.this.connectSocket(SocketChannel.this.addr, port, SocketChannel.this.localAddress, localPort);
                }
            });
            this.asyncConnectThread.setDaemon(true);
            this.asyncConnectThread.setName("SocketChannel (" + interp.toString() + "): " + address + ":" + port);
            this.asyncConnectThread.start();
        } else {
            this.connectSocket(this.addr, port, this.localAddress, localPort);
            if (this.connectException != null) {
                throw this.connectException;
            }
        }
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
    }

    public SocketChannel(Interp interp, Socket s) throws IOException, TclException {
        this.mode = 4;
        this.sock = s;
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectSocket(InetAddress addr, int port, InetAddress localAddress, int localPort) {
        try {
            Socket s = new Socket(addr, port, localAddress, localPort);
            Object object = this.asyncNotifier;
            synchronized (object) {
                this.sock = s;
                this.asyncNotifier.notifyAll();
            }
        }
        catch (IOException e) {
            SocketChannel socketChannel = this;
            synchronized (socketChannel) {
                this.connectException = e;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() {
        if (this.asyncConnectThread == null) {
            return;
        }
        Object object = this.asyncNotifier;
        synchronized (object) {
            while (this.sock == null && this.connectException == null) {
                try {
                    this.asyncNotifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        Object object = this.asyncNotifier;
        synchronized (object) {
            if (this.asyncConnectThread != null) {
                this.asyncConnectThread.interrupt();
            }
            if (this.sock != null) {
                this.sock.close();
            }
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.istream == null) {
            this.istream = new InputStream(){

                @Override
                public int read() throws IOException {
                    SocketChannel.this.waitForConnection();
                    if (SocketChannel.this.sock != null) {
                        return SocketChannel.this.sock.getInputStream().read();
                    }
                    if (SocketChannel.this.connectException != null) {
                        throw SocketChannel.this.connectException;
                    }
                    throw new IOException("socket is null");
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    SocketChannel.this.waitForConnection();
                    if (SocketChannel.this.sock != null) {
                        return SocketChannel.this.sock.getInputStream().read(b, off, len);
                    }
                    if (SocketChannel.this.connectException != null) {
                        throw SocketChannel.this.connectException;
                    }
                    throw new IOException("socket is null");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int available() throws IOException {
                    Object object = SocketChannel.this.asyncNotifier;
                    synchronized (object) {
                        block4: {
                            if (SocketChannel.this.sock != null) break block4;
                            return 0;
                        }
                        return SocketChannel.this.sock.getInputStream().available();
                    }
                }
            };
        }
        return this.istream;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (this.ostream == null) {
            this.ostream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    SocketChannel.this.waitForConnection();
                    if (SocketChannel.this.sock == null) {
                        if (SocketChannel.this.connectException != null) {
                            throw SocketChannel.this.connectException;
                        }
                        throw new IOException("socket is null");
                    }
                    SocketChannel.this.sock.getOutputStream().write(b);
                }

                @Override
                public void flush() throws IOException {
                    SocketChannel.this.waitForConnection();
                    if (SocketChannel.this.sock == null) {
                        if (SocketChannel.this.connectException != null) {
                            throw SocketChannel.this.connectException;
                        }
                        throw new IOException("socket is null");
                    }
                    SocketChannel.this.sock.getOutputStream().flush();
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    SocketChannel.this.waitForConnection();
                    if (SocketChannel.this.sock == null) {
                        if (SocketChannel.this.connectException != null) {
                            throw SocketChannel.this.connectException;
                        }
                        throw new IOException("socket is null");
                    }
                    SocketChannel.this.sock.getOutputStream().write(b, off, len);
                }
            };
        }
        return this.ostream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TclObject getError(Interp interp) throws TclException {
        SocketChannel socketChannel = this;
        synchronized (socketChannel) {
            return TclString.newInstance(this.connectException == null ? "" : this.connectException.getMessage());
        }
    }

    @Override
    InetAddress getLocalAddress() {
        this.waitForConnection();
        return this.sock == null ? null : this.sock.getLocalAddress();
    }

    @Override
    int getLocalPort() {
        this.waitForConnection();
        return this.sock == null ? null : Integer.valueOf(this.sock.getLocalPort());
    }

    @Override
    InetAddress getPeerAddress() {
        this.waitForConnection();
        return this.sock.getInetAddress();
    }

    @Override
    int getPeerPort() {
        this.waitForConnection();
        return this.sock.getPort();
    }
}

