/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.channel.SocketChannel;

public class SocketConnectionEvent
extends TclEvent {
    Interp cbInterp;
    TclObject callbackCmd;
    Socket sock;
    ServerSocket serverSock;

    public SocketConnectionEvent(Interp interp, TclObject callbackObj, Socket sock, ServerSocket serverSock) {
        this.cbInterp = interp;
        this.callbackCmd = callbackObj;
        this.sock = sock;
        this.serverSock = serverSock;
    }

    @Override
    public int processEvent(int flags) {
        if (this.serverSock.isClosed()) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {}
            return 1;
        }
        SocketChannel chan = null;
        try {
            chan = new SocketChannel(this.cbInterp, this.sock);
        }
        catch (IOException e1) {
            new TclException(this.cbInterp, e1.getMessage());
            this.cbInterp.backgroundError();
            return 1;
        }
        catch (TclException tclException) {
            this.cbInterp.backgroundError();
            return 1;
        }
        TclIO.registerChannel(this.cbInterp, chan);
        StringBuffer cblist = new StringBuffer();
        cblist.append(this.callbackCmd.toString());
        cblist.append(" ");
        cblist.append(chan.getChanName());
        cblist.append(" ");
        cblist.append(this.sock.getInetAddress().getHostAddress());
        cblist.append(" ");
        cblist.append("" + this.sock.getPort());
        try {
            this.cbInterp.eval(cblist.toString(), 131072);
        }
        catch (TclException tclException) {
            this.cbInterp.addErrorInfo("\n  during server socket callback \n");
            this.cbInterp.backgroundError();
        }
        return 1;
    }
}

