/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import tcl.lang.ManagedSystemInStream;
import tcl.lang.TclRuntimeError;
import tcl.lang.channel.Channel;

public class StdChannel
extends Channel {
    private int stdType = -1;
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    static InputStream _in = new ManagedSystemInStream();
    static OutputStream _out = System.out;
    static OutputStream _err = System.err;

    @Deprecated
    public static void setIn(InputStream in) {
        _in = in;
    }

    @Deprecated
    public static void setOut(PrintStream out) {
        _out = out;
    }

    @Deprecated
    public static void setErr(PrintStream err) {
        _err = err;
    }

    StdChannel() {
    }

    StdChannel(String stdName) {
        if (stdName.equals("stdin")) {
            this.open(0);
        } else if (stdName.equals("stdout")) {
            this.open(1);
        } else if (stdName.equals("stderr")) {
            this.open(2);
        } else {
            throw new TclRuntimeError("Error: unexpected type for StdChannel");
        }
    }

    public StdChannel(int type) {
        this.open(type);
    }

    String open(int type) {
        switch (type) {
            case 0: {
                this.mode = 1;
                this.setBuffering(1);
                this.setChanName("stdin");
                break;
            }
            case 1: {
                this.mode = 2;
                this.setBuffering(1);
                this.setChanName("stdout");
                break;
            }
            case 2: {
                this.mode = 2;
                this.setBuffering(2);
                this.setChanName("stderr");
                break;
            }
            default: {
                throw new RuntimeException("type does not match one of STDIN, STDOUT, or STDERR");
            }
        }
        this.stdType = type;
        return this.getChanName();
    }

    @Override
    void implClose() throws IOException {
    }

    @Override
    String getChanType() {
        return "tty";
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (this.stdType == 0) {
            return _in;
        }
        throw new RuntimeException("Should never be called");
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        switch (this.stdType) {
            case 1: {
                return _out;
            }
            case 2: {
                return _err;
            }
        }
        throw new RuntimeException("should never be called");
    }
}

