/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang.channel;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import tcl.lang.channel.MarkableInputStream;
import tcl.lang.cmd.EncodingCmd;

class UnicodeDecoder
extends Reader {
    MarkableInputStream in = null;
    CharsetDecoder csd = null;
    String encoding = null;
    String requestedEncoding = null;
    boolean eofSeen = false;

    UnicodeDecoder(MarkableInputStream in, String encoding) {
        this.in = in;
        this.setEncoding(encoding);
    }

    void setEncoding(String encoding) {
        this.requestedEncoding = encoding;
    }

    private void setEncoding() {
        if (this.encoding == null && this.requestedEncoding == null) {
            return;
        }
        if (this.encoding != null && this.encoding.equals(this.requestedEncoding)) {
            return;
        }
        this.encoding = this.requestedEncoding;
        if (this.encoding != null && !"symbol".equals(this.encoding)) {
            Charset cs = Charset.forName(this.encoding);
            this.csd = cs.newDecoder();
            this.csd.onMalformedInput(CodingErrorAction.REPLACE);
            this.csd.onUnmappableCharacter(CodingErrorAction.REPLACE);
        } else {
            this.csd = null;
        }
    }

    void seekReset() {
        if (this.csd != null) {
            this.csd.reset();
        }
        this.eofSeen = false;
    }

    void cancelEof() {
        this.eofSeen = false;
        if (this.csd != null) {
            this.csd.reset();
        }
    }

    int peek(boolean consume) throws IOException {
        if (this.eofSeen) {
            return -1;
        }
        int c = this.in.read();
        if (!consume) {
            this.in.unread(c);
        }
        return c;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.in.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        if (this.csd != null) {
            this.csd.reset();
        }
    }

    private int flushDecoder(CharBuffer cb, int origPos) {
        CoderResult result = this.csd.flush(cb);
        int cnt = cb.position() - origPos;
        if (result == CoderResult.OVERFLOW) {
            return cnt;
        }
        if (cnt == 0) {
            return -1;
        }
        return cnt;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.setEncoding();
        if (this.csd != null) {
            CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
            if (this.eofSeen) {
                return this.flushDecoder(cb, off);
            }
            int byteArraySize = len < 16 ? 16 : len;
            byte[] byteArray = new byte[byteArraySize];
            ByteBuffer bb = ByteBuffer.wrap(byteArray);
            boolean zeroLengthRead = false;
            while (cb.position() - off == 0 && len > 0 && !zeroLengthRead) {
                if (bb.remaining() > 0 && !this.eofSeen) {
                    int cnt = this.in.read(byteArray, bb.position(), cb.remaining() > bb.remaining() ? bb.remaining() : cb.remaining());
                    if (cnt == -1) {
                        this.eofSeen = true;
                    } else {
                        bb.position(bb.position() + cnt);
                    }
                    zeroLengthRead = cnt == 0;
                }
                bb.flip();
                CoderResult result = this.csd.decode(bb, cb, this.eofSeen);
                if (result == CoderResult.UNDERFLOW && this.eofSeen) {
                    return this.flushDecoder(cb, off);
                }
                bb.compact();
            }
            bb.flip();
            while (bb.remaining() > 0) {
                this.eofSeen = false;
                this.in.unread(bb.get());
            }
            return cb.position() - off;
        }
        byte[] bbuf = new byte[len];
        int cnt = this.in.read(bbuf, 0, len);
        if (cnt == -1) {
            this.eofSeen = true;
            return -1;
        }
        if (this.encoding != null) {
            EncodingCmd.decodeSymbol(bbuf, cbuf, off, cnt);
        } else {
            int i = 0;
            while (i < cnt) {
                cbuf[i + off] = (char)(bbuf[i] & 0xFF);
                ++i;
            }
        }
        return cnt;
    }
}

